/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.topbar;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.MikeDeviceFilterUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;
import com.yy.game.module.gameroom.topbar.BaseInfoView;
import com.yy.game.module.gameroom.topbar.GamePkTopBar;
import com.yy.game.module.gameroom.topbar.ITopBarItemViewOnClick;

public class CustomerTopBar
extends GamePkTopBar {
    private RelativeLayout mContainer;
    private ITopBarItemViewOnClick mClickLisenter;
    private BaseInfoView mLeftUserView;
    private BaseInfoView mRigthUserView;
    private YYImageView mBackIcon;
    private YYImageView mMicIcon;
    private YYImageView mCenterLogo;

    public CustomerTopBar(ITopBarItemViewOnClick click) {
        super(click);
    }

    @Override
    public View getView(Context context) {
        if (this.mContainer == null) {
            this.mContainer = new YYRelativeLayout(context);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            layoutParams.setMargins(0, ResourceUtils.getDimen((int)R.dimen.ver_game_top_padding), 0, 0);
            this.mContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            int iconsize = ResourceUtils.getDimen((int)R.dimen.game_icon_size);
            int backPaddingTopBottom = ResolutionUtils.dip2Px((float)5.0f);
            int backleftMargin = ResourceUtils.getDimen((int)R.dimen.game_back_left_margin);
            RelativeLayout.LayoutParams backLayoutParams = new RelativeLayout.LayoutParams(iconsize - backPaddingTopBottom, iconsize - backPaddingTopBottom);
            this.mBackIcon = new YYImageView(context);
            this.mBackIcon.setId(R.id.top_bar_back);
            this.mBackIcon.setContentDescription((CharSequence)"back");
            if (Build.VERSION.SDK_INT >= 17) {
                backLayoutParams.setMarginStart(backleftMargin);
            }
            backLayoutParams.addRule(15);
            if (Build.VERSION.SDK_INT >= 17) {
                backLayoutParams.addRule(20);
            }
            backLayoutParams.addRule(9);
            this.mBackIcon.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.nav_back_round_white));
            this.mBackIcon.setLayoutParams((ViewGroup.LayoutParams)backLayoutParams);
            this.mContainer.addView((View)this.mBackIcon);
            this.mBackIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CustomerTopBar.this.mUICallBack.onBackClick();
                }
            });
            int micRightIcon = ResourceUtils.getDimen((int)R.dimen.game_mic_right_margin);
            this.mMicIcon = new YYImageView(context);
            this.mMicIcon.setId(R.id.top_bar_mic);
            RelativeLayout.LayoutParams micLayoutParams = new RelativeLayout.LayoutParams(iconsize, iconsize);
            if (Build.VERSION.SDK_INT >= 17) {
                micLayoutParams.setMarginEnd(micRightIcon);
            }
            micLayoutParams.addRule(11);
            if (Build.VERSION.SDK_INT >= 17) {
                micLayoutParams.addRule(21);
            }
            micLayoutParams.addRule(15);
            this.mMicIcon.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.btn_mic_selector));
            this.mMicIcon.setLayoutParams((ViewGroup.LayoutParams)micLayoutParams);
            this.mContainer.addView((View)this.mMicIcon);
            this.mMicIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MikeDeviceFilterUtils.needClickDelay()) {
                        return;
                    }
                    CustomerTopBar.this.mUICallBack.onMicClick();
                    if (v.isSelected()) {
                        v.setSelected(false);
                    }
                }
            });
        }
        return this.mContainer;
    }

    @Override
    public void updateMyInfoView(UserInfoKS userInfoBean) {
    }

    @Override
    public void updateOtherInfoView(UserInfoKS userInfoBean) {
    }

    @Override
    public void updateMicView(boolean voiceState) {
        this.mMicIcon.setActivated(voiceState);
    }

    @Override
    public void updateLeftVoice(boolean isSpeaking) {
        if (this.mLeftUserView != null) {
            if (isSpeaking) {
                this.mLeftUserView.setMicStatusSpeaking();
            } else {
                this.mLeftUserView.setMicStatusNoSpeaking();
            }
        }
    }

    @Override
    public void updateRightVoice(boolean isSpeaking) {
        if (this.mRigthUserView != null) {
            if (isSpeaking) {
                this.mRigthUserView.setMicStatusSpeaking();
            } else {
                this.mRigthUserView.setMicStatusNoSpeaking();
            }
        }
    }

    @Override
    public void updateMicStatusView(long uid, boolean voiceState) {
    }

    @Override
    public void showBackBtn(boolean isHide) {
        if (this.mBackIcon == null) {
            return;
        }
        if (isHide) {
            this.mBackIcon.setVisibility(0);
        } else {
            this.mBackIcon.setVisibility(8);
        }
    }

    @Override
    public void showMicBtn(boolean isShow) {
        if (this.mMicIcon == null) {
            return;
        }
        if (isShow) {
            this.mMicIcon.setVisibility(0);
        } else {
            this.mMicIcon.setVisibility(8);
        }
    }

    @Override
    public void updateOtherHeadFrameType(String headFrameUrl) {
        if (this.mRigthUserView != null) {
            this.mRigthUserView.updateHeadFrameType(headFrameUrl);
        }
    }

    @Override
    public void updateMyHeadFrameType(String headFrameUrl) {
        if (this.mLeftUserView != null) {
            this.mLeftUserView.updateHeadFrameType(headFrameUrl);
        }
    }
}

