/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.topbar;

import android.content.Context;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import android.widget.TextView;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.appbase.ui.widget.waveview.WaveView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;

public class BaseInfoView
extends YYRelativeLayout {
    protected TextView mTvName;
    protected HeadFrameImageView userHead;
    protected RecycleImageView userSex;
    protected RecycleImageView micStatus;
    protected WaveView mWvVoice;
    protected boolean isVoiceOpen = false;

    public BaseInfoView(Context context) {
        super(context);
    }

    public BaseInfoView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BaseInfoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setNameTextMaxWidth(int width) {
        if (this.mTvName == null) {
            return;
        }
        this.mTvName.setMaxWidth(width);
    }

    public void initWaveView() {
        if (this.mWvVoice != null) {
            this.mWvVoice.setDuration(5000L);
            this.mWvVoice.setStyle(Paint.Style.FILL);
            this.mWvVoice.setColor(ResourceUtils.getColor((int)R.color.wave_color));
            this.mWvVoice.setInterpolator((Interpolator)new LinearOutSlowInInterpolator());
            this.mWvVoice.setInitialRadius((float)(ResourceUtils.getDimen((int)R.dimen.game_room_avatar_size) / 2));
        }
    }

    private void startWaveView() {
        if (this.mWvVoice != null && this.isVoiceOpen) {
            this.mWvVoice.start();
        }
        if (this.userHead != null) {
            this.userHead.getCircleImageView().setBorderColor(-16733688);
        }
    }

    private void stopWaveView() {
        if (this.mWvVoice != null) {
            this.mWvVoice.stop();
        }
    }

    public void updateView(UserInfoKS userInfo) {
        if (userInfo != null) {
            Kvo.autoBindingTo((KvoSource)userInfo, (Object)((Object)this));
        }
    }

    public void setMicStatusOpen() {
        this.isVoiceOpen = true;
        if (this.micStatus != null) {
            this.micStatus.setImageResource(R.drawable.small_mic_open);
        }
        if (this.userHead != null) {
            this.userHead.getCircleImageView().setBorderColor(-16733688);
        }
    }

    public void setMicStatusSpeaking() {
        this.startWaveView();
    }

    public void setMicStatusNoSpeaking() {
        this.stopWaveView();
    }

    public void setMicStatusClose() {
        this.isVoiceOpen = false;
        this.stopWaveView();
        if (this.micStatus != null) {
            this.micStatus.setImageResource(R.drawable.small_mic_close);
        }
        if (this.userHead != null) {
            this.userHead.getCircleImageView().setBorderColor(-1);
        }
    }

    public void updateHeadFrameType(String headFrameUrl) {
        if (this.userHead != null) {
            this.userHead.setHeadFrame(headFrameUrl);
        }
    }
}

