/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.expressionbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;
import com.yy.game.bean.EmojiBean;
import com.yy.game.bean.EmojiList;
import com.yy.game.module.gameroom.expressionbar.BaseExpressionBar;
import com.yy.game.module.gameroom.expressionbar.IExpressionClickListenser;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VerExpressionBar
extends BaseExpressionBar {
    private LinearLayout mContainer;

    public VerExpressionBar(IExpressionClickListenser click) {
        super(click);
    }

    @Override
    @NotNull
    @SuppressLint(value={"LoopUsage"})
    public View getView(Context context) {
        if (this.mContainer == null) {
            this.mContainer = new YYLinearLayout(context);
            this.mContainer.setOrientation(0);
            this.mContainer.setGravity(17);
            for (int i = 0; i < EmojiList.imglist.size(); ++i) {
                RecycleImageView imgView = new RecycleImageView(context);
                LinearLayout.LayoutParams layout2 = new LinearLayout.LayoutParams(ResourceUtils.getDimen((int)R.dimen.game_express_size), ResourceUtils.getDimen((int)R.dimen.game_express_size));
                if (LanguageUtils.isRtl()) {
                    layout2.setMargins(ResourceUtils.getDimen((int)R.dimen.game_express_margin), 0, 0, 0);
                } else {
                    layout2.setMargins(0, 0, ResourceUtils.getDimen((int)R.dimen.game_express_margin), 0);
                }
                if (EmojiList.imglist.indexOf(EmojiList.imglist.get(i)) == EmojiList.imglist.size() - 1) {
                    layout2.setMargins(0, 0, 0, 0);
                }
                imgView.setLayoutParams((ViewGroup.LayoutParams)layout2);
                EmojiBean.Builder builder = EmojiBean.newBuilder();
                EmojiBean bean = builder.id(i).build();
                imgView.setTag((Object)bean);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"VerExpressionBar", (String)(bean.getId() + ", " + i), (Object[])new Object[0]);
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    try {
                        imgView.setStateListAnimator(ResourceUtils.getStateListAnimator((int)R.animator.emojiselector));
                    }
                    catch (Resources.NotFoundException e) {
                        MLog.error((Object)"VerExpressionBar", (Throwable)e);
                    }
                }
                imgView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (VerExpressionBar.this.mUICallBack != null) {
                            VerExpressionBar.this.mUICallBack.sendExpress((EmojiBean)v.getTag());
                        }
                    }
                });
                ImageLoader.loadImage((RecycleImageView)imgView, (int)EmojiList.imglist.get(i));
                this.mContainer.addView((View)imgView);
            }
        }
        return this.mContainer;
    }

    @Override
    public void updateView(List<EmojiBean> list, Context context) {
    }
}

