/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.expressionbar;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;
import com.yy.game.bean.EmojiBean;
import com.yy.game.bean.EmojiList;
import com.yy.game.module.gameroom.expressionbar.BaseExpressionBar;
import com.yy.game.module.gameroom.expressionbar.IExpressionClickListenser;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HorExpressionBar
extends BaseExpressionBar {
    private List<RecycleImageView> expresslist = new ArrayList<RecycleImageView>(4);

    public HorExpressionBar(IExpressionClickListenser click) {
        super(click);
    }

    @Override
    @NotNull
    public View getView(Context context) {
        if (this.mContainer == null) {
            this.mContainer = new YYLinearLayout(context);
            this.mContainer.setOrientation(1);
            this.mContainer.setGravity(16);
            for (int i = 0; i < EmojiList.imglist.size(); ++i) {
                RecycleImageView imgView = new RecycleImageView(context);
                LinearLayout.LayoutParams layout2 = new LinearLayout.LayoutParams(ResourceUtils.getDimen((int)R.dimen.game_express_size), ResourceUtils.getDimen((int)R.dimen.game_express_size));
                layout2.setMargins(0, 0, 0, ResourceUtils.getDimen((int)R.dimen.game_express_margin));
                if (EmojiList.imglist.indexOf(i) == EmojiList.imglist.size() - 1) {
                    layout2.setMargins(0, 0, 0, 0);
                }
                imgView.setLayoutParams((ViewGroup.LayoutParams)layout2);
                if (Build.VERSION.SDK_INT >= 21) {
                    imgView.setStateListAnimator(ResourceUtils.getStateListAnimator((int)R.animator.emojiselector));
                }
                EmojiBean.Builder builder = EmojiBean.newBuilder();
                EmojiBean bean = builder.id(i).build();
                imgView.setTag((Object)bean);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"HorExpressionBar", (String)(bean.getId() + ", " + i), (Object[])new Object[0]);
                }
                imgView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (HorExpressionBar.this.mUICallBack != null) {
                            HorExpressionBar.this.mUICallBack.sendExpress((EmojiBean)v.getTag());
                        }
                    }
                });
                this.expresslist.add(imgView);
                ImageLoader.loadImage((RecycleImageView)imgView, (int)EmojiList.imglist.get(i));
                this.mContainer.addView((View)imgView);
            }
        }
        return this.mContainer;
    }

    @Override
    public void updateView(List<EmojiBean> list, Context context) {
        if (this.mContainer == null) {
            return;
        }
        this.mContainer.removeAllViews();
        for (EmojiBean emoji : list) {
            RecycleImageView imgView = new RecycleImageView(context);
            LinearLayout.LayoutParams layout2 = new LinearLayout.LayoutParams(ResourceUtils.getDimen((int)R.dimen.game_express_size), ResourceUtils.getDimen((int)R.dimen.game_express_size));
            layout2.setMargins(0, ResourceUtils.getDimen((int)R.dimen.game_express_margin), 0, 0);
            if (list.indexOf(emoji) == list.size() - 1) {
                layout2.setMargins(0, 0, 0, 0);
            }
            imgView.setLayoutParams((ViewGroup.LayoutParams)layout2);
            imgView.setTag((Object)emoji);
            this.expresslist.add(imgView);
            ImageLoader.loadImage((RecycleImageView)imgView, (String)emoji.getResourceUrl());
            this.mContainer.addView((View)imgView);
        }
    }
}

