/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.expressionbar;

import android.content.Context;
import android.view.View;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Environment;
import com.yy.game.bean.EmojiBean;
import com.yy.game.gamemodule.base.ui.BaseGameContentViewController;
import com.yy.game.module.gameroom.expressionbar.BaseExpressionBar;
import com.yy.game.module.gameroom.expressionbar.HorExpressionBar;
import com.yy.game.module.gameroom.expressionbar.IExpressBarUiCallback;
import com.yy.game.module.gameroom.expressionbar.IExpressionClickListenser;
import com.yy.game.module.gameroom.expressionbar.VerExpressionBar;
import com.yy.hiyo.game.base.bean.GameInfo;
import java.util.HashMap;

public class ExpressBarController
extends BaseGameContentViewController
implements IExpressionClickListenser {
    private static final String TAG = "ExpressBarController";
    private GameInfo mCurrentGame;
    private BaseExpressionBar mCurrentExpressBar;
    private final HashMap<Integer, BaseExpressionBar> mExpressBarControllers = new HashMap();
    private IExpressBarUiCallback mExpressBarCallback;

    public ExpressBarController(IExpressBarUiCallback callBack, Environment env) {
        super(callBack, env);
        this.mExpressBarCallback = callBack;
    }

    public View getExpressBar(GameInfo gameInfo) {
        if (gameInfo == null) {
            MLog.warn((Object)TAG, (String)"create top bar with template is null", (Object[])new Object[0]);
            return null;
        }
        this.mCurrentGame = gameInfo;
        View resultView = null;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"create top bar with mCurrentType type: %s, mCurrentTemplate: %s", (Object[])new Object[]{gameInfo.toString(), this.mCurrentGame.toString()});
        }
        BaseExpressionBar expressionBar = null;
        if (gameInfo.getRoomTemplate() == 1) {
            expressionBar = this.mExpressBarControllers.get(gameInfo.getScreenDire());
            if (expressionBar == null) {
                if (gameInfo.getScreenDire() == 1) {
                    expressionBar = new VerExpressionBar(this);
                } else if (gameInfo.getScreenDire() == 2) {
                    expressionBar = new HorExpressionBar(this);
                }
                this.mExpressBarControllers.put(gameInfo.getScreenDire(), expressionBar);
            }
        } else {
            expressionBar = new VerExpressionBar(this);
        }
        resultView = ((BaseExpressionBar)expressionBar).getView((Context)this.mContext);
        this.mCurrentExpressBar = expressionBar;
        return resultView;
    }

    public View getExpressBar() {
        return new VerExpressionBar(this).getView((Context)this.mContext);
    }

    public View getHorExpressBar() {
        return new HorExpressionBar(this).getView((Context)this.mContext);
    }

    @Override
    public void sendExpress(EmojiBean bean) {
        if (this.mExpressBarCallback != null) {
            this.mExpressBarCallback.onSendEmotionClick(bean);
        }
    }
}

