/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.barrageview;

import android.app.Activity;
import android.content.Context;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.service.IUserInfoService;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.game.gamemodule.base.ui.BaseGameContentViewController;
import com.yy.game.module.gameroom.barrageview.IBarrageViewUiCallback;
import com.yy.game.module.gameroom.barrageview.IMessageBarrageUICallback;
import com.yy.game.module.gameroom.barrageview.MessageBarrageInputDialog;
import com.yy.game.module.gameroom.barrageview.MessageBarrageView;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.helper.GameModeHelper;
import java.util.ArrayList;
import java.util.List;

public class MessageBarrageViewController
extends BaseGameContentViewController
implements IMessageBarrageUICallback {
    public static final String TAG = "MessageBarrageViewController";
    private MessageBarrageView messageBarrageView;
    private MessageBarrageInputDialog inputDialog;
    private GameInfo mGameInfo;
    private List<String> defaultMsgs;
    private IBarrageViewUiCallback mBarrageCallback;

    public MessageBarrageViewController(IBarrageViewUiCallback callBack, Environment env) {
        super(callBack, env);
        this.mBarrageCallback = callBack;
    }

    public MessageBarrageView getMessageBarrageView(GameInfo gameInfo) {
        if (gameInfo == null) {
            MLog.warn((Object)TAG, (String)"create MessageBarrageView with gameInfo is null", (Object[])new Object[0]);
            return null;
        }
        this.mGameInfo = gameInfo;
        if (this.messageBarrageView == null) {
            this.messageBarrageView = new MessageBarrageView((Context)this.mContext);
        }
        this.messageBarrageView.updateEntranceVisible(gameInfo.isQuickNews());
        this.messageBarrageView.setCallback(new MessageBarrageView.IEntranceCallback(){

            @Override
            public void onEntranceClick() {
                MessageBarrageViewController.this.showInputView(false);
            }
        });
        return this.messageBarrageView;
    }

    public void showInputView() {
        this.showInputView(true);
    }

    private void showInputView(final boolean showIme) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (MessageBarrageViewController.this.inputDialog == null) {
                    MessageBarrageViewController.this.inputDialog = new MessageBarrageInputDialog((Activity)MessageBarrageViewController.this.mContext, MessageBarrageViewController.this, MessageBarrageViewController.this.defaultMsgs);
                    MessageBarrageViewController.this.inputDialog.setListData(MessageBarrageViewController.this.defaultMsgs);
                }
                MessageBarrageViewController.this.inputDialog.setShowIme(showIme);
                MessageBarrageViewController.this.inputDialog.setGameId(MessageBarrageViewController.this.mGameInfo != null ? MessageBarrageViewController.this.mGameInfo.getGid() : "");
                MessageBarrageViewController.this.mDialogLinkManager.showTransparentDialog((BaseDialog)MessageBarrageViewController.this.inputDialog);
            }
        });
    }

    public boolean isDialogShowing() {
        return this.mDialogLinkManager.isDialogShowing();
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mDialogLinkManager != null) {
            ImeUtil.hideIME((Activity)this.mContext);
            this.mDialogLinkManager.dismissDialog();
        }
    }

    @Override
    public void sendMessage(String message) {
        if (this.mGameInfo == null) {
            return;
        }
        if (this.mBarrageCallback != null) {
            UserInfoBean myUserInfo;
            this.mBarrageCallback.onSendMessageBarrage(message);
            if (this.mGameInfo != null && !GameModeHelper.isTeamMode((GameInfo)this.mGameInfo) && !GameModeHelper.is2V2Mode((GameInfo)this.mGameInfo) && (myUserInfo = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null)) != null && this.messageBarrageView != null) {
                this.messageBarrageView.showBarrageView(myUserInfo.getAvatar(), message, -1);
            }
        }
    }

    public void setMessageList(List<String> msgs) {
        ArrayList<String> retData = new ArrayList<String>();
        if (msgs != null) {
            if (msgs.size() > 5) {
                retData.addAll(msgs.subList(0, 5));
            } else {
                retData.addAll(msgs);
            }
        }
        this.defaultMsgs = retData;
        if (this.inputDialog != null) {
            this.inputDialog.setListData(retData);
        }
    }

    public void updateBarrageViewPosition(final String json) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                BarrageViewPosition barrageViewPosition;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)MessageBarrageViewController.TAG, (String)"updateBarrageViewPosition json:%s", (Object[])new Object[]{json});
                }
                if (StringUtils.isNotEmpty((String)json) && (barrageViewPosition = (BarrageViewPosition)JsonParser.parseJsonObject((String)json, BarrageViewPosition.class)) != null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MessageBarrageViewController.this.messageBarrageView.updateBarrageView(barrageViewPosition.barrageMarginTop);
                        }
                    });
                }
            }
        });
    }

    public static class BarrageViewPosition {
        @SerializedName(value="barrageMarginTop")
        public int barrageMarginTop;
    }
}

