/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.barrageview;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.yy.appbase.widget.barrage.Barrage;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.teammatch.ui.widget.BarrageShowTransView;

public class MessageBarrageView
extends YYRelativeLayout {
    private static final String TAG = "MessageBarrageView";
    private BarrageShowTransView mBarrageShowView;
    private RecycleImageView rvEntrance;
    private IEntranceCallback callback;

    public MessageBarrageView(Context context) {
        super(context);
        this.initView(context);
    }

    public void initView(Context context) {
        View view = MessageBarrageView.inflate((Context)context, (int)R.layout.game_message_layout, (ViewGroup)this);
        this.mBarrageShowView = (BarrageShowTransView)view.findViewById(R.id.view_barrage_show);
        this.rvEntrance = (RecycleImageView)view.findViewById(R.id.message_entrance);
        this.rvEntrance.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MessageBarrageView.this.callback != null) {
                    MessageBarrageView.this.callback.onEntranceClick();
                }
            }
        });
    }

    public void showBarrageView(String avatar, String msg, int bgColor) {
        this.mBarrageShowView.addBarrage(Barrage.builder().avatar(avatar).msg(msg).bgColor(bgColor).build());
    }

    public void updateEntranceVisible(boolean visible) {
        if (this.rvEntrance != null) {
            this.rvEntrance.setVisibility(visible ? 0 : 4);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mBarrageShowView.initBarrageView(2);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mBarrageShowView.clear();
    }

    public void updateBarrageView(int marginTop) {
        if (this.mBarrageShowView != null) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mBarrageShowView.getLayoutParams();
            params.topMargin = marginTop;
            this.mBarrageShowView.setLayoutParams((ViewGroup.LayoutParams)params);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"updateBarrageView, marginTop:%d", (Object[])new Object[]{marginTop});
            }
        }
    }

    public void setCallback(IEntranceCallback callback2) {
        this.callback = callback2;
    }

    public static interface IEntranceCallback {
        public void onEntranceClick();
    }
}

