/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom.barrageview;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.yy.appbase.ui.widget.FastInputCallBack;
import com.yy.appbase.ui.widget.FastInputView;
import com.yy.appbase.ui.widget.edit.FixEditTextView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.DeviceManager;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.game.R;
import com.yy.game.module.gameroom.barrageview.IMessageBarrageUICallback;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class MessageBarrageInputDialog
implements BaseDialog {
    private static final String TAG = "MessageBarrageInputDial";
    private FixEditTextView etInput;
    private YYImageView ivSend;
    private FastInputView fastInputView;
    private IMessageBarrageUICallback callback;
    private Dialog dialog;
    private Activity mAty;
    private List<String> defaultList;
    private boolean showIme = false;
    private ViewTreeObserver.OnGlobalLayoutListener viewListener;
    private boolean hasAutoShow = false;
    private String gameId = "";

    public MessageBarrageInputDialog(Activity aty, IMessageBarrageUICallback callback2, List<String> defaluList) {
        this.mAty = aty;
        this.callback = callback2;
        this.defaultList = defaluList;
    }

    public void init(Dialog dialog2) {
        this.dialog = dialog2;
        Window window = dialog2.getWindow();
        final View rootView = LayoutInflater.from((Context)dialog2.getContext()).inflate(R.layout.game_input_barrage_messgae_dialog, null);
        this.initView(rootView);
        window.setFlags(1024, 1024);
        dialog2.setContentView(rootView);
        dialog2.setCancelable(true);
        dialog2.setCanceledOnTouchOutside(true);
        WindowManager.LayoutParams params = window.getAttributes();
        params.gravity = 80;
        params.height = -1;
        params.width = -1;
        window.setAttributes(params);
        window.setWindowAnimations(R.style.DialogAnimation);
        window.clearFlags(8);
        window.setSoftInputMode(4);
        this.viewListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (MessageBarrageInputDialog.this.mAty != null && MessageBarrageInputDialog.this.mAty.getWindow().getDecorView().getHeight() - rootView.getHeight() > 100) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("function_id", "open_keyboard"));
                }
                if (MessageBarrageInputDialog.this.etInput.isFocused() && ScreenUtils.getScreenOrientation() == 1 && MessageBarrageInputDialog.this.showIme && !MessageBarrageInputDialog.this.hasAutoShow) {
                    MessageBarrageInputDialog.this.hasAutoShow = true;
                    if (MessageBarrageInputDialog.this.mAty != null) {
                        DeviceManager.showInputMethod((Activity)MessageBarrageInputDialog.this.mAty, (View)MessageBarrageInputDialog.this.etInput);
                    }
                }
            }
        };
        this.etInput.getViewTreeObserver().addOnGlobalLayoutListener(this.viewListener);
        InputFilter inputFilter = StringUtils.enterFilter();
        this.etInput.setFilters(new InputFilter[]{inputFilter, new InputFilter.LengthFilter(50)});
        dialog2.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog2) {
                if (MessageBarrageInputDialog.this.viewListener != null && MessageBarrageInputDialog.this.etInput != null && MessageBarrageInputDialog.this.etInput.getViewTreeObserver() != null) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        MessageBarrageInputDialog.this.etInput.getViewTreeObserver().removeOnGlobalLayoutListener(MessageBarrageInputDialog.this.viewListener);
                    } else {
                        MessageBarrageInputDialog.this.etInput.getViewTreeObserver().removeGlobalOnLayoutListener(MessageBarrageInputDialog.this.viewListener);
                    }
                }
            }
        });
    }

    public void setShowIme(boolean showIme) {
        this.showIme = showIme;
    }

    private void initView(View rootView) {
        this.etInput = (FixEditTextView)rootView.findViewById(R.id.et_input);
        this.ivSend = (YYImageView)rootView.findViewById(R.id.iv_send);
        this.fastInputView = (FastInputView)rootView.findViewById(R.id.fiv);
        this.fastInputView.setText(this.defaultList);
        this.etInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                MessageBarrageInputDialog.this.ivSend.setEnabled(StringUtils.isNotEmpty((String)s.toString()));
            }
        });
        this.fastInputView.setFastInputCallBack(new FastInputCallBack(){

            public void onFastInputClick(String text) {
                if (MessageBarrageInputDialog.this.callback != null) {
                    MessageBarrageInputDialog.this.callback.sendMessage(text);
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("function_id", "quick_msg").put("gid", MessageBarrageInputDialog.this.gameId));
                }
                ImeUtil.hideIME((Context)MessageBarrageInputDialog.this.mAty, (View)MessageBarrageInputDialog.this.etInput);
                MessageBarrageInputDialog.this.dialog.dismiss();
            }

            public void onFastInputVisible() {
            }
        });
        this.ivSend.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MessageBarrageInputDialog.this.callback != null) {
                    MessageBarrageInputDialog.this.callback.sendMessage(MessageBarrageInputDialog.this.etInput.getText().toString());
                    MessageBarrageInputDialog.this.etInput.setText((CharSequence)"");
                    ImeUtil.hideIME((Context)MessageBarrageInputDialog.this.mAty, (View)MessageBarrageInputDialog.this.etInput);
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("function_id", "enter_msg"));
                    MessageBarrageInputDialog.this.dialog.dismiss();
                }
            }
        });
        rootView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImeUtil.hideIME((Context)MessageBarrageInputDialog.this.mAty, (View)MessageBarrageInputDialog.this.etInput);
                MessageBarrageInputDialog.this.dialog.dismiss();
            }
        });
        this.ivSend.setEnabled(false);
    }

    public int getId() {
        return DialogId.BarrageInputDialog;
    }

    public void setListData(List<String> datas) {
        if (this.fastInputView != null) {
            this.fastInputView.setText(datas);
        }
    }

    public void setGameId(String gameId) {
        this.gameId = gameId;
    }
}

