/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameroom;

import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.game.bean.GameDataModel;
import com.yy.hiyo.game.base.GameResultBean;
import ikxd.gameresult.PKWinStreakPush;
import java.util.List;

public class StreakWinInterruptedHelper {
    private static final String TAG = "StreakWinInterruptedHelper";
    private long[] lastNotifyTimes;
    private static final String TIME_SPLIT = ";";
    private static final long ONCE_AT_MOST = 86400000L;
    private static final long TWICE_AT_MOST = 604800000L;

    public boolean checkStreakWinInterrupted(GameResultBean gameResult) {
        PKWinStreakPush pkWinStreakPush = GameDataModel.instance.getWinStreakData();
        if (pkWinStreakPush == null) {
            return false;
        }
        if (pkWinStreakPush.win_streak_count < 5L) {
            return false;
        }
        if (gameResult == null) {
            return false;
        }
        List winners = gameResult.getWinners();
        if (winners == null) {
            return false;
        }
        if (winners.contains(String.valueOf(AccountUtil.getUid()))) {
            return false;
        }
        return this.canNotify();
    }

    private boolean canNotify() {
        if (this.lastNotifyTimes == null) {
            this.loadLastNotifyTime();
        }
        long currentTime = System.currentTimeMillis();
        long interval1 = currentTime - this.lastNotifyTimes[0];
        long interval2 = currentTime - this.lastNotifyTimes[1];
        if (interval1 < 86400000L || interval2 < 86400000L) {
            return false;
        }
        return interval1 >= 604800000L || interval2 >= 604800000L;
    }

    private void loadLastNotifyTime() {
        this.lastNotifyTimes = new long[]{0L, 0L};
        String lastNotifyTimeString = SettingFlags.getStringValue((String)"winning_streak_interrupted_time");
        if (TextUtils.isEmpty((CharSequence)lastNotifyTimeString)) {
            return;
        }
        String[] timeStrings = lastNotifyTimeString.split(TIME_SPLIT);
        if (timeStrings == null) {
            return;
        }
        for (int i = 0; i < timeStrings.length && i < 2; ++i) {
            this.lastNotifyTimes[i] = StringUtils.parseLong((String)timeStrings[i]);
        }
    }

    public void saveNotifyTime() {
        if (this.lastNotifyTimes == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.lastNotifyTimes[0] < this.lastNotifyTimes[1]) {
            this.lastNotifyTimes[0] = currentTime;
        } else {
            this.lastNotifyTimes[1] = currentTime;
        }
        String saveString = "" + this.lastNotifyTimes[0] + TIME_SPLIT + this.lastNotifyTimes[1];
        SettingFlags.setStringValue((String)"winning_streak_interrupted_time", (String)saveString);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("saveNotifyTime :" + saveString), (Object[])new Object[0]);
        }
    }
}

