/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameresultshare;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.Environment;
import com.yy.game.R;
import com.yy.game.gamemodule.pkgame.gameresult.GameResultTipsManager;
import com.yy.game.module.gameresultshare.HagoShareHelper;
import com.yy.game.module.streakwin.StreakWinShareHelper;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.helper.ShortUrlUtil;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameResultShareService;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.IShareCallBack;
import com.yy.socialplatformbase.data.HagoShareData;
import com.yy.socialplatformbase.data.ShareData;
import java.io.File;
import java.util.Random;

public class GameResultShareService
extends DefaultController
implements IGameResultShareService {
    private static final String TAG = "GameResultShareService";
    private static final String SHARE_PAGE_HOST = "https://www.ihago.net";
    private static final String SHARE_PAGE_DEV_HOST = "https://ikxd-test.yy.com";
    private static final String SHARE_PAGE_TEST_HOST = "https://test.ihago.net";
    private static final String SHARE_PAGE_URL_PATH = "/a/indonesiasharepage/index.html?score=%s&isNewRecord=%s&gameId=%s&uid=%s&langCode=%s&h=%d";
    private static final String RELIVE_SHARE_PAGE_HOST = "https://www.ihago.net";
    private static final String RELIVE_SHARE_PAGE_TEST_HOST = "https://test.ihago.net";
    private static final String RELIVE_SHARE_PAGE_URL_PATH = "/a/hagosharegame/index.html?bestScore=%s&gameId=%s&gameName=%s&uid=%s&type=%s&langCode=%s&h=%d";
    private static final String TO_SINGLE_GAME = "hago://game/singleGame/centre?gameId=%s&autoDownload=true";
    private static final String LANG_CODE = SystemUtils.getLangAndCountry();
    private static final String IMAGE_NAME = "game_result_share.png";
    private static final String RELIVE_SHARE_IMAGE_NAME = "game_relive_share";
    private Paint mTitlePaint;
    private Paint mScorePaint;
    private Paint mScoreTipsPaint;
    private Paint mSlogonPaint;
    private Random mRandom;
    private int mType = 0;
    private static String SINGLE_GAME_RELIVE_SHARE_IMAGE_PATH = null;

    public GameResultShareService(Environment env) {
        super(env);
    }

    private void init() {
        if (this.mTitlePaint != null) {
            return;
        }
        this.mTitlePaint = new Paint();
        this.mTitlePaint.setAntiAlias(true);
        this.mTitlePaint.setTextSize(60.0f);
        this.mTitlePaint.setColor(-1);
        this.mTitlePaint.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mScorePaint = new Paint();
        this.mScorePaint.setAntiAlias(true);
        this.mScorePaint.setTextSize(198.0f);
        this.mScorePaint.setColor(this.mContext.getResources().getColor(R.color.game_result_share_score));
        this.mScorePaint.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mScoreTipsPaint = new Paint();
        this.mScoreTipsPaint.setAntiAlias(true);
        this.mScoreTipsPaint.setTextSize(44.0f);
        this.mScoreTipsPaint.setColor(-1);
        this.mScoreTipsPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT_BOLD, (int)1));
        this.mScoreTipsPaint.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mSlogonPaint = new Paint();
        this.mSlogonPaint.setAntiAlias(true);
        this.mSlogonPaint.setTextSize(26.0f);
        this.mSlogonPaint.setColor(this.mContext.getResources().getColor(R.color.game_result_share_slogan));
        this.mSlogonPaint.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
    }

    private void shareInner(final int channelId, final String gameId, final String gameName, final String bgUrl, final int score, final boolean isHistoryBestScore, final boolean isWeekBestScore, final IShareCallBack callBack, final boolean singleGameReliveShare) {
        this.init();
        if (singleGameReliveShare) {
            if (this.mRandom == null) {
                this.mRandom = new Random();
            }
            this.mType = this.mRandom.nextInt(3);
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                final GameInfo info = ((IGameInfoService)GameResultShareService.this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
                if (info == null) {
                    return;
                }
                if (channelId == 2) {
                    String url = GameResultShareService.this.genShareLink(score, GameResultShareService.this.getNewRecordType(isHistoryBestScore, isWeekBestScore), gameId, gameName, AccountUtil.getUid(), LANG_CODE, singleGameReliveShare);
                    ShortUrlUtil.getShortUrl((String)url, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

                        public void onSuccess(String input, String shortUrl) {
                            GameResultShareService.this.doImageShare(shortUrl, singleGameReliveShare, gameName, channelId, callBack, bgUrl, gameId, info, score, isHistoryBestScore, isWeekBestScore);
                        }

                        public void onError(String input, int code, String msg) {
                            GameResultShareService.this.doImageShare(input, singleGameReliveShare, gameName, channelId, callBack, bgUrl, gameId, info, score, isHistoryBestScore, isWeekBestScore);
                        }
                    });
                } else if (channelId == 1) {
                    String url = GameResultShareService.this.genShareLink(score, GameResultShareService.this.getNewRecordType(isHistoryBestScore, isWeekBestScore), gameId, gameName, AccountUtil.getUid(), LANG_CODE, singleGameReliveShare);
                    ShortUrlUtil.getShortUrl((String)url, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

                        public void onSuccess(String input, String shortUrl) {
                            String text = GameResultShareService.this.genShareText(shortUrl, singleGameReliveShare, gameName);
                            GameResultShareService.this.processImageShare(channelId, "", text, gameId, gameName, info.getScoreType(), callBack, score, isHistoryBestScore, isWeekBestScore, false);
                        }

                        public void onError(String input, int code, String msg) {
                            GameResultShareService.this.processImageShare(channelId, "", GameResultShareService.this.genShareText(input, singleGameReliveShare, gameName), gameId, gameName, info.getScoreType(), callBack, score, isHistoryBestScore, isWeekBestScore, false);
                        }
                    });
                } else if (channelId == 3) {
                    if (singleGameReliveShare) {
                        GameResultShareService.this.processReliveShareWithImage(R.drawable.single_game_relive_share, channelId, "", callBack);
                    } else {
                        GameResultShareService.this.processImageShare(channelId, bgUrl, "", gameId, gameName, info.getScoreType(), callBack, score, isHistoryBestScore, isWeekBestScore, true);
                    }
                } else if (channelId == 5) {
                    String url = GameResultShareService.this.genShareLink(score, GameResultShareService.this.getNewRecordType(isHistoryBestScore, isWeekBestScore), gameId, gameName, AccountUtil.getUid(), LANG_CODE, singleGameReliveShare);
                    ShortUrlUtil.getShortUrl((String)url, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

                        public void onSuccess(String input, String shortUrl) {
                            String text = GameResultShareService.this.genShareText(shortUrl, singleGameReliveShare, gameName);
                            GameResultShareService.this.shareFacebook(shortUrl, text, callBack);
                        }

                        public void onError(String input, int code, String msg) {
                            GameResultShareService.this.shareFacebook(input, GameResultShareService.this.genShareText(input, singleGameReliveShare, gameName), callBack);
                        }
                    });
                } else if (channelId == 6) {
                    if (!ThirdPartyPlatformHelper.appInstalled((Context)RuntimeContext.sApplicationContext, (String)"com.facebook.orca")) {
                        GameResultShareService.this.handlePlatformNotInstalled(ResourceUtils.getString((int)R.string.share_platform_messenger), callBack);
                        return;
                    }
                    String url = GameResultShareService.this.genShareLink(score, GameResultShareService.this.getNewRecordType(isHistoryBestScore, isWeekBestScore), gameId, gameName, AccountUtil.getUid(), LANG_CODE, singleGameReliveShare);
                    final String title = ResourceUtils.getString((int)R.string.share_default_title);
                    ShortUrlUtil.getShortUrl((String)url, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

                        public void onSuccess(String input, String shortUrl) {
                            String text = GameResultShareService.this.genShareText(shortUrl, singleGameReliveShare, gameName);
                            GameResultShareService.this.shareMessenger(title, shortUrl, text, callBack);
                        }

                        public void onError(String input, int code, String msg) {
                            GameResultShareService.this.shareMessenger(title, input, GameResultShareService.this.genShareText(input, singleGameReliveShare, gameName), callBack);
                        }
                    });
                } else if (channelId == 9) {
                    String url = GameResultShareService.this.genShareLink(score, GameResultShareService.this.getNewRecordType(isHistoryBestScore, isWeekBestScore), gameId, gameName, AccountUtil.getUid(), LANG_CODE, singleGameReliveShare);
                    ShortUrlUtil.getShortUrl((String)url, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

                        public void onSuccess(String input, String shortUrl) {
                            String text = GameResultShareService.this.genShareText(shortUrl, singleGameReliveShare, gameName);
                            GameResultShareService.this.shareVk(shortUrl, text, callBack);
                        }

                        public void onError(String input, int code, String msg) {
                            GameResultShareService.this.shareVk(input, GameResultShareService.this.genShareText(input, singleGameReliveShare, gameName), callBack);
                        }
                    });
                } else if (channelId == 13) {
                    String shareUrl = StringUtils.formatWitUSLocal((String)GameResultShareService.TO_SINGLE_GAME, (Object[])new Object[]{gameId});
                    String text = GameResultShareService.this.genNativeShareText(singleGameReliveShare);
                    GameResultShareService.this.shareNative(gameId, gameName, text, shareUrl, bgUrl, callBack);
                }
            }
        });
    }

    private void doImageShare(String shortUrl, boolean singleGameReliveShare, String gameName, int channelId, IShareCallBack callBack, String bgUrl, String gameId, GameInfo info, int score, boolean isHistoryBestScore, boolean isWeekBestScore) {
        String text = this.genShareText(shortUrl, singleGameReliveShare, gameName);
        if (singleGameReliveShare) {
            this.processReliveShareWithImage(R.drawable.single_game_relive_share, channelId, text, callBack);
        } else {
            this.processImageShare(channelId, bgUrl, text, gameId, gameName, info.getScoreType(), callBack, score, isHistoryBestScore, isWeekBestScore, false);
        }
    }

    public void share(final int channelId, final String gameId, final String gameName, final String bgUrl, final int score, final boolean isHistoryBestScore, final boolean isWeekBestScore, final IShareCallBack callBack, final boolean singleGameReliveShare) {
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GameResultShareService.this.shareInner(channelId, gameId, gameName, bgUrl, score, isHistoryBestScore, isWeekBestScore, callBack, singleGameReliveShare);
                }
            });
        } else {
            this.shareInner(channelId, gameId, gameName, bgUrl, score, isHistoryBestScore, isWeekBestScore, callBack, singleGameReliveShare);
        }
    }

    public String generateShareLink(long uid, int winStreak, boolean isNewUser, String imgUrl, String nickname) {
        return new StreakWinShareHelper((IIntlShareService)ServiceManagerProxy.getService(IIntlShareService.class)).generateShareLink(uid, winStreak, isNewUser, imgUrl, nickname);
    }

    public void initTipsConfig() {
        GameResultTipsManager.Instance.initConfig();
    }

    private void shareFacebook(String url, String text, IShareCallBack callBack) {
        ShareData shareData = ShareData.builder().to(2).type(2).text(text).gotoUrl(url).build();
        this.getShareService().share(5, shareData);
        if (callBack != null) {
            callBack.onShareSuccess(shareData);
        }
    }

    private void shareMessenger(String title, String url, String text, IShareCallBack callBack) {
        ShareData shareData = ShareData.builder().to(1).type(2).title(title).text(text).gotoUrl(url).build();
        this.getShareService().share(6, shareData);
        if (callBack != null) {
            callBack.onShareSuccess(shareData);
        }
    }

    private void shareVk(String url, String text, IShareCallBack callBack) {
        ShareData shareData = ShareData.builder().to(2).type(2).text(text).title("Link").gotoUrl(url).build();
        this.getShareService().share(9, shareData);
        if (callBack != null) {
            callBack.onShareSuccess(shareData);
        }
    }

    private void shareNative(String gameId, String gameName, String text, String jumpUrl, String image, IShareCallBack callBack) {
        HagoShareData data = HagoShareHelper.INSTANCE.appendHagoShareData(gameId, gameName, text, jumpUrl, image);
        ShareData shareData = ShareData.builder().hagoShareData(data).build();
        this.getShareService().share(13, shareData);
        if (callBack != null) {
            callBack.onShareSuccess(shareData);
        }
    }

    private IIntlShareService getShareService() {
        return (IIntlShareService)this.getServiceManager().getService(IIntlShareService.class);
    }

    private void handlePlatformNotInstalled(final String platformName, IShareCallBack callBack) {
        if (callBack != null) {
            callBack.onShareError(null, (Exception)new RuntimeException("Platform is uninstall!"));
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast((Context)GameResultShareService.this.mContext, (String)StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.app_uninstall_ips), (Object[])new Object[]{platformName}), (int)1);
            }
        });
    }

    private void processImageShare(final int channelId, String imgUrl, final String text, String gid, final String gname, final String scoreType, final IShareCallBack callBack, final int score, final boolean isHistoryBestScore, final boolean isWeekBestScore, final boolean showSlogan) {
        if (!TextUtils.isEmpty((CharSequence)imgUrl)) {
            ImageLoader.loadBitmap((Context)this.mContext, (String)imgUrl, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                public void onLoadFailed(Exception e) {
                    MLog.error((Object)GameResultShareService.TAG, (String)("share loadBitmap onLoadFailed e = " + e.getMessage()), (Object[])new Object[0]);
                    if (callBack != null) {
                        callBack.onShareError(null, (Exception)new RuntimeException("Load bitmap fail e = " + e.getMessage()));
                    }
                }

                public void onResourceReady(Bitmap bitmap) {
                    GameResultShareService.this.asyncGenerateData(bitmap, gname, String.valueOf(score), GameResultShareService.this.getScoreType(scoreType), isHistoryBestScore, isWeekBestScore, showSlogan, new Listener(){

                        @Override
                        public void onImageLoaded(String imgPath) {
                            ShareData shareData = GameResultShareService.this.genImgShareData(imgPath, text);
                            GameResultShareService.this.doShare(channelId, shareData, callBack);
                        }
                    });
                }
            });
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)text)) {
            ShareData shareData = this.genTextShareData(text);
            this.doShare(channelId, shareData, callBack);
        }
    }

    private void doShare(int channelId, ShareData shareData, IShareCallBack callBack) {
        this.getShareService().share(channelId, shareData);
        if (callBack != null) {
            callBack.onShareSuccess(shareData);
        }
    }

    private String getNewRecordType(boolean isHistoryBestScore, boolean isWeekBestScore) {
        if (isHistoryBestScore) {
            return "2";
        }
        if (isWeekBestScore) {
            return "1";
        }
        return "0";
    }

    private ShareData genTextShareData(String text) {
        ShareData shareData = ShareData.builder().text(text).type(0).to(1).build();
        shareData.isSystemShare = true;
        return shareData;
    }

    private ShareData genImgShareData(String imgPath, String text) {
        ShareData shareData = ShareData.builder().type(1).to(1).text(text).imgPath(imgPath).build();
        shareData.isSystemShare = true;
        return shareData;
    }

    private void asyncGenerateData(final Bitmap bgBitmap, final String gameName, final String score, final String scoreType, final boolean isHistoryBestScore, final boolean isWeekBestScore, final boolean showSlogan, final Listener listener) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String imagePath = "";
                if (bgBitmap != null) {
                    imagePath = GameResultShareService.this.generateImage(bgBitmap, gameName, score, scoreType, isHistoryBestScore, isWeekBestScore, showSlogan);
                }
                if (listener != null) {
                    listener.onImageLoaded(imagePath);
                }
            }
        });
    }

    private String getScoreType(String scoreType) {
        int resId = "Time".equals(scoreType) ? R.string.single_game_result_time_tips : ("Stage".equals(scoreType) ? R.string.single_game_result_stage_tips : R.string.single_game_result_score_tips);
        return this.mContext.getResources().getString(resId);
    }

    private String generateImage(Bitmap backBitmap, String gameName, String score, String scoreType, boolean isHistoryBestScore, boolean isWeekBestScore, boolean showSlogan) {
        Canvas canvas;
        int bitmapWidth;
        Bitmap bitmap;
        block17: {
            Bitmap newRecordBitmap;
            bitmap = Bitmap.createScaledBitmap((Bitmap)backBitmap, (int)720, (int)720, (boolean)true);
            bitmapWidth = bitmap.getWidth();
            int bitmapHeight = bitmap.getHeight();
            Rect titleBounds = new Rect();
            this.mTitlePaint.getTextBounds(gameName, 0, gameName.length(), titleBounds);
            Rect scoreBounds = new Rect();
            this.mScorePaint.getTextBounds(score, 0, score.length(), scoreBounds);
            Rect scoreTipsBounds = new Rect();
            this.mScoreTipsPaint.getTextBounds(scoreType, 0, scoreType.length(), scoreTipsBounds);
            int gameNameBaseline = bitmapHeight / 4;
            int scoreBaseline = gameNameBaseline + scoreBounds.height() + 70;
            int scoreTipsBaseline = scoreBaseline + scoreTipsBounds.height() + 50;
            canvas = new Canvas(bitmap);
            int titleWidth = titleBounds.width();
            if (titleWidth > bitmapWidth) {
                int subIndex = this.mTitlePaint.breakText((CharSequence)gameName, 0, gameName.length(), true, (float)bitmapWidth, null);
                String subGameName = gameName.substring(0, subIndex - 3) + "...";
                float subGameNameWidth = this.mTitlePaint.measureText(subGameName);
                canvas.drawText(subGameName, (float)(bitmapWidth / 2) - subGameNameWidth / 2.0f, (float)gameNameBaseline, this.mTitlePaint);
            } else {
                canvas.drawText(gameName, (float)(bitmapWidth / 2 - titleWidth / 2), (float)gameNameBaseline, this.mTitlePaint);
            }
            canvas.drawText(score, (float)(bitmapWidth / 2) - this.mScorePaint.measureText(score) / 2.0f, (float)scoreBaseline, this.mScorePaint);
            if (isHistoryBestScore) {
                try {
                    Drawable background = this.createBackground(true);
                    newRecordBitmap = this.getRecordBitmap(R.string.game_result_best_record, background);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)("isWeekBestScore newRecordBitmap = " + newRecordBitmap), (Object[])new Object[0]);
                    }
                    if (newRecordBitmap != null) {
                        newRecordBitmap = GameResultShareService.zoomImg(newRecordBitmap, 0.5f);
                        canvas.drawBitmap(newRecordBitmap, (float)(bitmap.getWidth() / 2 - newRecordBitmap.getWidth() / 2), (float)(scoreBaseline + 50), null);
                    }
                    break block17;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)("isHistoryBestScore " + e.getMessage()), (Object[])new Object[0]);
                    }
                    break block17;
                }
            }
            if (isWeekBestScore) {
                try {
                    Drawable background = this.createBackground(false);
                    newRecordBitmap = this.getRecordBitmap(R.string.single_game_best_of_today, background);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)("isWeekBestScore newRecordBitmap = " + newRecordBitmap), (Object[])new Object[0]);
                    }
                    if (newRecordBitmap != null) {
                        newRecordBitmap = GameResultShareService.zoomImg(newRecordBitmap, 0.5f);
                        canvas.drawBitmap(newRecordBitmap, (float)(bitmapWidth / 2 - newRecordBitmap.getWidth() / 2), (float)(scoreBaseline + 50), null);
                    }
                    break block17;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)("isWeekBestScore " + e.getMessage()), (Object[])new Object[0]);
                    }
                    break block17;
                }
            }
            canvas.drawText(scoreType, (float)(bitmapWidth / 2 - scoreTipsBounds.width() / 2), (float)scoreTipsBaseline, this.mScoreTipsPaint);
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"start gen slogan", (Object[])new Object[0]);
        }
        if (showSlogan) {
            Bitmap shareIconBitmap = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)R.drawable.share_icon);
            shareIconBitmap = GameResultShareService.zoomImg(shareIconBitmap, 0.3f);
            Rect bottomBgRect = new Rect(0, bitmap.getHeight() - 90, bitmap.getWidth(), bitmap.getHeight());
            canvas.drawRect(new Rect(0, bottomBgRect.top, bottomBgRect.right, bottomBgRect.bottom), this.mTitlePaint);
            int bottomBgCenter = bottomBgRect.bottom - (bottomBgRect.bottom - bottomBgRect.top) / 2;
            canvas.drawBitmap(shareIconBitmap, 0.0f, (float)(bottomBgCenter - shareIconBitmap.getHeight() / 2), null);
            String slogon = this.mContext.getResources().getString(R.string.single_game_result_share_slogan);
            canvas.drawText(slogon, (float)bitmapWidth - this.mSlogonPaint.measureText(slogon) - 20.0f, (float)(bottomBgCenter + 10), this.mSlogonPaint);
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"gen slogan end", (Object[])new Object[0]);
        }
        String imagePath = YYFileUtils.getYYTempDir();
        FileUtils.delete((String)(imagePath + File.separator + IMAGE_NAME));
        return ViewImage.saveImgToLocal((Bitmap)bitmap, (String)IMAGE_NAME, (String)imagePath, (Bitmap.CompressFormat)Bitmap.CompressFormat.PNG);
    }

    private Drawable createBackground(boolean isHistoryBest) {
        Drawable background;
        if (HardwareUtils.isOppoA1601()) {
            background = ResourceUtils.getDrawable((int)R.drawable.shape_single_game_resukt_share_title);
            int color2 = isHistoryBest ? Color.parseColor((String)"#ff3545") : Color.parseColor((String)"#fbb122");
            background.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        } else {
            background = isHistoryBest ? ResourceUtils.getDrawable((int)R.drawable.single_game_result_history_best_score_img) : ResourceUtils.getDrawable((int)R.drawable.single_game_result_week_best_score_img);
        }
        return background;
    }

    private Bitmap getRecordBitmap(@StringRes int resId, Drawable background) {
        YYTextView tip = new YYTextView(RuntimeContext.sApplicationContext);
        tip.setText(resId);
        tip.setTextSize(44.0f);
        tip.setTextColor(Color.parseColor((String)"#ffffff"));
        FontUtils.setFontType((TextView)tip, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        if (Build.VERSION.SDK_INT >= 16) {
            tip.setBackground(background);
        } else {
            tip.setBackgroundDrawable(background);
        }
        tip.setGravity(17);
        tip.setIncludeFontPadding(false);
        tip.setPadding(60, 20, 60, 20);
        tip.setDrawingCacheEnabled(true);
        tip.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        tip.layout(0, 0, tip.getMeasuredWidth(), tip.getMeasuredHeight());
        Bitmap newRecordBitmap = tip.getDrawingCache();
        return newRecordBitmap;
    }

    private String genShareText(String shareUrl, boolean singleGameReliveShare, String gameName) {
        if (singleGameReliveShare) {
            return this.generateRandomText() + " " + shareUrl;
        }
        return this.mContext.getResources().getString(R.string.single_game_result_share_content) + " " + shareUrl;
    }

    private String genNativeShareText(boolean singleGameReliveShare) {
        if (singleGameReliveShare) {
            return this.generateRandomText();
        }
        return this.mContext.getResources().getString(R.string.single_game_result_share_content);
    }

    public static Bitmap zoomImg(Bitmap bm, float scale) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        return Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    private String genShareLink(int score, String newRecordType, String gameId, String gameName, long uid, String langCode, boolean singleGameReliveShare) {
        String host = this.createSharePageHost(singleGameReliveShare);
        if (singleGameReliveShare) {
            return StringUtils.formatWitUSLocal((String)(host + RELIVE_SHARE_PAGE_URL_PATH), (Object[])new Object[]{score, gameId, gameName, uid, this.mType, langCode, UriProvider.getIdc()});
        }
        return StringUtils.formatWitUSLocal((String)(host + SHARE_PAGE_URL_PATH), (Object[])new Object[]{score, newRecordType, gameId, uid, langCode, UriProvider.getIdc()});
    }

    private String createSharePageHost(boolean singleGameReliveShare) {
        String host = "https://www.ihago.net";
        EnvSettingType type = EnvSettings.instance().getUriSettingValue();
        if (type == EnvSettingType.Dev) {
            host = SHARE_PAGE_DEV_HOST;
        } else if (type == EnvSettingType.Product) {
            host = singleGameReliveShare ? "https://www.ihago.net" : "https://www.ihago.net";
        } else if (type == EnvSettingType.Test) {
            host = singleGameReliveShare ? "https://test.ihago.net" : "https://test.ihago.net";
        }
        return host;
    }

    private String generateRandomText() {
        String shareText = "";
        switch (this.mType) {
            case 0: {
                shareText = ResourceUtils.getString((int)R.string.single_game_share_relive_type_one);
                return shareText;
            }
            case 1: {
                shareText = ResourceUtils.getString((int)R.string.single_game_share_relive_type_two);
                return shareText;
            }
            case 2: {
                shareText = ResourceUtils.getString((int)R.string.single_game_share_relive_type_three);
                return shareText;
            }
        }
        shareText = ResourceUtils.getString((int)R.string.single_game_share_relive_type_one);
        return shareText;
    }

    private static String getSingleGameReliveShareImagePath() {
        if (SINGLE_GAME_RELIVE_SHARE_IMAGE_PATH == null) {
            return SINGLE_GAME_RELIVE_SHARE_IMAGE_PATH;
        }
        SINGLE_GAME_RELIVE_SHARE_IMAGE_PATH = YYFileUtils.getYYTempDir() + File.separator + RELIVE_SHARE_IMAGE_NAME + ".jpg";
        return SINGLE_GAME_RELIVE_SHARE_IMAGE_PATH;
    }

    private void processReliveShareWithImage(final @DrawableRes int drawableResId, final int channelId, final String shareText, final IShareCallBack callBack) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (YYFileUtils.isFileExisted((String)GameResultShareService.getSingleGameReliveShareImagePath())) {
                    ShareData shareData = GameResultShareService.this.genImgShareData(GameResultShareService.getSingleGameReliveShareImagePath(), shareText);
                    GameResultShareService.this.doShare(channelId, shareData, callBack);
                } else {
                    Bitmap bitmap = YYImageUtils.decodeResource((Context)GameResultShareService.this.mContext, (int)drawableResId);
                    if (bitmap != null) {
                        Bitmap zoomedBitmap = GameResultShareService.zoomImg(bitmap, 0.8f);
                        String imagePath = ViewImage.saveImgToLocal((Bitmap)zoomedBitmap, (String)GameResultShareService.RELIVE_SHARE_IMAGE_NAME, (String)YYFileUtils.getYYTempDir(), (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG);
                        ShareData shareData = GameResultShareService.this.genImgShareData(imagePath, shareText);
                        GameResultShareService.this.doShare(channelId, shareData, callBack);
                    }
                }
            }
        });
    }

    static interface Listener {
        public void onImageLoaded(String var1);
    }
}

