/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gamemodeselect.ui;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.R;
import com.yy.appbase.ui.toast.GlobalTopToast;
import com.yy.appbase.ui.toast.ToastMessage;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.game.R;
import com.yy.game.module.gamemodeselect.ModeSelectUiCallback;
import com.yy.game.module.gamemodeselect.adapter.ModeAdapter;

public class ModeSelectDialog
implements BaseDialog,
View.OnClickListener,
DialogInterface.OnDismissListener {
    private ModeAdapter mModeAdapter;
    private ModeSelectUiCallback mUiCallback;
    private View mRootView;
    private View mCancelBtn;
    private RecyclerView mModeList;
    private RecycleImageView mBg;
    private GlobalTopToast mToast;
    private FrameLayout mToastBox;
    private boolean mFullScreen = false;

    public ModeSelectDialog(ModeAdapter modeAdapter, ModeSelectUiCallback callback2) {
        this.mModeAdapter = modeAdapter;
        this.mUiCallback = callback2;
    }

    public void init(final Dialog dialog2) {
        if (dialog2 == null || dialog2.getWindow() == null) {
            return;
        }
        this.createViews(dialog2.getContext());
        dialog2.setCanceledOnTouchOutside(false);
        if (this.mUiCallback != null) {
            WindowManager.LayoutParams windowLp = dialog2.getWindow().getAttributes();
            windowLp.width = this.mUiCallback.getWindowWidth();
            windowLp.height = -1;
            dialog2.getWindow().setAttributes(windowLp);
        }
        dialog2.getWindow().setDimAmount(0.9f);
        dialog2.getWindow().setWindowAnimations(0);
        if (this.mFullScreen) {
            dialog2.getWindow().getDecorView().setSystemUiVisibility(2);
            dialog2.getWindow().getDecorView().setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

                public void onSystemUiVisibilityChange(int visibility) {
                    int uiOptions = 0;
                    if (Build.VERSION.SDK_INT >= 16) {
                        uiOptions = 1796;
                    }
                    uiOptions |= 2;
                    uiOptions = Build.VERSION.SDK_INT >= 19 ? (uiOptions |= 0x1000) : (uiOptions |= 1);
                    dialog2.getWindow().getDecorView().setSystemUiVisibility(uiOptions);
                }
            });
        }
        ViewGroup.LayoutParams contentLp = new ViewGroup.LayoutParams(-1, -1);
        dialog2.setContentView(this.mRootView, contentLp);
        dialog2.setOnDismissListener((DialogInterface.OnDismissListener)this);
    }

    public int getId() {
        return 0;
    }

    private void createViews(Context context) {
        this.mRootView = LayoutInflater.from((Context)context).inflate(R.layout.mode_select_window_layout, null);
        this.mBg = (RecycleImageView)this.mRootView.findViewById(R.id.iv_bg);
        this.mCancelBtn = this.mRootView.findViewById(R.id.iv_cancel);
        this.mCancelBtn.setOnClickListener((View.OnClickListener)this);
        this.mModeList = (RecyclerView)this.mRootView.findViewById(R.id.mode_list);
        this.mModeList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.mModeList.setAdapter((RecyclerView.Adapter)this.mModeAdapter);
        this.mToastBox = (FrameLayout)this.mRootView.findViewById(R.id.fl_toast);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_cancel && this.mUiCallback != null) {
            this.mUiCallback.onCancelBtnClick();
        }
    }

    public void onDismiss(DialogInterface dialog2) {
        if (this.mUiCallback != null) {
            this.mUiCallback.onCanceled();
        }
    }

    public void showToast(String toast) {
        if (this.mRootView == null) {
            return;
        }
        if (this.mToast == null) {
            this.mToast = new GlobalTopToast(this.mRootView.getContext());
            this.mToastBox.addView(this.mToast.getToastView());
            this.mToast.setToastMsgSingleLine(true);
        }
        ToastMessage message = new ToastMessage();
        message.msg = toast;
        message.color = ResourceUtils.getColor((int)R.color.error_toast_bg);
        message.duration = 4000L;
        this.mToast.showToast(message);
    }

    public void setFullScreen(boolean fullScreen) {
        this.mFullScreen = fullScreen;
    }
}

