/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gamemodeselect.adapter;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.ui.widget.NewTagSvgaPlayer;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.game.DR;
import com.yy.game.R;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;
import com.yy.hiyo.game.base.widget.GameTagView;
import java.util.ArrayList;
import java.util.List;

public class ModeAdapter
extends RecyclerView.Adapter<VH> {
    private static final DResource NEW_TAG_SVGA = DR.new_tag_game_row;
    private List<GameModeInfo> mData = new ArrayList<GameModeInfo>();
    private ModeLostListener mModeListListener;
    private boolean mShowGuide = false;
    private boolean mIsNewUser = false;
    private GameModeInfo mInitialSelectedMode;
    private View.OnClickListener itemClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            Integer position = (Integer)v.getTag();
            if (position != null && position >= 0 && position < ModeAdapter.this.getItemCount()) {
                GameModeInfo gameModeInfo = (GameModeInfo)ModeAdapter.this.mData.get(position);
                if (gameModeInfo.getStatus() == 2) {
                    if (ModeAdapter.this.mModeListListener != null) {
                        ModeAdapter.this.mModeListListener.showToast(ResourceUtils.getString((int)R.string.tips_game_full));
                    }
                } else if (gameModeInfo.getStatus() == 1) {
                    if (ModeAdapter.this.mModeListListener != null) {
                        ModeAdapter.this.mModeListListener.showToast(ResourceUtils.getString((int)R.string.game_maintening));
                    }
                } else if (ModeAdapter.this.mModeListListener != null) {
                    ModeAdapter.this.mModeListListener.onItemClick(position, gameModeInfo);
                }
            }
        }
    };

    private ModeAdapter() {
    }

    @NonNull
    public VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_mode_select_card, parent, false);
        return new VH(view);
    }

    public void onBindViewHolder(@NonNull VH holder, int position) {
        if (position < 0 || position >= this.getItemCount()) {
            return;
        }
        GameModeInfo gameModeInfo = this.mData.get(position);
        if (gameModeInfo == null) {
            return;
        }
        holder.update(position, gameModeInfo);
        holder.setItemClickListener(position, this.itemClickListener);
        if (this.mInitialSelectedMode != null && this.mInitialSelectedMode.equals((Object)gameModeInfo)) {
            holder.setSelection(true);
        } else {
            holder.setSelection(false);
        }
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ModeAdapter modeAdapter = new ModeAdapter();

        private Builder() {
        }

        public Builder showGuide(boolean isShow) {
            this.modeAdapter.mShowGuide = isShow;
            return this;
        }

        public Builder isNewUser(boolean isNew) {
            this.modeAdapter.mIsNewUser = isNew;
            return this;
        }

        public Builder data(List<GameModeInfo> gameModeInfoList) {
            this.modeAdapter.mData.clear();
            if (gameModeInfoList != null) {
                this.modeAdapter.mData.addAll(gameModeInfoList);
            }
            return this;
        }

        public Builder itemClickListener(ModeLostListener itemClickListener) {
            this.modeAdapter.mModeListListener = itemClickListener;
            return this;
        }

        public Builder selectedMode(GameModeInfo selectedMode) {
            this.modeAdapter.mInitialSelectedMode = selectedMode;
            return this;
        }

        public ModeAdapter build() {
            return this.modeAdapter;
        }
    }

    public static interface ModeLostListener {
        public void onItemClick(int var1, GameModeInfo var2);

        public void showToast(String var1);
    }

    public class VH
    extends RecyclerView.ViewHolder {
        private View mItemView;
        private TextView mTvName;
        private TextView mTvDesc;
        private View mBorderView;
        private GameTagView mGameTag;
        private RecycleImageView mBgView;
        private SVGAImageView mGuideView;

        public VH(View itemView) {
            super(itemView);
            this.mItemView = itemView;
            if (itemView != null) {
                this.mTvName = (TextView)itemView.findViewById(R.id.werewolf_title);
                this.mTvDesc = (TextView)itemView.findViewById(R.id.tv_play);
                this.mBorderView = itemView.findViewById(R.id.ll_selected_cover);
                this.mBgView = (RecycleImageView)itemView.findViewById(R.id.card_bg);
                this.mGameTag = (GameTagView)itemView.findViewById(R.id.game_tag);
                this.mGuideView = (SVGAImageView)itemView.findViewById(R.id.svga_guide);
                this.mTvName.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
                this.mTvDesc.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
            }
        }

        public void update(int position, GameModeInfo gameModeInfo) {
            if (this.mItemView == null) {
                return;
            }
            if (gameModeInfo == null) {
                return;
            }
            this.mTvName.setText((CharSequence)gameModeInfo.getName());
            this.mTvDesc.setText((CharSequence)gameModeInfo.getDesc());
            int width = ResolutionUtils.getScreenWidth((Context)this.mBgView.getContext()) - ResolutionUtils.dip2Px((float)30.0f);
            int height = ResolutionUtils.dip2Px((float)130.0f);
            ImageLoader.loadImage((RecycleImageView)this.mBgView, (String)(gameModeInfo.getCardImgUrl() + YYImageUtils.getThumbnailPostfixPx((int)width, (int)height, (boolean)false)));
            int status = gameModeInfo.getStatus();
            if (status == 0 || status == 3) {
                status = ModeAdapter.this.mShowGuide && !ModeAdapter.this.mIsNewUser && gameModeInfo.getGuideType() == 2 ? 3 : 0;
            }
            this.updateStatusTag(status, gameModeInfo.getTagUrl());
            int guideType = gameModeInfo.getGuideType();
            this.checkIfShowGuide(guideType, status);
            this.startShowAnim(this.mItemView);
        }

        private void updateStatusTag(int status, String tagUrl) {
            this.mGameTag.setSize(-2, -2);
            this.mGameTag.setBackgroundResource(R.drawable.game_tag_top_right_big);
            this.mGameTag.setTextSize(13.0f);
            this.mGameTag.setPadding(ResolutionUtils.dip2Px((float)7.0f), ResolutionUtils.dip2Px((float)2.0f), ResolutionUtils.dip2Px((float)4.0f), ResolutionUtils.dip2Px((float)5.0f));
            if (status == 0) {
                this.mGameTag.setVisibility(8);
            } else if (status == 3) {
                this.mGameTag.setVisibility(0);
                this.mGameTag.setText(R.string.home_game_new_tag);
                this.mGameTag.setContentBgColor(ResourceUtils.getColor((int)R.color.home_game_new_tag));
                NewTagSvgaPlayer mTagSvgaPlayer = new NewTagSvgaPlayer(this.itemView, R.id.game_new_tag_anim_stub, NEW_TAG_SVGA);
                mTagSvgaPlayer.updateNewTag(true);
            } else if (status == 2) {
                this.mGameTag.setVisibility(0);
                this.mGameTag.setContentBgColor(ResourceUtils.getColor((int)R.color.home_game_fix_tag));
                this.mGameTag.setText(R.string.btn_full);
            } else if (status == 1) {
                this.mGameTag.setVisibility(0);
                this.mGameTag.setText(R.string.home_game_fix_tag);
                this.mGameTag.setContentBgColor(ResourceUtils.getColor((int)R.color.home_game_fix_tag));
            } else {
                this.mGameTag.setVisibility(0);
                this.mGameTag.setText(null);
                this.mGameTag.setSize(ResolutionUtils.dip2Px((float)37.0f), ResolutionUtils.dip2Px((float)21.0f));
                this.mGameTag.setBgUrl(tagUrl);
                this.mGameTag.setPadding(0, 0, 0, 0);
            }
        }

        private void checkIfShowGuide(int guideType, int status) {
            if (ModeAdapter.this.mShowGuide && status != 2 && status != 1) {
                if (ModeAdapter.this.mIsNewUser && guideType == 1) {
                    this.showGuide(true);
                } else {
                    this.showGuide(false);
                }
            } else {
                this.showGuide(false);
            }
        }

        private void showGuide(boolean isShow) {
            if (this.mGuideView == null) {
                return;
            }
            if (isShow) {
                this.mGuideView.setVisibility(0);
                DyResLoader.INSTANCE.loadSvga(this.mGuideView, DR.match_guide, new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity entity) {
                        if (VH.this.mGuideView != null) {
                            VH.this.mGuideView.startAnimation();
                        }
                    }

                    public void onFailed(Exception e) {
                    }
                });
            } else {
                this.mGuideView.setVisibility(8);
            }
        }

        public void setItemClickListener(int position, View.OnClickListener listener) {
            this.mItemView.setTag((Object)position);
            this.mItemView.setOnClickListener(listener);
            this.mItemView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    switch (event.getAction()) {
                        case 0: {
                            VH.this.animationDown(v);
                            break;
                        }
                        case 1: 
                        case 3: {
                            VH.this.animationUp(v);
                            break;
                        }
                    }
                    return false;
                }
            });
        }

        public void setSelection(boolean selection) {
            if (selection) {
                this.mBorderView.setVisibility(0);
            } else {
                this.mBorderView.setVisibility(8);
            }
        }

        private void animationDown(View view) {
            view.setPivotX((float)(view.getMeasuredWidth() / 2));
            view.setPivotY((float)(view.getMeasuredHeight() / 2));
            ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 0.9f});
            ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 0.9f});
            scaleX.setDuration(60L);
            scaleY.setDuration(60L);
            scaleX.start();
            scaleY.start();
        }

        private void animationUp(View view) {
            view.setPivotX((float)(view.getMeasuredWidth() / 2));
            view.setPivotY((float)(view.getMeasuredHeight() / 2));
            float x = view.getScaleX();
            float y = view.getScaleY();
            ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{x, 1.0f});
            ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{y, 1.0f});
            scaleX.setDuration(100L);
            scaleY.setDuration(100L);
            scaleX.start();
            scaleY.start();
        }

        private void startShowAnim(View view) {
            if (view == null) {
                return;
            }
            ScaleAnimation scaleAnim = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, 0.5f, 1, 0.5f);
            scaleAnim.setDuration(200L);
            scaleAnim.setInterpolator((Interpolator)new DecelerateInterpolator(2.0f));
            view.startAnimation((Animation)scaleAnim);
        }
    }
}

