/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gamemodeselect;

import android.os.Message;
import android.view.View;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.game.module.gamemodeselect.ModeSelectStatisHelper;
import com.yy.game.module.gamemodeselect.ModeSelectUiCallback;
import com.yy.game.module.gamemodeselect.adapter.ModeAdapter;
import com.yy.game.module.gamemodeselect.ui.ModeSelectDialog;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;
import com.yy.hiyo.game.base.gamemode.GameModeSelectArg;
import com.yy.hiyo.game.base.gamemode.IModeSelectCallback;

public class ModeSelectWindowController
extends DefaultWindowController
implements ModeAdapter.ModeLostListener,
ModeSelectUiCallback {
    private IModeSelectCallback mModeSelectCallback;
    private GameInfo mGameInfo;
    private int mFrom;
    private ModeSelectDialog mModeSelectDialog;

    public ModeSelectWindowController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        if (msg == null) {
            return;
        }
        if (msg.what == BaseMsgDef.MSG_SHOW_GAME_MODE_SELECT) {
            if (!(msg.obj instanceof GameModeSelectArg)) {
                return;
            }
            GameModeSelectArg arg = (GameModeSelectArg)msg.obj;
            ModeAdapter modeAdapter = ModeAdapter.builder().showGuide(arg.isShowGuide()).isNewUser(arg.isNewUser()).data(arg.getModeInfoList()).itemClickListener(this).selectedMode(arg.getSelectedMode()).build();
            this.mModeSelectCallback = arg.getModeSelectCallback();
            this.mGameInfo = arg.getGameInfo();
            this.mFrom = arg.getFrom();
            this.mModeSelectDialog = new ModeSelectDialog(modeAdapter, this);
            this.mModeSelectDialog.setFullScreen(!this.mDeviceMgr.isSysStatusBarShowing());
            this.mDialogLinkManager.showDialog((BaseDialog)this.mModeSelectDialog);
            ModeSelectStatisHelper.reportShow(this.mGameInfo, this.mFrom);
        }
    }

    @Override
    public void onCancelBtnClick() {
        this.mDialogLinkManager.dismissDialog();
        ModeSelectStatisHelper.reportCloseClick(this.mGameInfo, this.mFrom);
    }

    @Override
    public View getCurrentWindowView() {
        return this.mWindowMgr.getCurrentWindow();
    }

    @Override
    public int getWindowWidth() {
        AbstractWindow window = this.mWindowMgr.getCurrentWindow();
        return window.getMeasuredWidth();
    }

    @Override
    public int getWindowHeight() {
        AbstractWindow window = this.mWindowMgr.getCurrentWindow();
        return window.getMeasuredHeight();
    }

    @Override
    public void onCanceled() {
        if (this.mModeSelectCallback != null) {
            this.mModeSelectCallback.onCanceled();
        }
        this.mModeSelectCallback = null;
    }

    @Override
    public void onItemClick(int position, GameModeInfo gameModeInfo) {
        if (this.mModeSelectCallback != null) {
            this.mModeSelectCallback.onModeSelected(gameModeInfo);
        }
        this.mDialogLinkManager.dismissDialog();
        ModeSelectStatisHelper.reportModeClick(this.mGameInfo, gameModeInfo, this.mFrom);
    }

    @Override
    public void showToast(String msg) {
        if (this.mModeSelectDialog == null) {
            return;
        }
        this.mModeSelectDialog.showToast(msg);
    }
}

