/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gamemessage;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.hiyo.game.base.BarrageInfo;
import com.yy.hiyo.game.base.DefaultBarrageResBean;
import com.yy.hiyo.game.base.IGameMsgListener;
import com.yy.hiyo.game.service.IGameMessageService;
import com.yy.hiyo.game.service.callback.IGameMessageBarrageListener;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import common.Header;
import ikxd.cproxy.CProxy;
import ikxd.cproxy.JoinRoomReq;
import ikxd.cproxy.LeaveRoomReq;
import ikxd.through.KxdThrough;
import ikxd.through.SendMessageReq;
import ikxd.through.ThroughType;
import ikxd.through.Uri;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import okhttp3.Call;
import okio.ByteString;

public class GameMessageController
extends DefaultController
implements IGameMessageService {
    private static final String TAG = "GameMessageController";
    private ConcurrentLinkedQueue<IGameMsgListener> mGameMsgListener = new ConcurrentLinkedQueue();
    private Map<String, DefaultBarrageResBean> barrageMap = new HashMap<String, DefaultBarrageResBean>();
    IProtoNotify msgProtoNotify = new IProtoNotify<KxdThrough>(){

        public String serviceName() {
            return "ikxd_through_d";
        }

        public void onNotify(final @NonNull KxdThrough result) {
            if (result.uri == Uri.kUriSendMessageNotify) {
                if (result.send_message_notify.type == ThroughType.ThroughTypeUnicast) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameMessageController.TAG, (String)"ThroughTypeUnicast", (Object[])new Object[0]);
                    }
                    if (result.send_message_notify.data_type == 1L && result.send_message_notify.unicast_id == AccountUtil.getUid()) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameMessageController.TAG, (String)"onExpressNotify", (Object[])new Object[0]);
                        }
                        for (IGameMsgListener gameMsgListener : GameMessageController.this.mGameMsgListener) {
                            gameMsgListener.onExpressNotify(result.send_message_notify.sender_id.longValue(), result.send_message_notify.data.utf8());
                        }
                    }
                    if (result.send_message_notify.data_type == 4L && result.send_message_notify.unicast_id == AccountUtil.getUid()) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameMessageController.TAG, (String)"PK_GAME_BARRAGE onBarrageNotify", (Object[])new Object[0]);
                        }
                        final BarrageInfo[] info = new BarrageInfo[1];
                        YYTaskExecutor.execute((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                info[0] = (BarrageInfo)JsonParser.parseJsonObject((String)result.send_message_notify.data.utf8(), BarrageInfo.class);
                            }
                        }, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                for (IGameMsgListener gameMsgListener : GameMessageController.this.mGameMsgListener) {
                                    gameMsgListener.onBarrageNotify(info[0], String.valueOf(result.send_message_notify.sender_id), 0);
                                }
                            }
                        });
                    }
                } else if (result.send_message_notify.type == ThroughType.ThroughTypeBroadcast) {
                    if (result.send_message_notify.data_type == 5L) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameMessageController.TAG, (String)"TEAM_GAME_BARRAGE onBarrageNotify", (Object[])new Object[0]);
                        }
                        final BarrageInfo[] info = new BarrageInfo[1];
                        YYTaskExecutor.execute((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                info[0] = (BarrageInfo)JsonParser.parseJsonObject((String)result.send_message_notify.data.utf8(), BarrageInfo.class);
                            }
                        }, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (info[0] != null && info[0].user != null && info[0].user.uid != AccountUtil.getUid()) {
                                    for (IGameMsgListener gameMsgListener : GameMessageController.this.mGameMsgListener) {
                                        gameMsgListener.onBarrageNotify(info[0], result.send_message_notify.broadcast_id, 1);
                                    }
                                }
                            }
                        });
                    } else if (result.send_message_notify.data_type == 1L) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameMessageController.TAG, (String)"EMOJI_MSG onExpressBrocstNotify", (Object[])new Object[0]);
                        }
                        if (result.send_message_notify.sender_id != AccountUtil.getUid()) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)GameMessageController.TAG, (String)"onExpressNotify", (Object[])new Object[0]);
                            }
                            for (IGameMsgListener gameMsgListener : GameMessageController.this.mGameMsgListener) {
                                gameMsgListener.onExpressBrocstNotify(result.send_message_notify.broadcast_id, result.send_message_notify.sender_id.longValue(), result.send_message_notify.data.utf8());
                            }
                        }
                    }
                }
            }
        }
    };

    public GameMessageController(Environment env) {
        super(env);
    }

    public void getMessagePool(final String gameId, final IGameMessageBarrageListener listener) {
        DefaultBarrageResBean barrageResBeanList;
        if (this.barrageMap.containsKey(gameId) && (barrageResBeanList = this.barrageMap.get(gameId)) != null) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onMessageBarrageRes(barrageResBeanList);
                }
            });
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getMessagePool gameId=%s", (Object[])new Object[]{gameId});
        }
        String url = UriProvider.getIkxdSvrHost() + UriProvider.BULLET_SCRREN_URL;
        HashMap<String, String> data = new HashMap<String, String>();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("gid", gameId);
        data.put("data", jsonObject.toString());
        HttpUtil.httpReq((String)url, data, (int)1, (INetRespCallback)new INetRespCallback<DefaultBarrageResBean>(){

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponse(String response, final BaseResponseBean<DefaultBarrageResBean> res, int id2) {
                if (res != null && res.isSuccess() && res.data != null && ((DefaultBarrageResBean)res.data).msgs != null) {
                    GameMessageController.this.barrageMap.put(gameId, res.data);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            listener.onMessageBarrageRes((DefaultBarrageResBean)res.data);
                        }
                    });
                }
            }
        });
    }

    public void sendMsgReq(final long targetUid, UserInfoBean myUserInfo, String message) {
        String colorStr = Integer.toHexString(0xFFFFFF);
        final BarrageInfo info = new BarrageInfo(new BarrageInfo.User(myUserInfo.getUid(), myUserInfo.getAvatar(), myUserInfo.getNick(), myUserInfo.getSex()), new BarrageInfo.Barrage(message, System.currentTimeMillis(), colorStr));
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                GameMessageController.this.sendMsgReqUnio(new Gson().toJson((Object)info, BarrageInfo.class), targetUid, 4L);
            }
        });
    }

    public void sendMsgReq(final String roomId, UserInfoBean myUserInfo, String message) {
        String colorStr = Integer.toHexString(0xFFFFFF);
        final BarrageInfo info = new BarrageInfo(new BarrageInfo.User(myUserInfo.getUid(), myUserInfo.getAvatar(), myUserInfo.getNick(), myUserInfo.getSex()), new BarrageInfo.Barrage(message, System.currentTimeMillis(), colorStr));
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                GameMessageController.this.sendMsgReqBroadcast(info, roomId, 5L);
            }
        });
    }

    public void sendMsgReqUnio(String utf8data, long uid, long datatype) {
        SendMessageReq req = new SendMessageReq.Builder().type(ThroughType.ThroughTypeUnicast).data_type(Long.valueOf(datatype)).data(ByteString.encodeUtf8((String)utf8data)).unicast_id(Long.valueOf(uid)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_through_d");
        KxdThrough kxdThrough = new KxdThrough.Builder().header(header).uri(Uri.kUriSendMessageReq).send_message_req(req).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"sendMsgReqUnio", (Object[])new Object[0]);
        }
        ProtoManager.getInstance().send((AndroidMessage)kxdThrough, (IProtoCallback)new IProtoCallback<KxdThrough>(){

            public void onResponse(@Nullable KxdThrough response) {
                if (response != null && response.uri == Uri.kUriSendMessageRes) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameMessageController.TAG, (String)"kUriSendMessageRes:", (Object[])new Object[0]);
                    }
                    for (IGameMsgListener gameMsgListener : GameMessageController.this.mGameMsgListener) {
                        gameMsgListener.onSendMsgRes();
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return true;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    public void sendJoinRoomReq(String roomId) {
        if (StringUtils.isEmpty((String)roomId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"sendJoinRoomReq roomId = null", (Object[])new Object[0]);
            }
            return;
        }
        JoinRoomReq req = new JoinRoomReq.Builder().room_id(roomId).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_cproxy_d");
        CProxy cProxy = new CProxy.Builder().header(header).uri(ikxd.cproxy.Uri.kUriJoinRoomReq).join_room_req(req).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"sendJoinRoomReq roomId=%s", (Object[])new Object[]{roomId});
        }
        ProtoManager.getInstance().send((AndroidMessage)cProxy, (IProtoCallback)new IProtoCallback<CProxy>(){

            public void onResponse(@Nullable CProxy response) {
                block5: {
                    if (response == null || response.uri != ikxd.cproxy.Uri.kUriJoinRoomRes) break block5;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameMessageController.TAG, (String)"kUriJoinRoomRes:", (Object[])new Object[0]);
                    }
                    if (response.header.code == 0L) {
                        for (IGameMsgListener gameMsgListener : GameMessageController.this.mGameMsgListener) {
                            gameMsgListener.onJoinRoomSuccess();
                        }
                    } else {
                        for (IGameMsgListener gameMsgListener : GameMessageController.this.mGameMsgListener) {
                            gameMsgListener.onJoinRoomFail(response.header.code.longValue());
                        }
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    public void sendLeaveRoomReq(final String roomId) {
        if (StringUtils.isNotEmpty((String)roomId)) {
            LeaveRoomReq req = new LeaveRoomReq.Builder().room_id(roomId).build();
            Header header = ProtoManager.getInstance().getHeader("ikxd_cproxy_d");
            CProxy cProxy = new CProxy.Builder().header(header).uri(ikxd.cproxy.Uri.kUriLeaveRoomReq).leave_room_req(req).build();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"sendLeaveRoomReq roomId=%s", (Object[])new Object[]{roomId});
            }
            ProtoManager.getInstance().send((AndroidMessage)cProxy, (IProtoCallback)new IProtoCallback<CProxy>(){

                public void onResponse(@Nullable CProxy response) {
                    if (response != null && response.uri == ikxd.cproxy.Uri.kUriLeaveRoomRes && MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameMessageController.TAG, (String)"leaveroom:roomId = %s", (Object[])new Object[]{roomId});
                    }
                }

                public boolean retryWhenTimeout(boolean canRetry) {
                    return false;
                }

                public boolean retryWhenError(boolean canRetry, String reason, int code) {
                    return false;
                }
            });
        }
    }

    public void sendMsgReqBroadcast(BarrageInfo info, String roomId, long datatype) {
        if (TextUtils.isEmpty((CharSequence)roomId) || info == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"sendMsgReqBroadcast params is not valid", (Object[])new Object[0]);
            }
            return;
        }
        String utf8data = JsonParser.toJson((Object)info);
        SendMessageReq req = new SendMessageReq.Builder().type(ThroughType.ThroughTypeBroadcast).data_type(Long.valueOf(datatype)).data(ByteString.encodeUtf8((String)utf8data)).broadcast_id(roomId).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_through_d");
        KxdThrough kxdThrough = new KxdThrough.Builder().header(header).uri(Uri.kUriSendMessageReq).send_message_req(req).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"sendMsgReqBroadcast", (Object[])new Object[0]);
        }
        ProtoManager.getInstance().send((AndroidMessage)kxdThrough, (IProtoCallback)new IProtoCallback<KxdThrough>(){

            public void onResponse(@Nullable KxdThrough response) {
                if (response != null && response.uri == Uri.kUriSendMessageRes) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameMessageController.TAG, (String)"sendMsgReqBroadcast kUriSendMessageRes:", (Object[])new Object[0]);
                    }
                    for (IGameMsgListener gameMsgListener : GameMessageController.this.mGameMsgListener) {
                        gameMsgListener.onSendMsgRes();
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return true;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
        for (IGameMsgListener gameMsgListener : this.mGameMsgListener) {
            gameMsgListener.onBarrageNotify(info, roomId, 1);
        }
    }

    public void sendMsgReqBroadcast(String utf8data, String roomId, long datatype) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"sendMsgReqBroadcast params is not valid", (Object[])new Object[0]);
            }
            return;
        }
        SendMessageReq req = new SendMessageReq.Builder().type(ThroughType.ThroughTypeBroadcast).data_type(Long.valueOf(datatype)).data(ByteString.encodeUtf8((String)utf8data)).broadcast_id(roomId).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_through_d");
        KxdThrough kxdThrough = new KxdThrough.Builder().header(header).uri(Uri.kUriSendMessageReq).send_message_req(req).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"sendMsgReqBroadcast", (Object[])new Object[0]);
        }
        ProtoManager.getInstance().send((AndroidMessage)kxdThrough, (IProtoCallback)new IProtoCallback<KxdThrough>(){

            public void onResponse(@Nullable KxdThrough response) {
                if (response != null && response.uri == Uri.kUriSendMessageRes) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameMessageController.TAG, (String)"sendMsgReqBroadcast kUriSendMessageRes:", (Object[])new Object[0]);
                    }
                    for (IGameMsgListener gameMsgListener : GameMessageController.this.mGameMsgListener) {
                        gameMsgListener.onSendMsgRes();
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return true;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    public void registerGameMsgListener(IGameMsgListener listener) {
        if (this.mGameMsgListener == null) {
            this.mGameMsgListener = new ConcurrentLinkedQueue();
        }
        if (listener != null && !this.mGameMsgListener.contains(listener)) {
            this.mGameMsgListener.add(listener);
        }
    }

    public void unRegisterGameMsgListener(IGameMsgListener listener) {
        if (this.mGameMsgListener != null) {
            this.mGameMsgListener.remove(listener);
        }
    }

    public void registerGameMsgNotify() {
        ProtoManager.getInstance().registerNotify(this.msgProtoNotify);
    }

    public void unRegisterGameMsgNotify() {
        ProtoManager.getInstance().unregisterNotify(this.msgProtoNotify);
    }
}

