/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameload;

import android.text.TextUtils;
import com.bumptech.glide.load.DecodeFormat;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.game.R;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import org.json.JSONException;
import org.json.JSONObject;

public class LoadGamePageManager {
    private static final String TAG = "LoadGamePageService";
    private Map<String, String> mUrlMemos = new HashMap<String, String>();
    private static LoadGamePageManager sInstance;

    public static LoadGamePageManager getInstance() {
        if (sInstance == null) {
            sInstance = new LoadGamePageManager();
        }
        return sInstance;
    }

    public void preLoadGamePage(final String gid) {
        this.doLoadGameLoadingPageUrl(gid, (INetRespCallback)new INetRespCallback<LoadPage>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)LoadGamePageManager.TAG, (String)("preLoadGamePage e = " + e.getMessage()), (Object[])new Object[0]);
            }

            public void onResponse(String response, BaseResponseBean<LoadPage> res, int id2) {
                LoadGamePageManager.this.handleResponse(response, (BaseResponseBean<LoadPage>)res);
                String url = (String)LoadGamePageManager.this.mUrlMemos.get(gid);
                if (!TextUtils.isEmpty((CharSequence)url)) {
                    ImageLoader.preloadBitmap((String)url, null, (int)-1);
                }
            }
        });
    }

    public void loadGameLoadingPage(RecycleImageView imageView, String gid) {
        this.loadGameLoadingPage(imageView, gid, R.color.white);
    }

    public void loadGameLoadingPage(final RecycleImageView imageView, final String gid, final int defaultColor) {
        if (this.mUrlMemos.containsKey(gid)) {
            String url = this.mUrlMemos.get(gid);
            ImageLoader.Builder builder = ImageLoader.Builder.obtain((RecycleImageView)imageView, (String)url, (int)defaultColor);
            if (RuntimeContext.getPhoneType() == 3) {
                builder.setDecodeFormat(DecodeFormat.PREFER_ARGB_8888);
            } else {
                builder.setDecodeFormat(DecodeFormat.PREFER_RGB_565);
            }
            builder.load();
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"Find url in menos.", (Object[])new Object[0]);
            }
        } else {
            this.doLoadGameLoadingPageUrl(gid, (INetRespCallback)new INetRespCallback<LoadPage>(){

                public void onError(Call call, Exception e, int id2) {
                    MLog.error((Object)LoadGamePageManager.TAG, (String)("loadGameLoadingPage e = " + e.getMessage()), (Object[])new Object[0]);
                }

                public void onResponse(String response, BaseResponseBean<LoadPage> res, int id2) {
                    LoadGamePageManager.this.handleResponse(response, (BaseResponseBean<LoadPage>)res);
                    String url = (String)LoadGamePageManager.this.mUrlMemos.get(gid);
                    if (!TextUtils.isEmpty((CharSequence)url)) {
                        ImageLoader.Builder builder = ImageLoader.Builder.obtain((RecycleImageView)imageView, (String)LoadGamePageManager.this.resizeImageUrl(url), (int)defaultColor);
                        if (RuntimeContext.getPhoneType() == 3) {
                            builder.setDecodeFormat(DecodeFormat.PREFER_ARGB_8888);
                        } else {
                            builder.setDecodeFormat(DecodeFormat.PREFER_RGB_565);
                        }
                        builder.load();
                    }
                }
            });
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"Not find url in menos.", (Object[])new Object[0]);
            }
        }
    }

    private String resizeImageUrl(String url) {
        int width = ScreenUtils.getInstance().getWidthPixels();
        int height = ScreenUtils.getInstance().getHeightPixels();
        return url + YYImageUtils.getThumbnailPostfixPx((int)width, (int)height, (boolean)false);
    }

    private void handleResponse(String response, BaseResponseBean<LoadPage> res) {
        if (res != null && res.isSuccess() && res.data != null) {
            String gid = ((LoadPage)res.data).gameId;
            String loadPageUrl = ((LoadPage)res.data).loadPageUrl;
            if (!TextUtils.isEmpty((CharSequence)gid) && !TextUtils.isEmpty((CharSequence)loadPageUrl)) {
                this.mUrlMemos.put(gid, loadPageUrl);
            }
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)response, (Object[])new Object[0]);
        }
    }

    private void doLoadGameLoadingPageUrl(final String gid, final INetRespCallback callback2) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                JSONObject object = JsonParser.obtainJSONObject();
                try {
                    object.put("gid", (Object)gid);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("data", object.toString());
                HttpUtil.httpReq((String)UriProvider.getGameLoadingImageUrl(), data, (int)1, (INetRespCallback)callback2);
            }
        });
    }

    private class LoadPage {
        @SerializedName(value="gid")
        String gameId;
        @SerializedName(value="load_page")
        String loadPageUrl;

        private LoadPage() {
        }
    }
}

