/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameinvite.panel.view.holder;

import android.view.View;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.game.R;
import com.yy.game.module.gameinvite.panel.bean.GameShareFriendInfo;
import com.yy.game.module.gameinvite.panel.bean.GameShareInviteStatus;
import com.yy.game.module.gameinvite.panel.view.holder.GameShareBaseHolder;
import java.util.List;

public class GameShareFriendHolder
extends GameShareBaseHolder<GameShareFriendInfo> {
    private RoundImageView mImageView;
    private YYTextView tvName;
    private View tvStatus;

    public GameShareFriendHolder(View itemView) {
        super(itemView);
        this.mImageView = (RoundImageView)itemView.findViewById(R.id.iv_header);
        this.tvName = (YYTextView)itemView.findViewById(R.id.tv_name);
        this.tvStatus = itemView.findViewById(R.id.iv_status);
    }

    public void setData(GameShareFriendInfo data) {
        super.setData((Object)data);
        if (data != null) {
            ImageLoader.loadImage((RecycleImageView)this.mImageView, (String)data.mFriend.getAvatar(), (int)R.drawable.icon_avatar_default_female);
            this.tvName.setText((CharSequence)data.mFriend.getNick());
            this.updateInviteStatusView(data.mInviteStatus);
            int resId = 0;
            if (data.mFriend.isInGame()) {
                resId = R.drawable.shape_in_game_no_border;
            } else if (data.mFriend.isMatching()) {
                resId = R.drawable.shape_in_team_no_border;
            } else if (data.mFriend.isOnline()) {
                resId = R.drawable.shape_online_no_border;
            }
            this.tvStatus.setBackgroundResource(resId);
        }
    }

    public void onPartialUpdate(GameShareFriendInfo item, List<Object> payloads) {
        super.onPartialUpdate((Object)item, payloads);
        if (!FP.empty(payloads)) {
            for (int i = 0; i < payloads.size(); ++i) {
                String tag;
                Object o = payloads.get(i);
                if (!(o instanceof String) || !StringUtils.equal((String)(tag = (String)o), (String)"invite")) continue;
                this.updateInviteStatusView(item.mInviteStatus);
            }
        }
    }

    @Override
    protected void updateInviteStatusView(GameShareInviteStatus inviteStatus) {
        if (((GameShareFriendInfo)this.getData()).mFriend.isOnline()) {
            super.updateInviteStatusView(inviteStatus);
        } else if (inviteStatus.isInvited()) {
            this.tvInvite.setBackgroundColor(ColorUtils.parseColor((String)"#ffffff"));
            this.tvInvite.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_invite_friend_notified));
            this.tvInvite.setTextColor(ColorUtils.parseColor((String)"#999999"));
        } else {
            this.tvInvite.setBackgroundResource(R.drawable.shape_invite_friend_status_notifyable);
            this.tvInvite.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_invite_friend_notifyable));
            this.tvInvite.setTextColor(ColorUtils.parseColor((String)"#ffffff"));
        }
    }
}

