/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameinvite.panel.view.holder;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import biz.PluginInfo;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.game.R;
import com.yy.game.module.gameinvite.panel.bean.GameShareChannelInfo;
import com.yy.game.module.gameinvite.panel.bean.GameShareInviteStatus;
import com.yy.game.module.gameinvite.panel.view.holder.GameShareBaseHolder;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import java.util.List;

public class GameShareChannelHolder
extends GameShareBaseHolder<GameShareChannelInfo> {
    private RoundImageView mImageView;
    private YYImageView mShareView;
    private YYTextView tvChannelName;
    private YYTextView tvChannelType;
    private View vLine;

    public GameShareChannelHolder(View itemView) {
        super(itemView);
        this.mImageView = (RoundImageView)itemView.findViewById(R.id.iv_header);
        this.mShareView = (YYImageView)itemView.findViewById(R.id.iv_shape);
        this.tvChannelName = (YYTextView)itemView.findViewById(R.id.tv_channel_name);
        this.tvChannelType = (YYTextView)itemView.findViewById(R.id.tv_channel_type);
        this.vLine = itemView.findViewById(R.id.v_line);
    }

    public void setData(GameShareChannelInfo data) {
        super.setData((Object)data);
        if (data != null) {
            this.updateInviteStatusView(data.mInviteStatus);
            ImageLoader.loadImage((RecycleImageView)this.mImageView, (String)data.mChannelInfo.avatar, (int)R.drawable.icon_avatar_default_female);
            this.tvChannelName.setText((CharSequence)data.mChannelInfo.name);
            this.updateChannelPlugin();
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mShareView.getLayoutParams();
            int leftMargin = ResolutionUtils.dip2Px((float)44.0f);
            if (LanguageUtils.isRtl()) {
                leftMargin = -ResolutionUtils.dip2Px((float)3.0f);
            }
            layoutParams.leftMargin = leftMargin;
            if (Build.VERSION.SDK_INT > 16) {
                layoutParams.setMarginStart(leftMargin);
            }
            this.mShareView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void onPartialUpdate(GameShareChannelInfo item, List<Object> payloads) {
        super.onPartialUpdate((Object)item, payloads);
        if (!FP.empty(payloads)) {
            for (int i = 0; i < payloads.size(); ++i) {
                Object o = payloads.get(i);
                if (!(o instanceof String)) continue;
                String tag = (String)o;
                if (StringUtils.equal((String)tag, (String)"invite")) {
                    this.updateInviteStatusView(item.mInviteStatus);
                    continue;
                }
                if (StringUtils.equal((String)tag, (String)"header")) {
                    ImageLoader.loadImage((RecycleImageView)this.mImageView, (String)item.mChannelInfo.avatar, (int)R.drawable.icon_avatar_default_female);
                    continue;
                }
                if (!StringUtils.equal((String)tag, (String)"channel_type")) continue;
                this.updateChannelPlugin();
            }
        }
    }

    private void updateChannelPlugin() {
        if (this.getData() == null || ((GameShareChannelInfo)this.getData()).mChannelInfo == null || ((GameShareChannelInfo)this.getData()).mChannelInfo.mPluginInfo == null) {
            this.tvChannelType.setVisibility(8);
        } else {
            PluginInfo pluginInfo = ((GameShareChannelInfo)this.getData()).mChannelInfo.mPluginInfo;
            if (pluginInfo.type == 1) {
                this.tvChannelType.setVisibility(8);
            } else {
                GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(pluginInfo.pid);
                if (gameInfo != null) {
                    this.tvChannelType.setText((CharSequence)StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.tips_invite_channel_item_plugin), (Object[])new Object[]{gameInfo.getGname()}));
                }
                this.tvChannelType.setVisibility(0);
            }
        }
    }

    @Override
    protected void updateInviteStatusView(GameShareInviteStatus inviteStatus) {
        if (this.getData() != null && ((GameShareChannelInfo)this.getData()).canInvite()) {
            super.updateInviteStatusView(inviteStatus);
        } else {
            this.tvInvite.setBackgroundResource(R.drawable.bg_d3d3d3_24_corner);
            this.tvInvite.setText((CharSequence)ResourceUtils.getString((int)R.string.invite));
            this.tvInvite.setTextColor(ColorUtils.parseColor((String)"#ffffff"));
        }
    }
}

