/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameinvite.panel.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.memoryrecycle.views.YYRecyclerView;
import com.yy.base.utils.FP;
import com.yy.game.module.gameinvite.panel.view.IGameShareItemClick;
import java.util.List;
import me.drakeet.multitype.MultiTypeAdapter;

public abstract class GameShareBaseView<T>
extends CommonStatusLayout {
    protected MultiTypeAdapter mAdapter;
    private List<T> mItems;
    protected IGameShareItemClick mItemClick;

    public void setItemClick(IGameShareItemClick itemClick) {
        this.mItemClick = itemClick;
    }

    public GameShareBaseView(@NonNull Context context) {
        super(context);
        YYRecyclerView mRecyclerView = new YYRecyclerView(context, "GameShareBaseView");
        mRecyclerView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.addView((View)mRecyclerView);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context);
        linearLayoutManager.setOrientation(1);
        mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        mRecyclerView.setHasFixedSize(true);
        this.mAdapter = new MultiTypeAdapter();
        mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.registerAdapterType();
        this.showLoading();
    }

    public void setItems(List<T> items) {
        if (FP.empty(items)) {
            this.showNoData();
            return;
        }
        this.hideAllStatus();
        this.mItems = items;
        this.mAdapter.setItems(this.mItems);
        this.mAdapter.notifyDataSetChanged();
    }

    public List<T> getItems() {
        return this.mItems;
    }

    public void updateIteaInviteStatus(int position) {
        this.mAdapter.notifyItemChanged(position, (Object)"invite");
    }

    protected abstract void registerAdapterType();
}

