/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameinvite.panel;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import biz.PluginInfo;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.kvo.FindFriend;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.teammatch.module.TeamInviteServicesController;
import com.yy.game.module.gameinvite.panel.GameShareDataAdapter;
import com.yy.game.module.gameinvite.panel.bean.GameShareBaseInfo;
import com.yy.game.module.gameinvite.panel.bean.GameShareChannelInfo;
import com.yy.game.module.gameinvite.panel.bean.GameShareFriendInfo;
import com.yy.game.module.gameinvite.panel.bean.GameShareTabInfo;
import com.yy.game.module.gameinvite.panel.bean.MyShareChannelInfo;
import com.yy.game.module.gameinvite.panel.view.GameShareChannelView;
import com.yy.game.module.gameinvite.panel.view.GameShareFriendView;
import com.yy.game.module.gameinvite.panel.view.IGameShareItemClick;
import com.yy.game.module.gameinvite.panel.view.IView;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.hiyo.channel.base.callback.IPluginInfoCallBack;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import common.Header;
import ikxd.apigateway.ApiGateway;
import ikxd.apigateway.GetHFAFriendsReq;
import ikxd.apigateway.GetHFAFriendsRes;
import ikxd.apigateway.Uri;
import ikxd.apigateway.UserInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.ihago.channel.srv.mgr.ChannelPlugin;

public class GameSharePresenter {
    private static final String TAG = "GameSharePresenter";
    private IView mView;
    private Context mContext;
    private List<GameShareChannelInfo> mGameShareChannelInfoList;
    private List<GameShareFriendInfo> mGameShareFriendInfoList;
    private List<GameShareBaseInfo> mGameInvitedList;
    private Set<Long> mSeatUids;
    private IGameShareItemClick mOutClickListener;
    private GameShareDataAdapter mShareDataAdapter;
    private String mGameId;
    private Runnable mInviteRunnable = () -> this.checkInvitedTask();
    private IGameShareItemClick mItemClick = new IGameShareItemClick(){

        @Override
        public void onFriendInviteClick(GameShareFriendInfo info) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameSharePresenter.TAG, (String)"onFriendInviteClick uid: %s  name: %s  invited: %s", (Object[])new Object[]{info.mFriend.getUid(), info.mFriend.getNick(), info.mInviteStatus.isInvited()});
            }
            if (info.mInviteStatus.isInvited()) {
                return;
            }
            info.mInviteStatus.setInvited();
            GameSharePresenter.this.updateGameShareItem(info);
            if (!GameSharePresenter.this.isAdapterTeamData()) {
                GameSharePresenter.this.addInvitedListAndTimer(info);
            }
            if (GameSharePresenter.this.mOutClickListener != null) {
                GameSharePresenter.this.mOutClickListener.onFriendInviteClick(info);
            }
        }

        @Override
        public void onChannelItemInviteClick(final GameShareChannelInfo info) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameSharePresenter.TAG, (String)"onChannelItemInviteClick channelId: %s, channelName: %s  plugin: %s", (Object[])new Object[]{info.mChannelInfo.cid, info.mChannelInfo.name, info.mChannelInfo.mPluginInfo == null ? "null" : info.mChannelInfo.mPluginInfo.type});
            }
            if (!info.canInvite()) {
                if (info.mChannelInfo != null && info.mChannelInfo.mPluginInfo != null) {
                    GameSharePresenter.this.toastChannelInviteFailed(info.mChannelInfo.mPluginInfo);
                }
                return;
            }
            if (info.mInviteStatus.isInvited() || info.mInviteStatus.isInviting()) {
                return;
            }
            info.mInviteStatus.setInviting();
            HashSet<String> idList = new HashSet<String>(1);
            idList.add(info.mChannelInfo.cid);
            GameSharePresenter.this.queryChannelCurPluginId(idList, new IPluginInfoCallBack(){

                public void onGetPluginInfoList(List<ChannelPlugin> pluginInfoList) {
                    info.mInviteStatus.recoveryInviteStatus();
                    if (FP.empty((Collection)GameSharePresenter.this.mGameShareChannelInfoList)) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameSharePresenter.TAG, (String)"onChannelItemInviteClick onGetPluginInfoList but is empty", (Object[])new Object[0]);
                        }
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_channel_invite_member_failed);
                        return;
                    }
                    boolean found = false;
                    for (int i = 0; i < GameSharePresenter.this.mGameShareChannelInfoList.size(); ++i) {
                        GameShareChannelInfo channelInfo = (GameShareChannelInfo)GameSharePresenter.this.mGameShareChannelInfoList.get(i);
                        if (channelInfo == null || channelInfo.mChannelInfo == null || channelInfo.mChannelInfo.mPluginInfo == null || !StringUtils.equal((String)channelInfo.mChannelInfo.cid, (String)info.mChannelInfo.cid)) continue;
                        found = true;
                        PluginInfo pluginInfo = channelInfo.mChannelInfo.mPluginInfo;
                        if (pluginInfo.type == 1) {
                            info.mInviteStatus.setInvited();
                            GameSharePresenter.this.updateGameShareItem(info);
                            if (GameSharePresenter.this.mOutClickListener != null) {
                                GameSharePresenter.this.mOutClickListener.onChannelItemInviteClick(info);
                            }
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "game_share_invite_click").put("room_id", info.mChannelInfo.cid).put("game_id", GameSharePresenter.this.getGameId()));
                            continue;
                        }
                        GameSharePresenter.this.toastChannelInviteFailed(info.mChannelInfo.mPluginInfo);
                        return;
                    }
                    if (GameSharePresenter.this.mView != null) {
                        Collections.sort(GameSharePresenter.this.mGameShareChannelInfoList);
                        GameSharePresenter.this.mView.updateChannelList(GameSharePresenter.this.mGameShareChannelInfoList);
                    }
                    if (!found) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_channel_invite_member_failed);
                    }
                }

                public void onFailed(String msg) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_channel_invite_member_failed);
                    info.mInviteStatus.recoveryInviteStatus();
                }
            });
        }
    };

    public void setOutClickListener(IGameShareItemClick outClickListener) {
        this.mOutClickListener = outClickListener;
    }

    public GameSharePresenter(IView view, Context context, String gid) {
        this.mView = view;
        this.mContext = context;
        this.mGameId = gid;
    }

    public void createGameShareFriendDataAdapter(TeamInviteServicesController.InviteFriendContainer inviteFriendContainer) {
        if (inviteFriendContainer != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"need new GameShareDataAdapter", (Object[])new Object[0]);
            }
            this.mShareDataAdapter = new GameShareDataAdapter(inviteFriendContainer);
            this.mShareDataAdapter.setGameSharePresenter(this);
            this.mShareDataAdapter.initData();
        }
    }

    private boolean isAdapterTeamData() {
        return this.mShareDataAdapter != null;
    }

    private void checkInvitedTask() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mInviteRunnable);
        long curTime = System.currentTimeMillis();
        Iterator<GameShareBaseInfo> iterator = this.mGameInvitedList.iterator();
        long mMinDelay = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            GameShareBaseInfo info = iterator.next();
            if (info.mInviteStatus.recoveryByInvited(curTime)) {
                iterator.remove();
                this.updateGameShareItem(info);
                continue;
            }
            long mDelay = curTime - info.mInviteStatus.getInvitedTime();
            if (mDelay >= mMinDelay) continue;
            mMinDelay = mDelay;
        }
        if (this.mGameInvitedList.size() > 0) {
            YYTaskExecutor.postToMainThread((Runnable)this.mInviteRunnable, (long)mMinDelay);
        }
    }

    private void addInvitedListAndTimer(GameShareBaseInfo info) {
        if (this.mGameInvitedList == null) {
            this.mGameInvitedList = new ArrayList<GameShareBaseInfo>();
        }
        this.mGameInvitedList.add(info);
        this.checkInvitedTask();
    }

    private void updateGameShareItem(GameShareBaseInfo info) {
        if (info instanceof GameShareFriendInfo) {
            int position = -1;
            for (int i = 0; i < this.mGameShareFriendInfoList.size(); ++i) {
                GameShareFriendInfo friendInfo = this.mGameShareFriendInfoList.get(i);
                if (friendInfo != info) continue;
                position = i;
                break;
            }
            if (this.mView != null && position >= 0) {
                this.mView.updateFriendInviteStatus(0, position);
            }
        } else {
            int position = -1;
            for (int i = 0; i < this.mGameShareChannelInfoList.size(); ++i) {
                GameShareChannelInfo channelInfo = this.mGameShareChannelInfoList.get(i);
                if (channelInfo != info) continue;
                position = i;
                break;
            }
            if (this.mView != null && position >= 0) {
                this.mView.updateFriendInviteStatus(1, position);
            }
        }
    }

    private void toastChannelInviteFailed(@NonNull PluginInfo pluginInfo) {
        GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(pluginInfo.pid);
        if (gameInfo != null) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.tips_invite_channel_failed_by_plugin), (Object[])new Object[]{gameInfo.getGname()}), (int)0);
        }
    }

    public List<GameShareTabInfo> getTabList() {
        ArrayList<GameShareTabInfo> mTabList = new ArrayList<GameShareTabInfo>(2);
        mTabList.add(this.createGameShareFriendTabInfo());
        mTabList.add(this.createGameShareChannelTabInfo());
        return mTabList;
    }

    private GameShareTabInfo createGameShareFriendTabInfo() {
        GameShareTabInfo mFriendTab = new GameShareTabInfo();
        GameShareFriendView view = new GameShareFriendView(this.mContext);
        view.setItemClick(this.mItemClick);
        mFriendTab.tabView = view;
        mFriendTab.title = ResourceUtils.getString((int)R.string.title_game_share_friend_tab);
        return mFriendTab;
    }

    private GameShareTabInfo createGameShareChannelTabInfo() {
        GameShareTabInfo mChannelTab = new GameShareTabInfo();
        GameShareChannelView view = new GameShareChannelView(this.mContext);
        view.setItemClick(this.mItemClick);
        mChannelTab.tabView = view;
        mChannelTab.title = ResourceUtils.getString((int)R.string.title_game_share_channel_tab);
        return mChannelTab;
    }

    public void queryInviteFriendList() {
        if (this.isAdapterTeamData()) {
            return;
        }
        GetHFAFriendsReq req = new GetHFAFriendsReq.Builder().limit(Long.valueOf(40L)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_apigateway_d");
        ApiGateway gateway = new ApiGateway.Builder().header(header).get_hfa_friends_req(req).uri(Uri.kUriGetHFAFriendsReq).build();
        ProtoManager.getInstance().send((AndroidMessage)gateway, (IProtoCallback)new IProtoCallback<ApiGateway>(){

            public void onResponse(@Nullable ApiGateway apiGateway) {
                if (apiGateway == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameSharePresenter.TAG, (String)"queryInviteFriendList error, proto is null", (Object[])new Object[0]);
                    }
                    return;
                }
                GetHFAFriendsRes getHFAFriendsRes = apiGateway.get_hfa_friends_res;
                List userInfos = getHFAFriendsRes.users;
                StringBuilder uidStr = new StringBuilder();
                uidStr.append("[");
                GameSharePresenter.this.mGameShareFriendInfoList = new ArrayList(FP.size((Collection)userInfos));
                for (UserInfo userInfo : userInfos) {
                    if (userInfo == null) continue;
                    FindFriend friend = FindFriend.transform((UserInfo)userInfo);
                    GameSharePresenter.this.mGameShareFriendInfoList.add(new GameShareFriendInfo(friend));
                    uidStr.append("" + userInfo.uid + ", ");
                }
                uidStr.append("]");
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameSharePresenter.TAG, (String)"queryInviteFriendList success,size:%d, uids = %s", (Object[])new Object[]{GameSharePresenter.this.mGameShareFriendInfoList.size(), uidStr.toString()});
                }
                GameSharePresenter.this.updateFriendList(GameSharePresenter.this.mGameShareFriendInfoList);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameSharePresenter.TAG, (String)"queryInviteFriendList retryWhenTimeout", (Object[])new Object[0]);
                }
                YYTaskExecutor.postToMainThread(() -> GameSharePresenter.this.updateFriendList(Collections.emptyList()));
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameSharePresenter.TAG, (String)"queryInviteFriendList retryWhenError", (Object[])new Object[0]);
                }
                YYTaskExecutor.postToMainThread(() -> GameSharePresenter.this.updateFriendList(Collections.emptyList()));
                return false;
            }
        });
    }

    public void queryMyChannelList() {
        ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getMyJoinedChannels(new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

            public void onSuccess(ArrayList<MyJoinChannelItem> groupSummays) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameSharePresenter.TAG, (String)"queryMyChannelList size: %s", (Object[])new Object[]{FP.size(groupSummays)});
                }
                YYTaskExecutor.postToMainThread(() -> {
                    if (!FP.empty((Collection)groupSummays)) {
                        GameSharePresenter.this.convertToGameShareChannelList(groupSummays);
                    }
                });
            }

            public void onError(int errorCode, Exception e) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameSharePresenter.TAG, (String)"queryMyChannelList errorCode: %s , ex: %s", (Object[])new Object[]{errorCode, e});
                }
            }
        }, false);
    }

    private void convertToGameShareChannelList(List<MyJoinChannelItem> channelItemList) {
        this.mGameShareChannelInfoList = new ArrayList<GameShareChannelInfo>(channelItemList.size());
        for (int i = 0; i < channelItemList.size(); ++i) {
            MyJoinChannelItem item = channelItemList.get(i);
            if (item == null) continue;
            MyShareChannelInfo info = new MyShareChannelInfo(item);
            GameShareChannelInfo gameShareChannelInfo = new GameShareChannelInfo(info);
            this.mGameShareChannelInfoList.add(gameShareChannelInfo);
        }
        if (this.mView != null) {
            this.mView.updateChannelList(this.mGameShareChannelInfoList);
        }
        this.queryChannelAvatar();
        this.queryAllChannelCurPlugin();
    }

    private void queryChannelAvatar() {
        if (FP.empty(this.mGameShareChannelInfoList)) {
            return;
        }
        ArrayList<Long> uidList = new ArrayList<Long>(this.mGameShareChannelInfoList.size());
        for (int i = 0; i < this.mGameShareChannelInfoList.size(); ++i) {
            GameShareChannelInfo info = this.mGameShareChannelInfoList.get(i);
            uidList.add(info.mChannelInfo.ownerUid);
        }
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uidList, new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameSharePresenter.TAG, (String)"queryChannelAvatar onSuccess size: %s", (Object[])new Object[]{FP.size(userInfoKSList)});
                }
                if (FP.empty(userInfoKSList)) {
                    return;
                }
                block0: for (int i = 0; i < GameSharePresenter.this.mGameShareChannelInfoList.size(); ++i) {
                    GameShareChannelInfo info = (GameShareChannelInfo)GameSharePresenter.this.mGameShareChannelInfoList.get(i);
                    for (int j = 0; j < userInfoKSList.size(); ++j) {
                        UserInfoKS userInfoKS = userInfoKSList.get(j);
                        if (userInfoKS == null || userInfoKS.uid != info.mChannelInfo.ownerUid) continue;
                        info.mChannelInfo.avatar = userInfoKS.avatar;
                        info.mChannelInfo.gender = userInfoKS.getSex();
                        continue block0;
                    }
                }
                YYTaskExecutor.postToMainThread(() -> {
                    if (GameSharePresenter.this.mView != null) {
                        GameSharePresenter.this.mView.updateChannelAvatar();
                    }
                });
            }

            public void onFail(int id2, String msg, String response) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameSharePresenter.TAG, (String)"queryChannelAvatar onFail", (Object[])new Object[0]);
                }
            }
        });
    }

    private void queryAllChannelCurPlugin() {
        if (FP.empty(this.mGameShareChannelInfoList)) {
            return;
        }
        HashSet<String> idList = new HashSet<String>(this.mGameShareChannelInfoList.size());
        for (int i = 0; i < this.mGameShareChannelInfoList.size(); ++i) {
            GameShareChannelInfo info = this.mGameShareChannelInfoList.get(i);
            if (info == null || info.mChannelInfo == null) continue;
            idList.add(info.mChannelInfo.cid);
        }
        this.queryChannelCurPluginId(idList, new IPluginInfoCallBack(){

            public void onGetPluginInfoList(List<ChannelPlugin> pluginInfoList) {
                if (GameSharePresenter.this.mView != null && !FP.empty(pluginInfoList)) {
                    Collections.sort(GameSharePresenter.this.mGameShareChannelInfoList);
                    GameSharePresenter.this.mView.updateChannelList(GameSharePresenter.this.mGameShareChannelInfoList);
                }
            }

            public void onFailed(String msg) {
            }
        });
    }

    private void queryChannelCurPluginId(HashSet<String> cidList, final IPluginInfoCallBack callBack) {
        if (FP.empty(cidList)) {
            return;
        }
        ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).queryChannelPluginInfoByCid(cidList, new IPluginInfoCallBack(){

            public void onGetPluginInfoList(List<ChannelPlugin> pluginInfoList) {
                if (!FP.empty(pluginInfoList)) {
                    block0: for (int i = 0; i < pluginInfoList.size(); ++i) {
                        ChannelPlugin info = pluginInfoList.get(i);
                        if (info == null) continue;
                        for (int j = 0; j < GameSharePresenter.this.mGameShareChannelInfoList.size(); ++j) {
                            GameShareChannelInfo gameShareChannelInfo = (GameShareChannelInfo)GameSharePresenter.this.mGameShareChannelInfoList.get(j);
                            if (gameShareChannelInfo == null || gameShareChannelInfo.mChannelInfo == null || !StringUtils.equal((String)gameShareChannelInfo.mChannelInfo.cid, (String)info.cid) || info.plugin_info == null) continue;
                            gameShareChannelInfo.mChannelInfo.mPluginInfo = info.plugin_info;
                            continue block0;
                        }
                    }
                } else if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameSharePresenter.TAG, (String)"queryChannelCurPluginId size is 0", (Object[])new Object[0]);
                }
                if (callBack != null) {
                    callBack.onGetPluginInfoList(pluginInfoList);
                }
            }

            public void onFailed(String msg) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameSharePresenter.TAG, (String)"queryChannelCurPluginId msg: %s", (Object[])new Object[]{msg});
                }
                if (callBack != null) {
                    callBack.onFailed(msg);
                }
            }
        });
    }

    public void resume() {
        if (FP.size(this.mGameInvitedList) > 0 && !this.isAdapterTeamData()) {
            this.checkInvitedTask();
        }
    }

    public void release() {
        YYTaskExecutor.removeTask((Runnable)this.mInviteRunnable);
    }

    public void onSeatChanged(Set<Long> mSeatUsers) {
        this.mSeatUids = mSeatUsers;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onSeatChanged : %s  size: %s", (Object[])new Object[]{this.mSeatUids, FP.size(this.mGameShareFriendInfoList)});
        }
        if (FP.empty(this.mSeatUids) || FP.empty(this.mGameShareFriendInfoList)) {
            return;
        }
        ArrayList<GameShareFriendInfo> mList = new ArrayList<GameShareFriendInfo>(this.mGameShareFriendInfoList.size());
        for (int i = 0; i < this.mGameShareFriendInfoList.size(); ++i) {
            GameShareFriendInfo info = this.mGameShareFriendInfoList.get(i);
            if (info == null || info.mFriend == null || this.mSeatUids.contains(info.mFriend.getUid())) continue;
            info.mInviteStatus.recoveryInviteStatus();
            mList.add(info);
        }
        YYTaskExecutor.postToMainThread(() -> this.updateFriendList(mList));
    }

    public void updateFriendList(List<GameShareFriendInfo> data) {
        this.mGameShareFriendInfoList = data;
        if (this.mView != null) {
            this.mView.updateFriendList(data);
        }
    }

    public void updateFriendItemInviteStatus(GameShareFriendInfo info) {
        if (FP.empty(this.mGameShareFriendInfoList) || info == null) {
            return;
        }
        int position = -1;
        for (int i = 0; i < this.mGameShareFriendInfoList.size(); ++i) {
            GameShareFriendInfo friendInfo = this.mGameShareFriendInfoList.get(i);
            if (friendInfo.mFriend.getUid() != info.mFriend.getUid()) continue;
            if (info.mInviteStatus.isInvited()) {
                friendInfo.mInviteStatus.setInvited();
            } else {
                friendInfo.mInviteStatus.recoveryInviteStatus();
            }
            position = i;
            break;
        }
        if (this.mView != null && position >= 0) {
            this.mView.updateFriendInviteStatus(0, position);
        }
    }

    public String getGameId() {
        return this.mGameId;
    }
}

