/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameinvite.panel;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.RelativeLayout;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.ui.widget.tablayout.SlidingTabLayout;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.ui.BasePanel;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.teammatch.module.TeamInviteServicesController;
import com.yy.game.module.gameinvite.panel.GameShareAdapter;
import com.yy.game.module.gameinvite.panel.GameSharePresenter;
import com.yy.game.module.gameinvite.panel.bean.GameShareChannelInfo;
import com.yy.game.module.gameinvite.panel.bean.GameShareFriendInfo;
import com.yy.game.module.gameinvite.panel.bean.GameShareTabInfo;
import com.yy.game.module.gameinvite.panel.view.GameShareBaseView;
import com.yy.game.module.gameinvite.panel.view.GameShareChannelView;
import com.yy.game.module.gameinvite.panel.view.GameShareFriendView;
import com.yy.game.module.gameinvite.panel.view.IGameShareItemClick;
import com.yy.game.module.gameinvite.panel.view.IView;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;
import java.util.Set;

public class GameSharePanel
extends BasePanel
implements IView {
    private Context mContext;
    private View mView;
    private SlidingTabLayout mTabs;
    private YYViewPager mViewPager;
    private GameShareAdapter mAdapter;
    private GameSharePresenter mPresenter;
    private boolean isLand;

    public void setItemClick(IGameShareItemClick itemClick) {
        this.mPresenter.setOutClickListener(itemClick);
    }

    public GameSharePanel(Context context, boolean isLand, String gameId) {
        super(context);
        this.mContext = context;
        this.isLand = isLand;
        this.mPresenter = new GameSharePresenter(this, this.mContext, gameId);
        this.createView();
    }

    public void setInviteFriendContainer(TeamInviteServicesController.InviteFriendContainer inviteFriendContainer) {
        this.mPresenter.createGameShareFriendDataAdapter(inviteFriendContainer);
    }

    private void adjustLand() {
        Animation hideAnimation;
        Animation showAnimation;
        int width = this.isLand ? ResolutionUtils.dip2Px((float)230.0f) : -1;
        int height = this.isLand ? -1 : ResolutionUtils.dip2Px((float)495.0f);
        int rule = 12;
        if (this.isLand) {
            rule = LanguageUtils.isLtr() ? 11 : 9;
        }
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mView.getLayoutParams();
        lp.width = width;
        lp.height = height;
        lp.addRule(rule);
        this.mView.setLayoutParams((ViewGroup.LayoutParams)lp);
        if (this.isLand) {
            if (LanguageUtils.isLtr()) {
                showAnimation = this.createRightShowAnimation();
                hideAnimation = this.createRightHideAnimation();
            } else {
                showAnimation = this.createLeftShowAnimation();
                hideAnimation = this.createLeftHideAnimation();
            }
        } else {
            showAnimation = this.createBottomShowAnimation();
            hideAnimation = this.createBottomHideAnimation();
        }
        this.setShowAnim(showAnimation);
        this.setHideAnim(hideAnimation);
    }

    private void createView() {
        this.mView = View.inflate((Context)this.mContext, (int)R.layout.layout_game_share, null);
        this.setContent(this.mView);
        this.adjustLand();
        this.mViewPager = (YYViewPager)this.mView.findViewById(R.id.share_view_pager);
        this.mTabs = (SlidingTabLayout)this.mView.findViewById(R.id.share_tabs);
        List<GameShareTabInfo> mTabList = this.mPresenter.getTabList();
        this.mAdapter = new GameShareAdapter(mTabList);
        this.mViewPager.setAdapter((PagerAdapter)this.mAdapter);
        this.mTabs.setViewPager((ViewPager)this.mViewPager);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                if (position == 1) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "game_share_room_click").put("game_id", GameSharePanel.this.mPresenter.getGameId()));
                }
            }
        });
        YYTaskExecutor.execute(() -> {
            this.mPresenter.queryInviteFriendList();
            this.mPresenter.queryMyChannelList();
        }, (long)300L);
    }

    @Override
    public void updateFriendList(List<GameShareFriendInfo> data) {
        if (this.mAdapter != null && this.mAdapter.getItem(0) != null && this.mAdapter.getItem((int)0).tabView != null) {
            GameShareFriendView view = (GameShareFriendView)this.mAdapter.getItem((int)0).tabView;
            view.setItems(data);
        }
    }

    @Override
    public void updateFriendInviteStatus(int tabIndex, int position) {
        if (this.mAdapter != null && this.mAdapter.getItem(tabIndex) != null && this.mAdapter.getItem((int)tabIndex).tabView != null) {
            GameShareBaseView view = (GameShareBaseView)this.mAdapter.getItem((int)tabIndex).tabView;
            view.updateIteaInviteStatus(position);
        }
    }

    @Override
    public void updateChannelList(List<GameShareChannelInfo> data) {
        if (this.mAdapter != null && this.mAdapter.getItem(1) != null && this.mAdapter.getItem((int)1).tabView != null) {
            GameShareChannelView view = (GameShareChannelView)this.mAdapter.getItem((int)1).tabView;
            view.setItems(data);
        }
    }

    @Override
    public void updateChannelAvatar() {
        if (this.mAdapter != null && this.mAdapter.getItem(1) != null && this.mAdapter.getItem((int)1).tabView != null) {
            GameShareChannelView view = (GameShareChannelView)this.mAdapter.getItem((int)1).tabView;
            view.updateChannelAvatar();
        }
    }

    protected void onShow() {
        super.onShow();
        this.mPresenter.resume();
    }

    protected void onHide() {
        super.onHide();
        this.mPresenter.release();
    }

    public void onSeatChanged(Set<Long> mSeatUsers) {
        this.mPresenter.onSeatChanged(mSeatUsers);
    }
}

