/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameinvite.panel;

import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.game.gamemodule.teamgame.teammatch.module.TeamInviteServicesController;
import com.yy.game.module.gameinvite.panel.GameSharePresenter;
import com.yy.game.module.gameinvite.panel.bean.GameShareFriendInfo;
import com.yy.hiyo.game.base.teamgame.InviteFriendData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class GameShareDataAdapter {
    private static final String TAG = "GameShareDataAdapter";
    TeamInviteServicesController.InviteFriendContainer inviteFriendContainer;
    private List<InviteFriendData> mFriendDataList;
    private GameSharePresenter mGameSharePresenter;

    public void setGameSharePresenter(GameSharePresenter gameSharePresenter) {
        this.mGameSharePresenter = gameSharePresenter;
    }

    public GameShareDataAdapter(TeamInviteServicesController.InviteFriendContainer inviteFriendContainer) {
        this.inviteFriendContainer = inviteFriendContainer;
    }

    public void initData() {
        this.mFriendDataList = this.inviteFriendContainer.friends;
        if (!FP.empty(this.mFriendDataList)) {
            for (int i = 0; i < this.mFriendDataList.size(); ++i) {
                InviteFriendData data = this.mFriendDataList.get(i);
                Kvo.addKvoBinding((KvoSource)data, (Object)this, (String)"onInviteChange");
            }
        }
        Kvo.addKvoBinding((KvoSource)this.inviteFriendContainer, (Object)this, (String)"onInviteFriendsChange");
    }

    @KvoMethodAnnotation(name="friends", sourceClass=TeamInviteServicesController.InviteFriendContainer.class, thread=1)
    public void onInviteFriendsChange(KvoEventIntent event) {
        CopyOnWriteArrayList<InviteFriendData> list = new CopyOnWriteArrayList<InviteFriendData>(((TeamInviteServicesController.InviteFriendContainer)event.source()).friends);
        this.removeAndBindAgain(this.mFriendDataList, list);
        this.mFriendDataList = list;
        List<GameShareFriendInfo> friendInfoList = this.transformGameShareFriendList(this.mFriendDataList);
        this.mGameSharePresenter.updateFriendList(friendInfoList);
        MLog.debug((Object)TAG, (String)"onInviteFriendsChange  size: %s", (Object[])new Object[]{FP.size(friendInfoList)});
    }

    private void removeAndBindAgain(List<InviteFriendData> unBind, List<InviteFriendData> needBind) {
        int i;
        if (!FP.empty(unBind)) {
            for (i = 0; i < unBind.size(); ++i) {
                Kvo.removeKvoBinding((KvoSource)((KvoSource)unBind.get(i)), (Object)this, (String)"onInviteChange");
            }
        }
        if (!FP.empty(needBind)) {
            for (i = 0; i < needBind.size(); ++i) {
                Kvo.addKvoBinding((KvoSource)((KvoSource)needBind.get(i)), (Object)this, (String)"onInviteChange");
            }
        }
    }

    private List<GameShareFriendInfo> transformGameShareFriendList(List<InviteFriendData> data) {
        if (FP.empty(data)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<GameShareFriendInfo> mFriendList = new ArrayList<GameShareFriendInfo>(data.size());
        for (int i = 0; i < data.size(); ++i) {
            InviteFriendData info = data.get(i);
            if (info == null || info.mFriends == null) continue;
            GameShareFriendInfo friendInfo = this.transformGameShareFriend(info);
            mFriendList.add(friendInfo);
        }
        return mFriendList;
    }

    private GameShareFriendInfo transformGameShareFriend(InviteFriendData info) {
        if (info == null || info.mFriends == null) {
            return null;
        }
        GameShareFriendInfo friendInfo = new GameShareFriendInfo(info.mFriends);
        if (info.inviteState == 0) {
            friendInfo.mInviteStatus.recoveryInviteStatus();
        } else {
            friendInfo.mInviteStatus.setInvited();
        }
        friendInfo.mInviteFriendData = info;
        return friendInfo;
    }

    @KvoMethodAnnotation(name="inviteState", sourceClass=InviteFriendData.class, thread=1)
    public void onInviteChange(KvoEventIntent event) {
        InviteFriendData friendData = (InviteFriendData)event.source();
        boolean invatable = friendData.inviteState == 0;
        MLog.debug((Object)TAG, (String)"onInviteChange  name: %s uid: %s state: %s", (Object[])new Object[]{friendData.mFriends.getNick(), friendData.mFriends.getUid(), invatable});
        GameShareFriendInfo info = this.transformGameShareFriend(friendData);
        this.mGameSharePresenter.updateFriendItemInviteStatus(info);
    }
}

