/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameinvite;

import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.game.base.BaseGameReqBean;
import com.yy.hiyo.game.base.GameNotificationDef;
import com.yy.hiyo.game.base.IMGameCancelReqBean;
import com.yy.hiyo.game.base.IMGameReqBean;
import com.yy.hiyo.game.base.IMGameResBean;
import com.yy.hiyo.game.base.IMPKAcceptReqBean;
import com.yy.hiyo.game.base.IMPKAcceptResBean;
import com.yy.hiyo.game.base.PkGameResource;
import com.yy.hiyo.game.service.callback.IIMPKGameListener;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import common.Header;
import ikxd.pkgame.IKXDPKGameUri;
import ikxd.pkgame.IKXDPkGameProto;
import ikxd.pkgame.PPkGameImPkAcceptReq;
import ikxd.pkgame.PPkGameImPkAcceptRes;
import ikxd.pkgame.PPkGameImPkCancelReq;
import ikxd.pkgame.PPkGameImPkCancelRes;
import ikxd.pkgame.PPkGameImPkReq;
import ikxd.pkgame.PPkGameImPkRes;
import java.util.Map;

public class PkGameProtocolHelper {
    private static final String TAG = "PkGameProtocolHelper";

    public static void gamePkRequest(final IMGameReqBean gameReqBean, Map<String, Integer> gameLoseCount, final IIMPKGameListener listener) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"gamePkRequest", (Object[])new Object[0]);
        }
        if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"gamePkRequest IMGameReqBean %s", (Object[])new Object[]{new Gson().toJson((Object)gameReqBean)});
        }
        String gameId = gameReqBean.getGameId();
        String nick = gameReqBean.getMyNick();
        String picUrl = gameReqBean.getMyPicUrl();
        PPkGameImPkReq.Builder builder = new PPkGameImPkReq.Builder().target_uid(Long.valueOf(gameReqBean.getTargetUid())).game_id(gameId == null ? "" : gameId).my_nick(nick == null ? "" : nick).is_new_user(Boolean.valueOf(AccountUtil.isTodayRegister())).my_pic_url(picUrl == null ? "" : picUrl).from_type(Long.valueOf(gameReqBean.getFromType())).my_sex(Integer.valueOf(gameReqBean.getMySex())).is_gold(Boolean.valueOf(gameReqBean.isGoldGame())).b_experiment(Boolean.valueOf(gameReqBean.isExperiment())).game_ver(Long.valueOf(StringUtils.parseLong((String)gameReqBean.getGameVersion())));
        if (gameLoseCount.get(gameReqBean.getGameId()) != null) {
            builder.game_defeat_count(gameLoseCount.get(gameReqBean.getGameId()));
        }
        PPkGameImPkReq req = builder.build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto pkGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriIKXDPkGameImPkReq).im_pk_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)pkGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto response) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PkGameProtocolHelper.TAG, (String)"gamePkRequest onResponse", (Object[])new Object[0]);
                }
                if (response == null) {
                    if (listener != null) {
                        listener.onPkFail((BaseGameReqBean)gameReqBean);
                    }
                } else if (response.uri == IKXDPKGameUri.kUriIKXDPkGameImPkRes) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PkGameProtocolHelper.TAG, (String)"kUriIKXDPkGameImPkRes", (Object[])new Object[0]);
                    }
                    PPkGameImPkRes pPkGameImPkRes = response.im_pk_res;
                    if (listener != null) {
                        IMGameResBean.Builder builder = IMGameResBean.newBuilder();
                        IMGameResBean gameResBean = builder.fromType(pPkGameImPkRes.from_type.longValue()).gameId(pPkGameImPkRes.game_id).pk_id(pPkGameImPkRes.pk_id).reqTime(pPkGameImPkRes.req_time * 1000L).targetUid(pPkGameImPkRes.target_uid.longValue()).isGoldGame(pPkGameImPkRes.is_gold.booleanValue()).timeout(pPkGameImPkRes.timeout.longValue()).code(response.header.code.longValue()).build();
                        listener.onPkGameImPkRes(gameResBean);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onPkFail((BaseGameReqBean)gameReqBean);
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onPkFail((BaseGameReqBean)gameReqBean);
                        }
                    }
                });
                return false;
            }
        });
    }

    public static void gamePkCancelRequest(IMGameCancelReqBean gameReqBean, final IIMPKGameListener listener) {
        PPkGameImPkCancelReq req = new PPkGameImPkCancelReq.Builder().target_uid(Long.valueOf(gameReqBean.getTargetUid())).pk_id(gameReqBean.getPkId()).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto pkGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriIKXDPkGameImPkCancelReq).im_pk_cancel_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)pkGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto response) {
                if (response != null && response.uri == IKXDPKGameUri.kUriIKXDPkGameImPkCancelRes) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PkGameProtocolHelper.TAG, (String)"kUriIKXDPkGameImPkCancelRes", (Object[])new Object[0]);
                    }
                    PPkGameImPkCancelRes pPkGameImPkRes = response.im_pk_cancel_res;
                    if (listener != null) {
                        listener.onPkCancelRes();
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return true;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    public static void gamePKAcceptReq(final IMPKAcceptReqBean gameReqBean, final IIMPKGameListener listener) {
        if (gameReqBean == null) {
            MLog.error((Object)TAG, (String)"gameReq null", (Object[])new Object[0]);
            return;
        }
        PPkGameImPkAcceptReq req = new PPkGameImPkAcceptReq.Builder().accept(Boolean.valueOf(gameReqBean.isAccept())).my_nick(gameReqBean.getMyNick()).my_pic_url(gameReqBean.getMyPicUrl()).pk_id(gameReqBean.getPkId()).my_sex(Integer.valueOf(gameReqBean.getMySex())).is_new_user(Boolean.valueOf(AccountUtil.isTodayRegister())).refuse_type(Integer.valueOf(0)).game_ver(Long.valueOf(StringUtils.parseLong((String)gameReqBean.getGameVersion()))).is_gold(Boolean.valueOf(gameReqBean.isGoldGame())).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto pkGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriIKXDPkGameImPkAcceptReq).im_pk_accept_req(req).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"gamePKAcceptReq==>seqid=%s", (Object[])new Object[]{header.seqid});
        }
        ProtoManager.getInstance().send((AndroidMessage)pkGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto response) {
                if (response != null && response.uri == IKXDPKGameUri.kUriIKXDPkGameImPkAcceptRes) {
                    PPkGameImPkAcceptRes pPkGameImPkAcceptRes = response.im_pk_accept_res;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PkGameProtocolHelper.TAG, (String)"PkAcceptRes isGoldGame :%b", (Object[])new Object[]{pPkGameImPkAcceptRes.is_gold});
                    }
                    PkGameResource.Builder resBuilder = PkGameResource.newBuilder();
                    PkGameResource resource = resBuilder.roomid(pPkGameImPkAcceptRes.resource.roomId).token(pPkGameImPkAcceptRes.resource.token.toByteArray()).url(pPkGameImPkAcceptRes.resource.url).payload(pPkGameImPkAcceptRes.resource.info_payload).build();
                    IMPKAcceptResBean.Builder builder = IMPKAcceptResBean.newBuilder();
                    IMPKAcceptResBean gameResBean = builder.accept(pPkGameImPkAcceptRes.accept.booleanValue()).gameId(pPkGameImPkAcceptRes.gameid).fromType(pPkGameImPkAcceptRes.from_type.longValue()).inviteUid(pPkGameImPkAcceptRes.invite_uid.longValue()).pkId(pPkGameImPkAcceptRes.pk_id).resource(resource).isGoldGame(pPkGameImPkAcceptRes.is_gold.booleanValue()).code(response.header.code.longValue()).build();
                    if (listener != null) {
                        listener.onPkAcceptRes(gameResBean);
                    }
                    if (gameReqBean.isAccept()) {
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.GAME_ACCEPT_INVITE, (Object)pPkGameImPkAcceptRes.invite_uid));
                    } else {
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.GAME_REJECT_INVITE, (Object)gameResBean));
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return true;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }
}

