/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameinvite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.im.GameMessageModel;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.Environment;
import com.yy.game.bean.GameDataModel;
import com.yy.game.module.gameinvite.PkGameProtocolHelper;
import com.yy.hiyo.game.base.GameProDef;
import com.yy.hiyo.game.base.IMGameCancelReqBean;
import com.yy.hiyo.game.base.IMGameReqBean;
import com.yy.hiyo.game.base.IMGameResBean;
import com.yy.hiyo.game.base.IMPKAcceptReqBean;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IPkGameInviteService;
import com.yy.hiyo.game.service.callback.IIMPKGameListener;
import com.yy.hiyo.im.ImDataFactory;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.ImMsgReqParam;

public class PkGameInviteController
extends DefaultController
implements IPkGameInviteService {
    private static final String TAG = "PkGameInviteController";

    public PkGameInviteController(Environment env) {
        super(env);
    }

    public void pkGameReq(@NonNull IMGameReqBean bean, @Nullable IIMPKGameListener listener) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"pkGameReq gameId=%s", (Object[])new Object[]{bean.getGameId()});
        }
        PkGameProtocolHelper.gamePkRequest(bean, GameDataModel.getGame_lose_count(), listener);
    }

    public void pkGameReq(@NonNull IMGameReqBean bean, final boolean isSendMsg, final @Nullable IIMPKGameListener listener) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"pkGameReq send bean = %s", (Object[])new Object[]{bean});
        }
        PkGameProtocolHelper.gamePkRequest(bean, GameDataModel.getGame_lose_count(), new IIMPKGameListener(){

            public void onPkGameImPkRes(IMGameResBean imGameResBean) {
                if (!isSendMsg || imGameResBean.getFromType() == (long)GameProDef.GROUP_PK_REQ) {
                    // empty if block
                }
                if (listener != null) {
                    listener.onPkGameImPkRes(imGameResBean);
                }
            }
        });
    }

    public void pkGameCancelReq(@NonNull IMGameCancelReqBean bean, @NonNull String gameId, @Nullable IIMPKGameListener listener) {
        this.pkGameCancelReq(bean, gameId, true, listener);
    }

    public void pkGameCancelReq(@NonNull IMGameCancelReqBean bean, @NonNull String gameId, boolean sendMsg, @Nullable IIMPKGameListener listener) {
        GameInfo gameInfo;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"pkGameCancelReq gameId=%s", (Object[])new Object[]{gameId});
        }
        if ((gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId)) == null) {
            return;
        }
        PkGameProtocolHelper.gamePkCancelRequest(bean, listener);
        if (sendMsg && bean.getFromType() != (long)GameProDef.GROUP_PK_REQ) {
            GameMessageModel gameMessageModel = new GameMessageModel();
            gameMessageModel.setGameId(gameInfo.getGid());
            gameMessageModel.setGameName(gameInfo.getGname());
            gameMessageModel.setToUserId(bean.getTargetUid());
            gameMessageModel.setPkId(bean.getPkId());
            gameMessageModel.setType(1);
            gameMessageModel.setGameVersion(Integer.valueOf(gameInfo.getModulerVer()).intValue());
            YYTaskExecutor.execute(() -> {
                ImMsgReqParam reqParam = ImDataFactory.INSTANCE.sendPkMsg(gameMessageModel);
                if (reqParam != null) {
                    ((ImService)this.getServiceManager().getService(ImService.class)).getSendService().sendOldIMHttpMsg(reqParam, null);
                }
            });
        }
    }

    public void pkGameImPkAcceptReq(@NonNull IMPKAcceptReqBean bean, @Nullable IIMPKGameListener listener) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"pkGameImPkAcceptReq gameId=%s", (Object[])new Object[]{bean.getPkId()});
        }
        PkGameProtocolHelper.gamePKAcceptReq(bean, listener);
    }

    public void registerPKGameNotify(@NonNull IIMPKGameListener listener) {
        GameDataModel.instance.addPKGameListener(listener);
    }

    public void unregisterPKGameNotify(@NonNull IIMPKGameListener listener) {
        GameDataModel.instance.removePKGameListener(listener);
    }
}

