/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameinvite;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.util.ShortNameUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.R;
import com.yy.framework.core.Environment;
import com.yy.game.R;
import com.yy.game.utils.Utils;
import com.yy.hiyo.game.base.GameMsgBean;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IMsgInviteService;
import com.yy.hiyo.game.service.callback.IIndepGameAcceptCallback;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import common.Header;
import ikxd.msg.MsgInnerType;
import ikxd.msg.MsgType;
import ikxd.msg.PushPayloadType;
import ikxd.pkgame.IKXDPKGameUri;
import ikxd.pkgame.IKXDPkGameProto;
import ikxd.pkgame.IndepGameAcceptReq;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgInviteController
extends DefaultController
implements IMsgInviteService {
    private static final String TAG = "MsgInviteController";

    public MsgInviteController(Environment env) {
        super(env);
    }

    public void inviteGame(GameMsgBean gameInviteBean) {
        if (gameInviteBean == null) {
            return;
        }
        String sessionId = Utils.getSessionId(AccountUtil.getUid(), gameInviteBean.getToUserId());
        if (this.getServiceManager() == null) {
            return;
        }
        if (this.getServiceManager().getService(IGameInfoService.class) == null) {
            return;
        }
        if (this.getServiceManager().getService(IUserInfoService.class) == null) {
            return;
        }
        GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameInviteBean.getGameId());
        if (gameInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"\u6e38\u620f\u4e2d\u53d1\u8d77\u9080\u8bf7\u7684\u65f6\u5019\u6e38\u620f\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        UserInfoBean otherUserInfo = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(gameInviteBean.getToUserId(), null);
        UserInfoBean myUserInfo = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null);
        if (otherUserInfo == null) {
            return;
        }
        if (myUserInfo == null) {
            return;
        }
        long toUid = 0L;
        JSONObject payloadJson = JsonParser.obtainJSONObject();
        try {
            toUid = gameInviteBean.getToUserId();
            payloadJson.put("gameTimeLimitType", 2);
            payloadJson.put("gameUrl", (Object)gameInfo.getIconUrl());
            payloadJson.put("gameId", (Object)gameInfo.getGid());
            payloadJson.put("gameName", (Object)gameInfo.getGname());
            payloadJson.put("toUserId", gameInviteBean.getToUserId());
            payloadJson.put("toUserName", (Object)otherUserInfo.getNick());
            payloadJson.put("fromUserId", AccountUtil.getUid());
            payloadJson.put("fromUserName", (Object)myUserInfo.getNick());
            payloadJson.put("fromUserAvatar", (Object)myUserInfo.getAvatar());
            payloadJson.put("fromUserSex", myUserInfo.getSex());
            payloadJson.put("version", (Object)VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext).aboutDisplayName(RuntimeContext.sApplicationContext));
            payloadJson.put("gameVersion", (Object)gameInfo.getModulerVer());
            payloadJson.put("infoPayload", (Object)gameInviteBean.getInfoPayload());
            payloadJson.put("type", PushPayloadType.kPushPayloadIm.getValue());
            payloadJson.put("msgType", 0);
            payloadJson.put("fromUserId", AccountUtil.getUid());
            payloadJson.put("roomId", (Object)gameInviteBean.getRoomId());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String content = gameInviteBean.getContent();
        if (TextUtils.isEmpty((CharSequence)content)) {
            content = ResourceUtils.getString((int)R.string.invite_game, (Object[])new Object[]{gameInfo.getGname()});
        }
        String msgContent = this.initMsgInviteContent(gameInfo.getGid(), payloadJson.toString());
        long finalToUid = toUid;
        ImMsgReqParam.Builder builder = ImMsgReqParam.newBuilder().msg(msgContent).sessionId(sessionId).toUid(finalToUid).pushTitle(ResourceUtils.getString((int)R.string.hago_app_name)).pushContent(ShortNameUtils.getShortName((String)myUserInfo.getNick(), (int)7) + content).innerType((long)MsgInnerType.kMsgInnerPK.getValue()).msgType((long)MsgType.kMsgTypeUser.getValue()).pushPayload(payloadJson.toString());
        ((ImService)this.getServiceManager().getService(ImService.class)).getSendService().sendOldIMHttpMsg(builder.build(), null);
    }

    public void indepGameAccept(final String roomId, final IIndepGameAcceptCallback callback2) {
        IndepGameAcceptReq req = new IndepGameAcceptReq.Builder().room_id(roomId == null ? "" : roomId).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto proto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriIKXDPkGameIndepGameAcceptReq).indep_game_accept_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)proto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto proto) {
                if (proto == null || proto.header == null) {
                    return;
                }
                if (proto.header.code == 0L) {
                    if (callback2 != null) {
                        callback2.onIndepGameAcceptSuccess(roomId);
                    }
                } else if (callback2 != null) {
                    callback2.onIndepGameAcceptFail(proto.header.code.longValue(), roomId);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    private String initMsgInviteContent(String gameId, String payloadJson) {
        JSONObject msgJson = JsonParser.obtainJSONObject();
        try {
            JSONObject contentJson = JsonParser.obtainJSONObject();
            contentJson.put("gameid", (Object)gameId);
            msgJson.put("pk", (Object)contentJson);
            msgJson.put("payload", (Object)payloadJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return msgJson.toString();
    }
}

