/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameinvite;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.AppsFlyerEvent;
import com.yy.appbase.appsflyer.AppsFlyerHelper;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.service.IUserInfoService;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.game.gamemodule.teamgame.teammatch.model.TeamInfo;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.TeamGameNotifyHandler;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.TeamGameProtocolHelper;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGameInviteNotifyListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamImCancelCreateCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamImInviteAcceptCallback;
import com.yy.game.gamemodule.teamgame.teammatch.services.ITeamCreateCallback;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameTeamInviteService;
import com.yy.hiyo.game.service.callback.IIMTeamGameListener;
import com.yy.hiyo.im.ImDataFactory;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.ImMsgReqParam;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GameTeamInviteController
extends DefaultController
implements IGameTeamInviteService,
ITeamGameInviteNotifyListener {
    private static final String TAG = "GameTeamInviteController";
    private ConcurrentLinkedQueue<IIMTeamGameListener> mIMTeamGameListenerList = new ConcurrentLinkedQueue();
    private TeamGameNotifyHandler mTeamGameNotifyHandler = new TeamGameNotifyHandler();

    public GameTeamInviteController(Environment env) {
        super(env);
        this.mTeamGameNotifyHandler.register(this);
        this.mTeamGameNotifyHandler.startTeamGameNotify();
    }

    public void teamInviteByIm(String gameId, String teamId, int gameTemplate, long targetUid) {
        GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
        if (gameInfo == null) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"teamInviteByIm teamId= %s", (Object[])new Object[]{teamId});
        }
        GameMessageModel gameMessageModel = new GameMessageModel();
        gameMessageModel.setGameId(gameId);
        gameMessageModel.setGameName(gameInfo.getGname());
        gameMessageModel.setType(0);
        gameMessageModel.setToUserId(targetUid);
        gameMessageModel.setTeamId(teamId);
        gameMessageModel.setGameTemplate(gameTemplate);
        gameMessageModel.setGameVersion(Integer.valueOf(gameInfo.getModulerVer()).intValue());
        gameMessageModel.setInviteType(2);
        UserInfoBean userInfoBean = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null);
        if (userInfoBean != null) {
            gameMessageModel.setFromUserName(userInfoBean.getNick());
            gameMessageModel.setFromUserAvatar(userInfoBean.getAvatar());
            gameMessageModel.setFromUserSex(userInfoBean.getSex());
        }
        YYTaskExecutor.execute(() -> {
            ImMsgReqParam msgReqParam = ImDataFactory.INSTANCE.sendPkMsg(gameMessageModel);
            if (msgReqParam != null) {
                ((ImService)this.getServiceManager().getService(ImService.class)).getSendService().sendOldIMHttpMsg(msgReqParam, null);
            }
        });
        AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent(AppsFlyerEvent.INVITE_GAME_NUM));
    }

    public void teamImInviteReq(final GameInfo gameInfo, final int gameTemplate, UserInfoBean userInfo, final long targetUid, final IIMTeamGameListener listener) {
        TeamGameProtocolHelper.imInviteCreateTeam(gameInfo, gameTemplate, userInfo, targetUid, new ITeamCreateCallback(){

            @Override
            public void onTeamCreateSuccess(TeamInfo teamInfo, long teamHeartbeatTime) {
            }

            @Override
            public void onImInviteCreateSuccess(final TeamInfo teamInfo) {
                if (gameInfo == null) {
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameTeamInviteController.TAG, (String)"teamImInviteReq teamId=", (Object[])new Object[]{teamInfo.getTeamId()});
                }
                GameMessageModel gameMessageModel = new GameMessageModel();
                gameMessageModel.setGameId(gameInfo.getGid());
                gameMessageModel.setGameName(gameInfo.getGname());
                gameMessageModel.setType(0);
                gameMessageModel.setToUserId(targetUid);
                gameMessageModel.setTeamId(teamInfo.getTeamId());
                gameMessageModel.setGameTemplate(gameTemplate);
                gameMessageModel.setGameVersion(Integer.valueOf(gameInfo.getModulerVer()).intValue());
                gameMessageModel.setInviteType(2);
                UserInfoBean userInfoBean = ((IUserInfoService)GameTeamInviteController.this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null);
                if (userInfoBean != null) {
                    gameMessageModel.setFromUserName(userInfoBean.getNick());
                    gameMessageModel.setFromUserAvatar(userInfoBean.getAvatar());
                    gameMessageModel.setFromUserSex(userInfoBean.getSex());
                }
                YYTaskExecutor.execute(() -> {
                    ImMsgReqParam msgReqParam = ImDataFactory.INSTANCE.sendPkMsg(gameMessageModel);
                    if (msgReqParam != null) {
                        ((ImService)GameTeamInviteController.this.getServiceManager().getService(ImService.class)).getSendService().sendOldIMHttpMsg(msgReqParam, null);
                    }
                });
                AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent(AppsFlyerEvent.INVITE_GAME_NUM));
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onTeamGameImInviteSuccessRes(gameInfo.getGid(), teamInfo.getTeamId(), gameTemplate);
                        }
                    }
                });
            }

            @Override
            public void onTeamCreateFailed(final long code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onTeamGameImInviteFailRes(code, gameInfo.getGid());
                        }
                    }
                });
            }
        });
    }

    public void teamImCancelInviteReq(String gameId, String teamId, long targetUid, IIMTeamGameListener listener) {
        this.teamImCancelInviteReq(gameId, teamId, targetUid, true, listener);
    }

    public void teamImCancelInviteReq(String gameId, String teamId, long targetUid, boolean sendMsg, final IIMTeamGameListener listener) {
        TeamGameProtocolHelper.imCancelCreateTeam(teamId, targetUid, new ITeamImCancelCreateCallback(){

            @Override
            public void onTeamImCancelCreateSuccess(final String teamId, final long targetUid) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onTeamGameImCancelSuccessRes(teamId, targetUid);
                        }
                    }
                });
            }

            @Override
            public void onTeamImCancelCreateFailed(final long code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onTeamGameImCancelFailRes(code);
                        }
                    }
                });
            }
        });
        if (sendMsg) {
            GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
            if (gameInfo == null) {
                return;
            }
            GameMessageModel gameMessageModel = new GameMessageModel();
            gameMessageModel.setGameId(gameId);
            gameMessageModel.setGameName(gameInfo.getGname());
            gameMessageModel.setType(1);
            gameMessageModel.setToUserId(targetUid);
            gameMessageModel.setTeamId(teamId);
            gameMessageModel.setGameTemplate(gameInfo.getTeamTemplate());
            gameMessageModel.setGameVersion(Integer.valueOf(gameInfo.getModulerVer()).intValue());
            gameMessageModel.setInviteType(2);
            UserInfoBean userInfoBean = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null);
            if (userInfoBean != null) {
                gameMessageModel.setFromUserName(userInfoBean.getNick());
                gameMessageModel.setFromUserAvatar(userInfoBean.getAvatar());
                gameMessageModel.setFromUserSex(userInfoBean.getSex());
            }
            YYTaskExecutor.execute(() -> {
                ImMsgReqParam msgReqParam = ImDataFactory.INSTANCE.sendPkMsg(gameMessageModel);
                if (msgReqParam != null) {
                    ((ImService)this.getServiceManager().getService(ImService.class)).getSendService().sendOldIMHttpMsg(msgReqParam, null);
                }
            });
        }
    }

    public void teamImInviteAccept(final String gameId, int gameTemplate, String teamId, boolean accept, long inviteUid, final IIMTeamGameListener listener) {
        GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
        if (gameInfo == null) {
            return;
        }
        TeamGameProtocolHelper.teamImInviteAccept(teamId, accept, inviteUid, gameTemplate, StringUtils.parseLong((String)gameInfo.getModulerVer()), gameInfo, new ITeamImInviteAcceptCallback(){

            @Override
            public void onImInviteAcceptSuccess(final String teamId, long inviteUid, final boolean accept, final int teamTemplete) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameTeamInviteController.TAG, (String)"teamImInviteAccept onImInviteAcceptSuccess", (Object[])new Object[0]);
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onTeamGameImInviteAcceptRes(gameId, teamId, accept, teamTemplete);
                        }
                    }
                });
            }

            @Override
            public void onImInviteAcceptFailed(final String teamId, long inviteUid, final boolean accept, final long code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameTeamInviteController.TAG, (String)"teamImInviteAccept onImInviteAcceptFailed", (Object[])new Object[0]);
                        }
                        if (listener != null) {
                            listener.onTeamGameImInviteAcceptFailRes(gameId, teamId, accept, code);
                        }
                    }
                });
            }
        });
    }

    public void registerImTeamGameListener(IIMTeamGameListener listener) {
        if (this.mIMTeamGameListenerList == null) {
            this.mIMTeamGameListenerList = new ConcurrentLinkedQueue();
        }
        if (listener != null && !this.mIMTeamGameListenerList.contains(listener)) {
            this.mIMTeamGameListenerList.add(listener);
        }
    }

    public void unRegisterImTeamGameListener(IIMTeamGameListener listener) {
        if (this.mIMTeamGameListenerList != null) {
            this.mIMTeamGameListenerList.remove(listener);
        }
    }

    @Override
    public void onTeamImInviteAccept(String gameId, String teamId, int template, boolean isAccept) {
        if (this.mIMTeamGameListenerList != null) {
            for (IIMTeamGameListener listener : this.mIMTeamGameListenerList) {
                if (listener == null) continue;
                listener.onTeamGameImAcceptNotify(gameId, teamId, template, isAccept);
            }
        }
    }
}

