/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameinvite;

import android.os.Message;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.service.IUserInfoService;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameInviteToChannelService;

public class GameInviteToChannelController
extends DefaultController
implements IGameInviteToChannelService {
    private static final String TAG = "GameInviteToChannelController";
    private String mJoinTeamId;
    private String mJoinTeamChannelId;

    public GameInviteToChannelController(Environment env) {
        super(env);
    }

    public void sendGameInviteToChannel(String mRoomId, String gid, String cid, String name) {
        if (FP.empty((CharSequence)mRoomId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"sendGameInviteToChannel mRoomId is empty!!", (Object[])new Object[0]);
            }
            return;
        }
        GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gid);
        if (gameInfo == null || cid == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"sendGameInviteToChannel gameInfo is null: %s  cid is null: %s", (Object[])new Object[]{gameInfo == null, cid == null});
            }
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"sendGameInviteToChannel gid: %s cid: %s mRoomId: %s", (Object[])new Object[]{gid, cid, mRoomId});
        }
        GameMessageModel gameMessageModel = new GameMessageModel();
        gameMessageModel.setGameId(gid);
        gameMessageModel.setGameName(gameInfo.getGname());
        gameMessageModel.setType(0);
        gameMessageModel.setRoomId(cid);
        gameMessageModel.setTeamId(mRoomId);
        gameMessageModel.setGameTemplate(gameInfo.getTeamTemplate());
        gameMessageModel.setGameVersion(Integer.valueOf(gameInfo.getModulerVer()).intValue());
        gameMessageModel.setInviteType(2);
        UserInfoBean userInfoBean = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null);
        if (userInfoBean != null) {
            gameMessageModel.setFromUserName(userInfoBean.getNick());
            gameMessageModel.setFromUserAvatar(userInfoBean.getAvatar());
            gameMessageModel.setFromUserSex(userInfoBean.getSex());
        }
        ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannel(cid).getMsgService().sendOutsideGameInvite(gameMessageModel, cid, name);
    }

    public void checkNeedRecoveryChannel(String teamId) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"checkNeedRecoveryChannel teamId: %s mJoinChannelId: %s joinTeamId: %s", (Object[])new Object[]{teamId, this.mJoinTeamChannelId, this.mJoinTeamId});
        }
        if (FP.empty((CharSequence)teamId) || FP.empty((CharSequence)this.mJoinTeamChannelId) || FP.empty((CharSequence)this.mJoinTeamId)) {
            return;
        }
        if (StringUtils.equal((String)teamId, (String)this.mJoinTeamId)) {
            EnterParam enterParam = EnterParam.obtain((String)this.mJoinTeamChannelId, (int)29);
            Message message = Message.obtain();
            message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
            message.obj = enterParam;
            this.sendMessage(message);
            this.mJoinTeamId = null;
            this.mJoinTeamChannelId = null;
        }
    }

    public void updateEntryTeamGameData(String teamId, String channelId) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"updateEntryTeamGameData teamId: %s  channelId: %s", (Object[])new Object[]{teamId, channelId});
        }
        this.mJoinTeamId = teamId;
        this.mJoinTeamChannelId = channelId;
    }
}

