/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameinvite;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.game.utils.TimeUtils;
import com.yy.hiyo.game.base.GameProDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInviteData;
import com.yy.hiyo.game.base.bean.IndieGameInviteData;
import java.util.ArrayList;
import java.util.List;

public class GameInviteListManager {
    private static final String TAG = "GameInviteListManager";
    private static final int MSG_CHECK_TIMEOUT = 0;
    private Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    int remain = GameInviteListManager.this.checkTimeoutInvite();
                    if (remain <= 0) break;
                    GameInviteListManager.this.mHandler.removeMessages(0);
                    GameInviteListManager.this.mHandler.sendEmptyMessageDelayed(0, 1000L);
                    break;
                }
            }
        }
    };
    private IGameTimeoutListener mTimeoutListener;
    private List<GameInviteData> mInviteDataList = new ArrayList<GameInviteData>();

    public void setTimeoutListener(IGameTimeoutListener timeoutListener) {
        this.mTimeoutListener = timeoutListener;
    }

    public synchronized ArrayList<GameInviteData> getInviteList(long selfUid, long targetUid) {
        return this.getInviteList(selfUid, targetUid, 2);
    }

    public synchronized ArrayList<GameInviteData> getInviteList(long selfUid, long targetUid, int limisize) {
        ArrayList<GameInviteData> ret = new ArrayList<GameInviteData>();
        if (selfUid > 0L && targetUid > 0L) {
            for (int i = 0; i < this.mInviteDataList.size(); ++i) {
                GameInviteData data = this.mInviteDataList.get(i);
                if (data.mSelfUid != selfUid || data.mTargetUid != targetUid) continue;
                ret.add(data);
            }
        }
        return ret;
    }

    public synchronized void removeGameInvite(String pkId) {
        if (TextUtils.isEmpty((CharSequence)pkId)) {
            return;
        }
        for (int i = 0; i < this.mInviteDataList.size(); ++i) {
            GameInviteData data = this.mInviteDataList.get(i);
            if (!pkId.equals(data.mPkId)) continue;
            this.mInviteDataList.remove(data);
            break;
        }
    }

    public synchronized void addGameInvite(GameInfo gameInfo, long selfUid, long targetUid, String pkId, int state, long time, int gameTemplate, boolean isGoldGame, int gameTimeLimitType) {
        this.addGameInvite(gameInfo, selfUid, targetUid, pkId, state, time, gameTemplate, isGoldGame, "", GameProDef.IM_PK_REQ, gameTimeLimitType);
    }

    public synchronized void addGroupGameInvite(GameInfo gameInfo, long selfUid, String pkId, int state, long time, int gameTemplate, boolean isGoldGame, String groupId, int gameTimeLimitType) {
        this.addGameInvite(gameInfo, selfUid, 0L, pkId, state, time, gameTemplate, isGoldGame, groupId, GameProDef.GROUP_PK_REQ, gameTimeLimitType);
    }

    private synchronized void addGameInvite(GameInfo gameInfo, long selfUid, long targetUid, String pkId, int state, long time, int gameTemplate, boolean isGoldGame, String groupId, int fromType, int gameTimeLimitType) {
        if (gameInfo == null || TextUtils.isEmpty((CharSequence)pkId) || selfUid <= 0L || targetUid <= 0L && StringUtils.isEmpty((String)groupId)) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"addGameInvite pkId=%s, gameId=%s", (Object[])new Object[]{pkId, gameInfo.getGid()});
        }
        GameInviteData data = new GameInviteData(gameInfo, selfUid, targetUid, pkId, time, state, gameTemplate, fromType, groupId, gameTimeLimitType);
        data.isGoldGame = isGoldGame;
        this.mInviteDataList.add(data);
        this.mHandler.removeMessages(0);
        this.mHandler.sendEmptyMessageDelayed(0, 1000L);
    }

    public synchronized void addIndieGameInvite(GameInfo gameInfo, long selfUid, long targetUid, String pkId, int state, long time, int gameTemplate, boolean isGoldGame, String groupId, int fromType, String roomId, String infoPayload, int gameTimeLimitType) {
        if (gameInfo == null || TextUtils.isEmpty((CharSequence)pkId) || selfUid <= 0L || targetUid <= 0L && StringUtils.isEmpty((String)groupId)) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"addGameInvite roomId=%s, gameId=%s", (Object[])new Object[]{roomId, gameInfo.getGid()});
        }
        IndieGameInviteData data = new IndieGameInviteData(gameInfo, selfUid, targetUid, pkId, time, state, gameTemplate, fromType, groupId, gameTimeLimitType);
        data.isGoldGame = isGoldGame;
        data.setRoomId(roomId);
        data.setInfoPayload(infoPayload);
        this.mInviteDataList.add((GameInviteData)data);
        this.mHandler.removeMessages(0);
        this.mHandler.sendEmptyMessageDelayed(0, 1000L);
    }

    private synchronized int checkTimeoutInvite() {
        for (int i = this.mInviteDataList.size() - 1; i >= 0; --i) {
            GameInviteData removeData;
            GameInviteData data = this.mInviteDataList.get(i);
            if (data.mState == 2) {
                if ((int)(TimeUtils.getCurrentTime() - data.mInviteTime) / 1000 <= 30) continue;
                removeData = this.mInviteDataList.remove(i);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"checkTimeoutInvite STATE_RECEIVE_INVITE", (Object[])new Object[]{removeData.mPkId});
                }
                if (this.mTimeoutListener == null) continue;
                this.mTimeoutListener.gameInviteTimeout(removeData);
                continue;
            }
            if (data.mState != 1 || (int)(System.currentTimeMillis() - data.mInviteTime) / 1000 <= 30) continue;
            removeData = this.mInviteDataList.remove(i);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"checkTimeoutInvite STATE_SEND_INVITE", (Object[])new Object[]{removeData.mPkId});
            }
            if (this.mTimeoutListener == null) continue;
            this.mTimeoutListener.gameInviteTimeout(removeData);
        }
        return this.mInviteDataList.size();
    }

    public synchronized boolean isGameInviteExist(String pkId) {
        boolean ret = false;
        if (!TextUtils.isEmpty((CharSequence)pkId)) {
            for (int i = 0; i < this.mInviteDataList.size(); ++i) {
                if (!pkId.equals(this.mInviteDataList.get((int)i).mPkId)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static interface IGameTimeoutListener {
        public void gameInviteTimeout(GameInviteData var1);
    }
}

