/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.gameinvite;

import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Environment;
import com.yy.framework.core.MsgDispatcher;
import com.yy.game.gamemodule.teamgame.teammatch.ui.adapter.invite.InviteAdapter;
import com.yy.game.module.gameinvite.GameInviteListManager;
import com.yy.game.module.gameinvite.GameInviteToChannelController;
import com.yy.game.module.gameinvite.GameTeamInviteController;
import com.yy.game.module.gameinvite.MsgInviteController;
import com.yy.game.module.gameinvite.PkGameInviteController;
import com.yy.hiyo.game.base.GameProDef;
import com.yy.hiyo.game.base.IMGameCancelReqBean;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInviteData;
import com.yy.hiyo.game.base.helper.GameModeHelper;
import com.yy.hiyo.game.base.teamgame.ITeamInviteAdapter;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameInviteService;
import com.yy.hiyo.game.service.IGameInviteToChannelService;
import com.yy.hiyo.game.service.IGameTeamInviteService;
import com.yy.hiyo.game.service.IMsgInviteService;
import com.yy.hiyo.game.service.IPkGameInviteService;
import com.yy.hiyo.game.service.callback.IGameInviteTimeoutListener;
import com.yy.hiyo.game.service.callback.IIMGameInviteListener;
import com.yy.hiyo.game.service.callback.IIMPKGameListener;
import com.yy.hiyo.im.GameInviteTipsUtil;
import com.yy.hiyo.im.ImBaseMsgDef;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import okhttp3.Call;

public class GameInviteController
extends DefaultController
implements IGameInviteService,
GameInviteListManager.IGameTimeoutListener {
    private static final String TAG = "GameInviteController";
    private IPkGameInviteService pkGameInviteService;
    private IGameTeamInviteService gameTeamInviteService;
    private IMsgInviteService msgInviteService;
    private IGameInviteToChannelService mGameInviteToChannelService;
    private Environment mBaseEnv;
    private ConcurrentLinkedQueue<IIMGameInviteListener> mImGameInviteListeners = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<IGameInviteTimeoutListener> mGameInviteTimeoutListeners = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<IIMGameInviteListener.IGameInviteInvalidListener> mImGameInviteInvalidListeners = new ConcurrentLinkedQueue();
    private GameInviteListManager mGameInviteListManager;
    private String mPushPkId;

    public GameInviteController(Environment env) {
        super(env);
        this.mBaseEnv = env;
        this.pkGameInviteService = new PkGameInviteController(env);
        this.gameTeamInviteService = new GameTeamInviteController(env);
        this.mGameInviteListManager = new GameInviteListManager();
        this.mGameInviteListManager.setTimeoutListener(this);
    }

    public IPkGameInviteService getPkGameInviteService() {
        if (this.pkGameInviteService == null) {
            this.pkGameInviteService = new PkGameInviteController(this.mBaseEnv);
        }
        return this.pkGameInviteService;
    }

    public IGameTeamInviteService getGameTeamInviteService() {
        if (this.gameTeamInviteService == null) {
            this.gameTeamInviteService = new GameTeamInviteController(this.mBaseEnv);
        }
        return this.gameTeamInviteService;
    }

    public IMsgInviteService getMsgInviteService() {
        if (this.msgInviteService == null) {
            this.msgInviteService = new MsgInviteController(this.mBaseEnv);
        }
        return this.msgInviteService;
    }

    public IGameInviteToChannelService getGameInviteToChannelService() {
        if (this.mGameInviteToChannelService == null) {
            this.mGameInviteToChannelService = new GameInviteToChannelController(this.mBaseEnv);
        }
        return this.mGameInviteToChannelService;
    }

    public ITeamInviteAdapter createTeamInviteAdapter() {
        return new InviteAdapter();
    }

    public void receiveGameInviteMsg(GameMessageModel messageModel) {
        if (messageModel == null) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"addGameInvite pkId=%s, gameId=%s", (Object[])new Object[]{messageModel.getPkId(), messageModel.getGameId()});
        }
        if ((messageModel.getType() == 1 || messageModel.getType() == 2) && this.isGameInviteExist(messageModel.getPkId())) {
            this.removeGameInvite(messageModel.getPkId());
        }
        if (messageModel.getType() == 1) {
            this.showGameInviteTips(0, false, false, messageModel.getFromUserId(), messageModel.getGameId());
        }
        if (this.mImGameInviteListeners != null) {
            for (IIMGameInviteListener listener : this.mImGameInviteListeners) {
                listener.onGameInviteArrived(messageModel);
            }
        }
    }

    public void receiveGameInviteMsg(GameMessageModel messageModel, int state) {
        if (messageModel != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"addGameInvite pkId=%s, gameId=%s, gameTemplate=%s, state=%d, isGoldGame:%b", (Object[])new Object[]{messageModel.getPkId(), messageModel.getGameId(), messageModel.getGameTemplate(), state, messageModel.isGoldGame()});
            }
            if (messageModel.getType() == 0 && this.getServiceManager().getService(IGameInfoService.class) != null) {
                GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(messageModel.getGameId());
                if (messageModel.getFrom() != 1) {
                    if (messageModel.getGameTimeLimitType() == 2) {
                        this.mGameInviteListManager.addIndieGameInvite(gameInfo, AccountUtil.getUid(), messageModel.getFromUserId(), messageModel.getPkId(), state, messageModel.getServerTime(), messageModel.getGameTemplate(), messageModel.isGoldGame(), "", GameProDef.IM_PK_REQ, messageModel.getRoomId(), messageModel.getInfoPayload(), messageModel.getGameTimeLimitType());
                    } else {
                        this.mGameInviteListManager.addGameInvite(gameInfo, AccountUtil.getUid(), messageModel.getFromUserId(), messageModel.getPkId(), state, messageModel.getServerTime(), messageModel.getGameTemplate(), messageModel.isGoldGame(), messageModel.getGameTimeLimitType());
                    }
                }
            }
            if (this.mImGameInviteListeners != null) {
                for (IIMGameInviteListener listener : this.mImGameInviteListeners) {
                    listener.onGameInviteArrived(messageModel);
                }
            }
        }
    }

    public void receiveGroupGameInviteMsg() {
    }

    public void addGameInvite(GameInfo gameInfo, long selfUid, long targetUid, String pkId, int state, long time, int gameTemplate, boolean isGoldGame) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"addGameInvite selfUid=%d, targetUid=%d, pkId=%s", (Object[])new Object[]{selfUid, targetUid, pkId});
        }
        this.mGameInviteListManager.addGameInvite(gameInfo, selfUid, targetUid, pkId, state, time, gameTemplate, isGoldGame, 1);
    }

    public void addGroupGameInvite(GameInfo gameInfo, long selfUid, String groupId, String pkId, int state, long time) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"addGameInvite selfUid=%d, targetUid=%d, pkId=%s", (Object[])new Object[]{selfUid, pkId});
        }
        this.mGameInviteListManager.addGroupGameInvite(gameInfo, selfUid, pkId, state, time, 0, false, groupId, 1);
    }

    public void removeGameInvite(String pkId) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"removeGameInvite pkId=%s", (Object[])new Object[]{pkId});
        }
        this.mGameInviteListManager.removeGameInvite(pkId);
    }

    public ArrayList<GameInviteData> getInviteList(long selfUid, long targetUid) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getInviteList selfUid=%d, targetUid=%d", (Object[])new Object[]{selfUid, targetUid});
        }
        return this.mGameInviteListManager.getInviteList(selfUid, targetUid);
    }

    public boolean isGameInviteExist(String pkId) {
        boolean isExist = this.mGameInviteListManager.isGameInviteExist(pkId);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"isGameInviteExist pkId=%s, isExist=%s", (Object[])new Object[]{pkId, isExist});
        }
        return isExist;
    }

    public void cancelPkInvite(String pkId, long targetUid, @NonNull String gameId, @Nullable IIMPKGameListener listener) {
        if (this.isGameInviteExist(pkId)) {
            IMGameCancelReqBean cancelReq = IMGameCancelReqBean.newBuilder().pkId(pkId).target_uid(targetUid).build();
            this.getPkGameInviteService().pkGameCancelReq(cancelReq, gameId, listener);
        }
    }

    public void cancelSendInvite(long targetUid) {
        ArrayList inviteList;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"cancelSendInvite targetUid=%d", (Object[])new Object[]{targetUid});
        }
        if ((inviteList = (ArrayList)((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getInviteList(AccountUtil.getUid(), targetUid)).size() == 0) {
            return;
        }
        for (GameInviteData data : inviteList) {
            if (data.mState != 1) continue;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"cancelSendGameInvite gameId=%s, pkId=%s", (Object[])new Object[]{data.mGameInfo.getGid(), data.mPkId});
            }
            if (((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).isGameInviteExist(data.mPkId)) {
                ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).removeGameInvite(data.mPkId);
            }
            this.cancelSendGameInvite(data);
        }
    }

    public void registerGameInviteListener(IIMGameInviteListener listener) {
        if (listener != null && !this.mImGameInviteListeners.contains(listener)) {
            this.mImGameInviteListeners.add(listener);
        }
    }

    public void unRegisterGameInviteListener(IIMGameInviteListener listener) {
        if (listener != null) {
            this.mImGameInviteListeners.remove(listener);
        }
    }

    public void registerGameInviteTimeoutListener(IGameInviteTimeoutListener listener) {
        if (listener != null && !this.mGameInviteTimeoutListeners.contains(listener)) {
            this.mGameInviteTimeoutListeners.add(listener);
        }
    }

    public void unRegisterGameInviteTimeoutListener(IGameInviteTimeoutListener listener) {
        if (listener != null) {
            this.mGameInviteTimeoutListeners.remove(listener);
        }
    }

    public void receiveGameInvalidMsg(long uid, String gameId, String pkId) {
        if (this.mImGameInviteInvalidListeners != null) {
            for (IIMGameInviteListener.IGameInviteInvalidListener listener : this.mImGameInviteInvalidListeners) {
                listener.onGameInviteInvalid(uid, gameId, pkId);
            }
        }
    }

    public void receiveIncompatibleMsg() {
        if (this.mImGameInviteListeners != null) {
            for (IIMGameInviteListener listener : this.mImGameInviteListeners) {
                listener.onGameInviteIncompatibled();
            }
        }
    }

    public void setPushPkId(String pkId) {
        this.mPushPkId = pkId;
    }

    public String getPushPkId() {
        return this.mPushPkId;
    }

    public void registerGameInviteInvalidListener(IIMGameInviteListener.IGameInviteInvalidListener listener) {
        if (listener != null && !this.mImGameInviteInvalidListeners.contains(listener)) {
            this.mImGameInviteInvalidListeners.add(listener);
        }
    }

    public void unRegisterGameInviteInvalidListener(IIMGameInviteListener.IGameInviteInvalidListener listener) {
        if (listener != null) {
            this.mImGameInviteInvalidListeners.remove(listener);
        }
    }

    @Override
    public void gameInviteTimeout(GameInviteData data) {
        if (data != null) {
            for (IGameInviteTimeoutListener listener : this.mGameInviteTimeoutListeners) {
                listener.onGameInviteTimeout(data);
            }
            if (data.mState == 2 && data.fromType == GameProDef.IM_PK_REQ) {
                data.mGameInfo.setPrecipitationSource(3);
                this.showGameInviteTips(1, true, true, data.mTargetUid, data.mGameInfo.getGid());
            }
        }
    }

    private void cancelSendGameInvite(GameInviteData data) {
        if (this.getServiceManager().getService(IGameInviteService.class) != null) {
            if (GameModeHelper.isTeamMode((GameInfo)data.mGameInfo)) {
                ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getGameTeamInviteService().teamImCancelInviteReq(data.mGameInfo.getGid(), data.mPkId, data.mTargetUid, null);
            } else {
                IMGameCancelReqBean cancelReq = IMGameCancelReqBean.newBuilder().pkId(data.mPkId).target_uid(data.mTargetUid).build();
                ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getPkGameInviteService().pkGameCancelReq(cancelReq, data.mGameInfo.getGid(), null);
            }
        }
    }

    public void showGameInviteTips(final int operate, final boolean isSelf, final boolean isTimeout, long targetUid, String gameId) {
        IGameInfoService iGameInfoService = (IGameInfoService)this.getServiceManager().getService(IGameInfoService.class);
        if (iGameInfoService == null) {
            return;
        }
        final GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
        if (gameInfo == null) {
            return;
        }
        IUserInfoService iUserInfoService = (IUserInfoService)this.getServiceManager().getService(IUserInfoService.class);
        if (iUserInfoService == null) {
            return;
        }
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(targetUid, new OnProfileListCallback(){

            public void onUISuccess(List<UserInfoBean> list) {
                if (list != null && list.size() > 0) {
                    UserInfoBean userInfo = list.get(0);
                    if (userInfo == null) {
                        return;
                    }
                    String tips = GameInviteTipsUtil.getTips((int)operate, (boolean)isSelf, (boolean)isTimeout, (String)"", (String)userInfo.getNick(), (String)gameInfo.getGname());
                    if (!isTimeout && (isSelf && operate == 0 || isSelf && operate == 1)) {
                        return;
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameInviteController.TAG, (String)"showGameInviteTips operate=%d", (Object[])new Object[]{operate});
                    }
                    GameMessageModel messageModel = new GameMessageModel();
                    messageModel.setToUserId(userInfo.getUid());
                    messageModel.setToUserName(userInfo.getNick());
                    messageModel.setGameId(gameInfo.gid);
                    messageModel.setGameName(gameInfo.getGname());
                    messageModel.setFrom(isSelf ? 0 : 1);
                    messageModel.setType(operate);
                    messageModel.setContent(tips);
                    Message msg = Message.obtain();
                    msg.what = ImBaseMsgDef.IM_SEND_LOCAL_GAME_INVITE;
                    if (isTimeout) {
                        msg.arg2 = 3;
                    } else if (operate == 0) {
                        msg.arg2 = 2;
                    }
                    msg.obj = messageModel;
                    MsgDispatcher.getInstance().sendMessage(msg);
                }
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }
}

