/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.audiorecord;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.core.DefaultController;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.game.module.appcallgamemodle.AppNotifyGameRouter;
import com.yy.game.module.audiorecord.IGameAudioRecord;
import com.yy.hiyo.game.base.module.appcallgamemodle.AppNotifyGameDefine;
import com.yy.hiyo.game.base.module.jscallappmodule.IComGameCallAppCallBack;
import com.yy.hiyo.record.base.AudioDownloadInfo;
import com.yy.hiyo.record.base.AudioPlayInfo;
import com.yy.hiyo.record.base.AudioRecordInfo;
import com.yy.hiyo.record.base.AudioUploadInfo;
import com.yy.hiyo.record.base.IRecordService;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class GameAudioRecordController
extends DefaultController
implements IGameAudioRecord {
    private static final String TAG = "GameAudioRecordController";
    private IQueueTaskExecutor mQueueTaskExecutor;
    private AudioRecordInfo mRecordInfo;
    private AudioPlayInfo mPlayInfo;
    private final ConcurrentHashMap<String, AudioUploadInfo> mUploads;
    private final ConcurrentHashMap<String, AudioDownloadInfo> mDownloads;
    AppNotifyGameRouter mAppNotifyGameRouter;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public GameAudioRecordController(Environment env, AppNotifyGameRouter notifyGameRouter) {
        super(env);
        this.mQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
        this.mUploads = new ConcurrentHashMap();
        this.mDownloads = new ConcurrentHashMap();
        this.mAppNotifyGameRouter = notifyGameRouter;
    }

    public void destroy() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"destory", (Object[])new Object[0]);
        }
        this.mBinder.clearAllKvoConnections();
    }

    @Override
    public String startRecord(String reqJson, IComGameCallAppCallBack callback2) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"startRecord reqJson\uff1a %s", (Object[])new Object[]{reqJson});
        }
        this.execut(() -> {
            JSONObject jsonObject = this.parseJson(reqJson);
            String business = "gameId";
            String subBusiness = "roomId";
            int maxDuration = -1;
            if (jsonObject != null) {
                business = jsonObject.optString("gameId");
                subBusiness = jsonObject.optString("roomId");
                maxDuration = jsonObject.optInt("maxDuration");
            }
            if (this.mRecordInfo != null) {
                this.mBinder.clearKvoConnection(AudioRecordInfo.class.getName());
            }
            this.mRecordInfo = ((IRecordService)this.getServiceManager().getService(IRecordService.class)).startRecord(business, subBusiness, maxDuration);
            if (this.mRecordInfo != null) {
                this.mBinder.singleBindSourceTo((KvoSource)this.mRecordInfo);
                callback2.callGame((Object)this.formatJson("localId", this.mRecordInfo.getLocalId()));
            }
        });
        return "";
    }

    @Override
    public void cancelRecord(String reqJson) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"cancelRecord reqJson\uff1a %s, mRecordInfo: %s", (Object[])new Object[]{reqJson, this.mRecordInfo});
        }
        if (this.mRecordInfo == null) {
            return;
        }
        this.execut(() -> {
            if (this.mRecordInfo == null) {
                return;
            }
            JSONObject jsonObject = this.parseJson(reqJson);
            if (jsonObject != null) {
                String localId = jsonObject.optString("localId");
                if (!TextUtils.isEmpty((CharSequence)localId) && localId.equals(this.mRecordInfo.getLocalId())) {
                    ((IRecordService)this.getServiceManager().getService(IRecordService.class)).cancelRecord(this.mRecordInfo);
                } else if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"cancelRecord reqJson\uff1a %s, mRecordInfo.getLocalId: %s", (Object[])new Object[]{reqJson, this.mRecordInfo.getLocalId()});
                }
            }
        });
    }

    @Override
    public void stopRecord(String reqJson) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"stopRecord reqJson\uff1a %s, mRecordInfo: %s", (Object[])new Object[]{reqJson, this.mRecordInfo});
        }
        if (this.mRecordInfo == null) {
            return;
        }
        this.execut(() -> {
            if (this.mRecordInfo == null) {
                return;
            }
            JSONObject jsonObject = this.parseJson(reqJson);
            if (jsonObject != null) {
                String localId = jsonObject.optString("localId");
                boolean isUpload = jsonObject.optBoolean("isUpload");
                if (!TextUtils.isEmpty((CharSequence)localId) && localId.equals(this.mRecordInfo.getLocalId())) {
                    ((IRecordService)this.getServiceManager().getService(IRecordService.class)).stopRecord(this.mRecordInfo, isUpload);
                } else if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"cancelRecord reqJson\uff1a %s, mRecordInfo.getLocalId: %s", (Object[])new Object[]{reqJson, this.mRecordInfo.getLocalId()});
                }
            }
        });
    }

    @Override
    public void uploadRecord(final String reqJson) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"uploadRecord reqJson\uff1a %s", (Object[])new Object[]{reqJson});
        }
        if (TextUtils.isEmpty((CharSequence)reqJson)) {
            this.onUpLoadStatus("", 0, "errorCode", -1, "reason", "param of reqJson is empty");
            return;
        }
        this.execut(new Runnable(){

            @Override
            public void run() {
                JSONObject jsonObject = GameAudioRecordController.this.parseJson(reqJson);
                if (jsonObject != null) {
                    String localId = jsonObject.optString("localId");
                    if (TextUtils.isEmpty((CharSequence)localId)) {
                        GameAudioRecordController.this.onUpLoadStatus("", 0, new Object[]{"errorCode", -1, "reason", "param of reqJson is illegal"});
                        return;
                    }
                    AudioUploadInfo info = ((IRecordService)GameAudioRecordController.this.getServiceManager().getService(IRecordService.class)).uploadRecord(localId);
                    GameAudioRecordController.this.addUpload(localId, info);
                } else {
                    GameAudioRecordController.this.onUpLoadStatus("", 0, new Object[]{"errorCode", -1, "reason", "param of reqJson is illegal"});
                }
            }
        });
    }

    @Override
    public void playRecord(final String reqJson) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"playRecord reqJson\uff1a %s", (Object[])new Object[]{reqJson});
        }
        if (TextUtils.isEmpty((CharSequence)reqJson)) {
            return;
        }
        this.execut(new Runnable(){

            @Override
            public void run() {
                JSONObject jsonObject = GameAudioRecordController.this.parseJson(reqJson);
                if (jsonObject != null) {
                    String recordId = jsonObject.optString("recordId");
                    if (GameAudioRecordController.this.mPlayInfo != null) {
                        GameAudioRecordController.this.mBinder.clearKvoConnection(AudioPlayInfo.class.getName());
                    }
                    GameAudioRecordController.this.mPlayInfo = ((IRecordService)GameAudioRecordController.this.getServiceManager().getService(IRecordService.class)).playRecord(recordId);
                    GameAudioRecordController.this.mBinder.singleBindSourceTo((KvoSource)GameAudioRecordController.this.mPlayInfo);
                }
            }
        });
    }

    @Override
    public void pausePlayRecord(final String reqJson) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"pausePlayRecord reqJson\uff1a %s", (Object[])new Object[]{reqJson});
        }
        if (TextUtils.isEmpty((CharSequence)reqJson)) {
            return;
        }
        final AudioPlayInfo info = this.mPlayInfo;
        if (info == null) {
            return;
        }
        this.execut(new Runnable(){

            @Override
            public void run() {
                String recordId;
                JSONObject jsonObject = GameAudioRecordController.this.parseJson(reqJson);
                if (jsonObject != null && (recordId = jsonObject.optString("recordId")).equals(info.getRecordId())) {
                    ((IRecordService)GameAudioRecordController.this.getServiceManager().getService(IRecordService.class)).pausePlayRecord(info);
                }
            }
        });
    }

    @Override
    public void resumePlayRecord(final String reqJson) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"resumePlayRecord reqJson\uff1a %s", (Object[])new Object[]{reqJson});
        }
        if (TextUtils.isEmpty((CharSequence)reqJson)) {
            return;
        }
        final AudioPlayInfo info = this.mPlayInfo;
        if (info == null) {
            return;
        }
        this.execut(new Runnable(){

            @Override
            public void run() {
                String recordId;
                JSONObject jsonObject = GameAudioRecordController.this.parseJson(reqJson);
                if (jsonObject != null && (recordId = jsonObject.optString("recordId")).equals(info.getRecordId())) {
                    ((IRecordService)GameAudioRecordController.this.getServiceManager().getService(IRecordService.class)).resumePlayRecord(info);
                }
            }
        });
    }

    @Override
    public void stopPlayRecord(final String reqJson) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"stopPlayRecord reqJson\uff1a %s", (Object[])new Object[]{reqJson});
        }
        if (TextUtils.isEmpty((CharSequence)reqJson)) {
            return;
        }
        final AudioPlayInfo info = this.mPlayInfo;
        if (info == null) {
            return;
        }
        this.execut(new Runnable(){

            @Override
            public void run() {
                String recordId;
                JSONObject jsonObject = GameAudioRecordController.this.parseJson(reqJson);
                if (jsonObject != null && (recordId = jsonObject.optString("recordId")).equals(info.getRecordId())) {
                    ((IRecordService)GameAudioRecordController.this.getServiceManager().getService(IRecordService.class)).stopPlayRecord(info);
                }
            }
        });
    }

    @Override
    public void downloadRecord(String reqJson) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"downloadRecord reqJson\uff1a %s", (Object[])new Object[]{reqJson});
        }
        if (TextUtils.isEmpty((CharSequence)reqJson)) {
            return;
        }
        this.execut(() -> {
            JSONObject jsonObject = this.parseJson(reqJson);
            if (jsonObject != null) {
                String url = jsonObject.optString("recordUrl");
                AudioDownloadInfo info = ((IRecordService)this.getServiceManager().getService(IRecordService.class)).downloadRecord(url);
                this.addDownload(url, info);
            }
        });
    }

    @Override
    public void cancelDownloadRecord(String reqJson) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"cancelDownloadRecord reqJson\uff1a %s", (Object[])new Object[]{reqJson});
        }
        if (TextUtils.isEmpty((CharSequence)reqJson)) {
            return;
        }
        this.execut(() -> {
            String url;
            AudioDownloadInfo info;
            JSONObject jsonObject = this.parseJson(reqJson);
            if (jsonObject != null && (info = this.mDownloads.get(url = jsonObject.optString("recordUrl"))) != null) {
                ((IRecordService)this.getServiceManager().getService(IRecordService.class)).cancelDownloadRecord(info);
            }
        });
    }

    private void onRecordStatus(final String localId, final int code, final Object ... result) {
        this.execut(new Runnable(){

            @Override
            public void run() {
                JSONObject resultStr = GameAudioRecordController.this.formatJsonObject(result);
                String res = GameAudioRecordController.this.formatJson(new Object[]{"localId", localId, "code", code, "result", resultStr});
                GameAudioRecordController.this.mAppNotifyGameRouter.notifyGameWithOutRegister(res, AppNotifyGameDefine.OnRecordStatusChangeNotify);
            }
        });
    }

    private void onDownloadStatus(final String recordUrl, final int code, final Object ... result) {
        this.execut(new Runnable(){

            @Override
            public void run() {
                JSONObject resultStr = GameAudioRecordController.this.formatJsonObject(result);
                String res = GameAudioRecordController.this.formatJson(new Object[]{"recordUrl", recordUrl, "code", code, "result", resultStr});
                GameAudioRecordController.this.mAppNotifyGameRouter.notifyGameWithOutRegister(res, AppNotifyGameDefine.OnDownLoadStatusChangeNotify);
            }
        });
    }

    private void onUpLoadStatus(final String localId, final int code, final Object ... result) {
        this.execut(new Runnable(){

            @Override
            public void run() {
                JSONObject resultStr = GameAudioRecordController.this.formatJsonObject(result);
                String res = GameAudioRecordController.this.formatJson(new Object[]{"localId", localId, "code", code, "result", resultStr});
                GameAudioRecordController.this.mAppNotifyGameRouter.notifyGameWithOutRegister(res, AppNotifyGameDefine.OnUpLoadStatusChangeNotify);
            }
        });
    }

    private void onPlayRecordStatus(String recordId, int code, Object ... result) {
        this.execut(() -> {
            JSONObject resultStr = this.formatJsonObject(result);
            String res = this.formatJson("recordId", recordId, "code", code, "result", resultStr);
            this.mAppNotifyGameRouter.notifyGameWithOutRegister(res, AppNotifyGameDefine.OnPlayRecordStatusChangeNotify);
        });
    }

    @KvoMethodAnnotation(sourceClass=AudioRecordInfo.class, name="state", thread=2)
    public void onAudioRecordStateChanged(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        AudioRecordInfo.State state = (AudioRecordInfo.State)event.newValue();
        AudioRecordInfo info = (AudioRecordInfo)event.source();
        if (state == AudioRecordInfo.State.ERROR || state == AudioRecordInfo.State.CANCEL) {
            if (info.error != null) {
                this.onRecordStatus(info.getLocalId(), 0, "errorCode", info.error.errorCode, "reason", info.error.errorInfo);
            }
            this.mBinder.clearKvoConnection(AudioRecordInfo.class.getName());
        } else if (state == AudioRecordInfo.State.COMPLETE) {
            this.onRecordStatus(info.getLocalId(), 1, "totalTime", info.getTotalTime());
            if (!info.isUpload) {
                this.mBinder.clearKvoConnection(AudioRecordInfo.class.getName());
            }
        } else if (state == AudioRecordInfo.State.UPLOAD_FAILED || state == AudioRecordInfo.State.UPLOAD_SUCCESS) {
            this.mBinder.clearKvoConnection(AudioRecordInfo.class.getName());
        }
    }

    @KvoMethodAnnotation(sourceClass=AudioRecordInfo.class, name="time", thread=2)
    public void onAudioRecordProgress(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        AudioRecordInfo info = (AudioRecordInfo)event.source();
        AudioRecordInfo.State state = info.getState();
        if (state == AudioRecordInfo.State.START) {
            this.onRecordStatus(info.getLocalId(), 100, "time", info.getTime(), "decibel", info.getDecibel());
        }
    }

    @KvoMethodAnnotation(sourceClass=AudioRecordInfo.class, name="uploadInfo", thread=2)
    public void onAudioRecordUpload(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        AudioUploadInfo uploadInfo = (AudioUploadInfo)event.newValue();
        if (uploadInfo != null) {
            this.addUpload(uploadInfo.getLocalId(), uploadInfo);
        }
    }

    @KvoMethodAnnotation(name="state", sourceClass=AudioUploadInfo.class, thread=2)
    public void onAudioUploadStateChanged(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        AudioUploadInfo info = (AudioUploadInfo)event.source();
        AudioUploadInfo.State state = (AudioUploadInfo.State)event.newValue();
        if (state == AudioUploadInfo.State.FAILED) {
            if (!this.removeUpload(info.getLocalId())) {
                this.mBinder.clearKvoConnection(info.getLocalId() + "_upload");
            }
            this.onUpLoadStatus(info.getLocalId(), 0, "errorCode", info.error.errorCode, "reason", info.error.errorInfo);
        } else if (state == AudioUploadInfo.State.CANCEL) {
            if (!this.removeUpload(info.getLocalId())) {
                this.mBinder.clearKvoConnection(info.getLocalId() + "_upload");
            }
        } else if (state == AudioUploadInfo.State.COMPLETE) {
            if (!this.removeUpload(info.getLocalId())) {
                this.mBinder.clearKvoConnection(info.getLocalId() + "_upload");
            }
            this.onUpLoadStatus(info.getLocalId(), 1, "totalSize", info.getTotalSize(), "recordUrl", info.getUrl());
        }
    }

    @KvoMethodAnnotation(name="currentSize", sourceClass=AudioUploadInfo.class, thread=2)
    public void onAudioUploadProgress(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        AudioUploadInfo info = (AudioUploadInfo)event.source();
        this.onUpLoadStatus(info.getLocalId(), 100, "totalSize", info.getTotalSize(), "currentSize", info.getCurrentSize());
    }

    @KvoMethodAnnotation(name="state", sourceClass=AudioPlayInfo.class, thread=2)
    public void onAudioPlayStateChanged(KvoEventIntent event) {
        AudioPlayInfo.State state = (AudioPlayInfo.State)event.newValue();
        AudioPlayInfo info = (AudioPlayInfo)event.source();
        if (state == AudioPlayInfo.State.ERROR) {
            if (info.error != null) {
                this.onPlayRecordStatus(info.getRecordId(), 0, "errorCode", info.error.errorCode, "reason", info.error.errorInfo);
            }
        } else if (state == AudioPlayInfo.State.START) {
            this.onPlayRecordStatus(info.getRecordId(), 1, "totalTime", info.getTotalTime());
        } else if (state == AudioPlayInfo.State.COMPLETE) {
            this.onPlayRecordStatus(info.getRecordId(), 2, "totalTime", info.getTotalTime());
        } else if (state == AudioPlayInfo.State.DOWNLOAD_FAILED) {
            this.onPlayRecordStatus(info.getRecordId(), 0, "errorCode", info.error.errorCode, "reason", info.error.errorInfo);
        }
    }

    @KvoMethodAnnotation(name="time", sourceClass=AudioPlayInfo.class, thread=2)
    public void onAudioPlayProgress(KvoEventIntent event) {
        AudioPlayInfo info = (AudioPlayInfo)event.source();
        AudioPlayInfo.State state = info.getState();
        if (state == AudioPlayInfo.State.START) {
            this.onPlayRecordStatus(info.getRecordId(), 100, "totalTime", info.getTotalTime(), "currentTime", info.getTime());
        }
    }

    @KvoMethodAnnotation(name="state", sourceClass=AudioDownloadInfo.class)
    public void onAudioDownloadStateChanged(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        AudioDownloadInfo.State state = (AudioDownloadInfo.State)event.newValue();
        AudioDownloadInfo info = (AudioDownloadInfo)event.source();
        String url = info.getUrl();
        if (state == AudioDownloadInfo.State.FAILED) {
            this.removeDownload(url);
            if (info.error != null) {
                this.onDownloadStatus(url, 0, "errorCode", info.error.errorCode, "reason", info.error.errorInfo);
            }
        } else if (state == AudioDownloadInfo.State.CANCEL) {
            this.removeDownload(url);
        } else if (state == AudioDownloadInfo.State.COMPLETE) {
            this.removeDownload(url);
            this.onDownloadStatus(info.getUrl(), 1, "totalSize", info.getTotalSize());
        }
    }

    @KvoMethodAnnotation(name="currentSize", sourceClass=AudioDownloadInfo.class, thread=2)
    public void onAudioDownloadProgress(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        AudioDownloadInfo info = (AudioDownloadInfo)event.source();
        this.onDownloadStatus(info.getUrl(), 100, "totalSize", info.getTotalSize(), "currentSize", info.getCurrentSize());
    }

    private void addUpload(String localId, AudioUploadInfo info) {
        if (!TextUtils.isEmpty((CharSequence)localId) && info != null) {
            this.mBinder.singleBindSourceTo(localId + "_upload", (KvoSource)info);
            this.mUploads.put(localId, info);
        }
    }

    private boolean removeUpload(String localId) {
        AudioUploadInfo info;
        if (!TextUtils.isEmpty((CharSequence)localId) && (info = this.mUploads.remove(localId)) != null) {
            this.mBinder.clearKvoConnection(localId + "_upload");
            return true;
        }
        return false;
    }

    private void addDownload(String url, AudioDownloadInfo info) {
        if (!TextUtils.isEmpty((CharSequence)url) && info != null) {
            this.mBinder.singleBindSourceTo(url + "_download", (KvoSource)info);
            this.mDownloads.put(url, info);
        }
    }

    private boolean removeDownload(String url) {
        AudioDownloadInfo info;
        if (!TextUtils.isEmpty((CharSequence)url) && (info = this.mDownloads.remove(url)) != null) {
            this.mBinder.clearKvoConnection(url + "_download");
            return true;
        }
        return false;
    }

    private void execut(Runnable task) {
        if (task == null) {
            return;
        }
        this.mQueueTaskExecutor.execute(task, 0L);
    }

    private String formatJson(Object ... params) {
        if (params == null || params.length == 0) {
            return "{}";
        }
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("format json params is illegal");
        }
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject();
            for (int i = 0; i < params.length - 1; i += 2) {
                jsonObject.put(String.valueOf(params[i]), params[i + 1]);
            }
            return jsonObject.toString();
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (String)"formatJson", (Throwable)e, (Object[])new Object[0]);
            return "{}";
        }
    }

    private JSONObject formatJsonObject(Object ... params) {
        if (params == null || params.length == 0) {
            return null;
        }
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("format json params is illegal");
        }
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject();
            for (int i = 0; i < params.length - 1; i += 2) {
                jsonObject.put(String.valueOf(params[i]), params[i + 1]);
            }
            return jsonObject;
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (String)"formatJson", (Throwable)e, (Object[])new Object[0]);
            return null;
        }
    }

    @Nullable
    private JSONObject parseJson(String json) {
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)json);
            return jsonObject;
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (String)"parseJson ", (Throwable)e, (Object[])new Object[0]);
            return null;
        }
    }

    private static interface IGameAudioRecordCallback {
        public AppNotifyGameRouter getNotifyGameRouter();
    }
}

