/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.module.Filter;

import com.yy.game.utils.WeakReferenceListHelper;
import com.yy.hiyo.game.base.FilterRunnable;
import com.yy.hiyo.game.base.gamemode.IGameFliterInterface;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.CopyOnWriteArrayList;

public class GameJoinFilter {
    private CopyOnWriteArrayList<WeakReference<IGameFliterInterface>> iGameFilterList = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<WeakReference<IGameFliterInterface>> iMatchFilterList = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<WeakReference<IGameFliterInterface>> iTeamMatchFilterList = new CopyOnWriteArrayList();

    public boolean filter(int type, FilterRunnable runnable2) {
        CopyOnWriteArrayList<WeakReference<IGameFliterInterface>> filterList = null;
        if (this.isGameType(type)) {
            filterList = new CopyOnWriteArrayList<WeakReference<IGameFliterInterface>>(this.iGameFilterList);
        } else if (this.isMatchType(type)) {
            filterList = new CopyOnWriteArrayList<WeakReference<IGameFliterInterface>>(this.iMatchFilterList);
        } else if (this.isTeamMatchType(type)) {
            filterList = new CopyOnWriteArrayList<WeakReference<IGameFliterInterface>>(this.iTeamMatchFilterList);
        }
        if (filterList == null) {
            return false;
        }
        IGameFliterInterface iWeakReference = null;
        QueueRunnable queueRunnable = new QueueRunnable(runnable2, filterList);
        for (WeakReference<IGameFliterInterface> weakReference : filterList) {
            iWeakReference = (IGameFliterInterface)weakReference.get();
            if (iWeakReference == null) continue;
            queueRunnable.filter(weakReference);
            if (!iWeakReference.filter((FilterRunnable)queueRunnable)) continue;
            return true;
        }
        return false;
    }

    public void addFilter(int type, IGameFliterInterface gameFliterInterface) {
        if (this.isMatchType(type)) {
            this.addFilterInner(this.iMatchFilterList, gameFliterInterface);
        }
        if (this.isGameType(type)) {
            this.addFilterInner(this.iGameFilterList, gameFliterInterface);
        }
        if (this.isTeamMatchType(type)) {
            this.addFilterInner(this.iTeamMatchFilterList, gameFliterInterface);
        }
    }

    private void addFilterInner(CopyOnWriteArrayList<WeakReference<IGameFliterInterface>> listInner, IGameFliterInterface gameFliterInterface) {
        if (listInner != null && gameFliterInterface != null) {
            WeakReferenceListHelper.addWeakListUniqObject(listInner, gameFliterInterface);
            GameJoinFilter.sortIntMethod(listInner);
        }
    }

    public void removeFilter(int type, IGameFliterInterface gameFliterInterface) {
        if (this.isMatchType(type)) {
            WeakReferenceListHelper.removeWeakListObject(this.iMatchFilterList, gameFliterInterface);
        }
        if (this.isGameType(type)) {
            WeakReferenceListHelper.removeWeakListObject(this.iGameFilterList, gameFliterInterface);
        }
        if (this.isTeamMatchType(type)) {
            WeakReferenceListHelper.removeWeakListObject(this.iTeamMatchFilterList, gameFliterInterface);
        }
    }

    private static void sortIntMethod(CopyOnWriteArrayList<WeakReference<IGameFliterInterface>> list) {
        ArrayList<WeakReference<IGameFliterInterface>> listInner = new ArrayList<WeakReference<IGameFliterInterface>>(list);
        Collections.sort(listInner, new MyComparator());
        list.clear();
        list.addAll(listInner);
    }

    private boolean isMatchType(int type) {
        return (8 & type) > 0;
    }

    private boolean isGameType(int type) {
        return (4 & type) > 0;
    }

    private boolean isTeamMatchType(int type) {
        return (0x10 & type) > 0;
    }

    private static class MyComparator
    implements Comparator<WeakReference<IGameFliterInterface>> {
        private MyComparator() {
        }

        @Override
        public int compare(WeakReference<IGameFliterInterface> o1, WeakReference<IGameFliterInterface> o2) {
            if (o1 == null || o2 == null) {
                return -1;
            }
            IGameFliterInterface weakReferenceObj1 = (IGameFliterInterface)o1.get();
            IGameFliterInterface weakReferenceObj2 = (IGameFliterInterface)o2.get();
            if (weakReferenceObj1 == null) {
                return 0;
            }
            if (weakReferenceObj2 == null) {
                return 1;
            }
            if (weakReferenceObj1.getFilterPriority() > weakReferenceObj2.getFilterPriority()) {
                return 1;
            }
            if (weakReferenceObj1.getFilterPriority() == weakReferenceObj2.getFilterPriority()) {
                return 0;
            }
            return -1;
        }
    }

    class QueueRunnable
    extends FilterRunnable {
        FilterRunnable mGameRunnable;
        private CopyOnWriteArrayList<WeakReference<IGameFliterInterface>> queueList;

        public QueueRunnable(FilterRunnable filterRunnable, CopyOnWriteArrayList<WeakReference<IGameFliterInterface>> filteList) {
            super(filterRunnable.gameInfo, filterRunnable.gameContext);
            this.queueList = new CopyOnWriteArrayList();
            this.mGameRunnable = filterRunnable;
            this.queueList.addAll(filteList);
        }

        public void run() {
            IGameFliterInterface iWeakReference = null;
            QueueRunnable queueRunnable = new QueueRunnable(this.mGameRunnable, this.queueList);
            for (WeakReference<IGameFliterInterface> weakReference : this.queueList) {
                iWeakReference = (IGameFliterInterface)weakReference.get();
                if (iWeakReference == null) continue;
                queueRunnable.filter(weakReference);
                if (!iWeakReference.filter((FilterRunnable)queueRunnable)) continue;
                return;
            }
            this.mGameRunnable.run();
        }

        void filter(WeakReference<IGameFliterInterface> weakReference) {
            this.queueList.remove(weakReference);
        }
    }
}

