/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.growth;

import android.os.Message;
import com.yy.appbase.abtest.ABConfig;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.growth.AbsExperiment;
import com.yy.appbase.growth.AbsExperimentCreator;
import com.yy.appbase.growth.ExperimentParam;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.growth.IExperimentCallBack;
import com.yy.appbase.localprecent.LocalPercent;
import com.yy.appbase.unifyconfig.config.GrowthBusinessConfig;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.Notification;
import com.yy.game.bean.EmojiBean;
import com.yy.game.growth.GameResultAiData;
import com.yy.game.growth.GameResultAiExperiment;
import com.yy.game.growth.GameSendAction;
import com.yy.game.msg.GameMsgDef;
import com.yy.hiyo.annotations.GrowthExperimentCreator;
import com.yy.hiyo.game.GameBaseMsgDef;
import com.yy.hiyo.game.base.bean.GameDef;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/yy/game/growth/GameResultAiExperiment;", "Lcom/yy/appbase/growth/AbsExperiment;", "()V", "mCallBackRef", "Ljava/lang/ref/WeakReference;", "Lcom/yy/appbase/growth/IExperimentCallBack;", "mHasNotified", "", "mRandom", "Ljava/util/Random;", "kotlin.jvm.PlatformType", "handleResult", "", "config", "Lcom/yy/appbase/unifyconfig/config/GrowthBusinessConfig;", "gameResult", "Lcom/yy/hiyo/game/base/bean/GameDef$GameResult;", "myScore", "", "otherScore", "handleSendEmoji", "emojiId", "wantGiveLike", "onMessage", "msg", "Landroid/os/Message;", "onMessageSync", "", "onNotify", "notification", "Lcom/yy/framework/core/Notification;", "GameResultAiExperimentCreator", "game_debug"})
public final class GameResultAiExperiment
extends AbsExperiment {
    private Random mRandom = LocalPercent.getRandom();
    private boolean mHasNotified;
    private WeakReference<IExperimentCallBack> mCallBackRef;

    public void onNotify(@NotNull Notification notification) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
    }

    public void onMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (msg.what == GrowthMsgDef.GAME_RESULT_AI_SCORE) {
            ExperimentParam param;
            Object object = msg.obj;
            if (!(object instanceof ExperimentParam)) {
                object = null;
            }
            ExperimentParam experimentParam = param = (ExperimentParam)object;
            Object object2 = experimentParam != null ? experimentParam.getData() : null;
            if (!(object2 instanceof GameResultAiData)) {
                object2 = null;
            }
            GameResultAiData gameResultAiData = (GameResultAiData)object2;
            if (gameResultAiData == null) {
                return;
            }
            GameResultAiData data = gameResultAiData;
            MLog.debug((Object)"GameResultAiPresenter", (String)("notifyResult targetUid: " + data.getTargetUid() + ", gameResult: " + data.getGameResult().name() + ", " + "myScore:" + data.getMyScore() + ", otherScore: " + data.getOtherScore()), (Object[])new Object[0]);
            if (SystemUtils.isAI((long)data.getTargetUid())) {
                if (this.mHasNotified) {
                    return;
                }
                this.mHasNotified = true;
                IExperimentCallBack iExperimentCallBack = param.getCallback();
                if (iExperimentCallBack != null) {
                    IExperimentCallBack iExperimentCallBack2 = iExperimentCallBack;
                    boolean bl = false;
                    boolean bl2 = false;
                    IExperimentCallBack it = iExperimentCallBack2;
                    boolean bl3 = false;
                    this.mCallBackRef = new WeakReference<IExperimentCallBack>(it);
                }
                GrowthBusinessConfig config = this.getConfigOrDefault();
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, config, data){
                    final /* synthetic */ GameResultAiExperiment this$0;
                    final /* synthetic */ GrowthBusinessConfig $config;
                    final /* synthetic */ GameResultAiData $data;

                    public final void run() {
                        GameResultAiExperiment.access$handleResult(this.this$0, this.$config, this.$data.getGameResult(), this.$data.getMyScore(), this.$data.getOtherScore());
                    }
                    {
                        this.this$0 = gameResultAiExperiment;
                        this.$config = growthBusinessConfig;
                        this.$data = gameResultAiData;
                    }
                }, (long)config.getData().getAiGameResult().getResultDelay());
            }
        } else if (msg.what == GameMsgDef.GAME_PK_FINISH) {
            this.mHasNotified = false;
        }
    }

    @Nullable
    public Object onMessageSync(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        return null;
    }

    private final void handleResult(GrowthBusinessConfig config, GameDef.GameResult gameResult, int myScore, int otherScore) {
        MLog.debug((Object)"GameResultAiPresenter", (String)("handleResult gameResult: " + gameResult.name() + ", myScore: " + myScore + ", " + "otherScore: " + otherScore), (Object[])new Object[0]);
        boolean wantGiveLike = false;
        boolean hasGiveLike = false;
        int emojiId = 0;
        if (gameResult == GameDef.GameResult.GAME_WIN) {
            if (myScore != otherScore) {
                emojiId = this.mRandom.nextInt(2) + 2;
                wantGiveLike = true;
            } else {
                emojiId = 0;
                wantGiveLike = true;
            }
        } else if (gameResult == GameDef.GameResult.GAME_LOSE) {
            emojiId = 1;
            wantGiveLike = false;
        } else {
            emojiId = 0;
            wantGiveLike = true;
        }
        hasGiveLike = this.handleSendEmoji(config, emojiId, wantGiveLike);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023779").put("function_id", "ai_show").put("receive_emoji", String.valueOf(emojiId + 1)).put("current_score", "" + myScore + '-' + otherScore).put("is_ai_lose", gameResult == GameDef.GameResult.GAME_WIN ? "1" : "0").put("is_receive_like", hasGiveLike ? "1" : "0"));
    }

    private final boolean handleSendEmoji(GrowthBusinessConfig config, int emojiId, boolean wantGiveLike) {
        Function3<Integer, Integer, EmojiBean, Unit> $fun$onForeachSend$1 = new Function3<Integer, Integer, EmojiBean, Unit>(this){
            final /* synthetic */ GameResultAiExperiment this$0;

            public final void invoke(int index, int count, @NotNull EmojiBean emojiBean) {
                Intrinsics.checkParameterIsNotNull((Object)emojiBean, (String)"emojiBean");
                if (index >= count) {
                    return;
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, emojiBean, index, count){
                    final /* synthetic */ handleSendEmoji.1 this$0;
                    final /* synthetic */ EmojiBean $emojiBean;
                    final /* synthetic */ int $index;
                    final /* synthetic */ int $count;

                    public final void run() {
                        WeakReference weakReference = GameResultAiExperiment.access$getMCallBackRef$p(this.this$0.this$0);
                        if (weakReference != null && (weakReference = (IExperimentCallBack)weakReference.get()) != null) {
                            weakReference.onNotify(new GameSendAction(false, this.$emojiBean, 1));
                        }
                        this.this$0.invoke(this.$index + 1, this.$count, this.$emojiBean);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$emojiBean = emojiBean;
                        this.$index = n;
                        this.$count = n2;
                    }
                }, (long)200L);
            }
            {
                this.this$0 = gameResultAiExperiment;
                super(3);
            }
        };
        MLog.debug((Object)"GameResultAiPresenter", (String)("sendEmoji id: " + emojiId), (Object[])new Object[0]);
        try {
            List section = StringsKt.split$default((CharSequence)config.getData().getAiGameResult().getEmojiSeries(), (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null);
            if (section.size() == 2) {
                int end;
                String string2 = (String)section.get(0);
                boolean bl = false;
                int start = Integer.parseInt(string2);
                String string3 = (String)section.get(1);
                boolean bl2 = false;
                int n = start;
                if (1 <= n && (end = Integer.parseInt(string3)) > n) {
                    int random = this.mRandom.nextInt(end - start + 1) + start;
                    MLog.debug((Object)"GameResultAiPresenter", (String)("\u8fde\u7eed\u53d1\u9001\u8868\u60c5\u6b21\u6570\uff1a " + random), (Object[])new Object[0]);
                    EmojiBean emojiBean = EmojiBean.newBuilder().id(emojiId).build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)emojiBean, (String)"EmojiBean.newBuilder().id(emojiId).build()");
                    $fun$onForeachSend$1.invoke(0, random, emojiBean);
                }
            } else {
                EmojiBean emojiBean = EmojiBean.newBuilder().id(emojiId).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)emojiBean, (String)"EmojiBean.newBuilder().id(emojiId).build()");
                $fun$onForeachSend$1.invoke(0, 1, emojiBean);
            }
        }
        catch (Exception ex) {
            MLog.error((Object)"GameResultAiPresenter", (String)"sendEmoji error", (Throwable)ex, (Object[])new Object[0]);
        }
        boolean hasGiveLike = false;
        if (wantGiveLike) {
            int likeRandom = this.mRandom.nextInt(100);
            MLog.debug((Object)"GameResultAiPresenter", (String)("\u5b9e\u9645\u6982\u7387\uff1a " + likeRandom + ", \u76ee\u6807\u6982\u7387\uff1a " + config.getData().getAiGameResult().getLikeProbability()), (Object[])new Object[0]);
            if (likeRandom < config.getData().getAiGameResult().getLikeProbability()) {
                hasGiveLike = true;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                    final /* synthetic */ GameResultAiExperiment this$0;

                    public final void run() {
                        block0: {
                            WeakReference weakReference = GameResultAiExperiment.access$getMCallBackRef$p(this.this$0);
                            if (weakReference == null || (weakReference = (IExperimentCallBack)weakReference.get()) == null) break block0;
                            weakReference.onNotify(new GameSendAction(true, null, 0));
                        }
                    }
                    {
                        this.this$0 = gameResultAiExperiment;
                    }
                }, (long)config.getData().getAiGameResult().getLikeDelay());
            }
        } else {
            MLog.debug((Object)"GameResultAiPresenter", (String)"\u4e0d\u9700\u8981\u70b9\u8d5e", (Object[])new Object[0]);
        }
        return hasGiveLike;
    }

    public static final /* synthetic */ void access$handleResult(GameResultAiExperiment $this, GrowthBusinessConfig config, GameDef.GameResult gameResult, int myScore, int otherScore) {
        $this.handleResult(config, gameResult, myScore, otherScore);
    }

    public static final /* synthetic */ WeakReference access$getMCallBackRef$p(GameResultAiExperiment $this) {
        return $this.mCallBackRef;
    }

    public static final /* synthetic */ void access$setMCallBackRef$p(GameResultAiExperiment $this, WeakReference weakReference) {
        $this.mCallBackRef = weakReference;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0014J\u0010\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0014J \u0010\f\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0018\u00010\rH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/yy/game/growth/GameResultAiExperiment$GameResultAiExperimentCreator;", "Lcom/yy/appbase/growth/AbsExperimentCreator;", "()V", "createExperiment", "Lcom/yy/appbase/growth/AbsExperiment;", "isAppSupport", "", "precondition", "subscribeMessage", "", "", "subscribeNotification", "targetABGroup", "Lkotlin/Pair;", "Lcom/yy/appbase/abtest/ABConfig;", "", "", "game_debug"})
    @GrowthExperimentCreator(msgIds={"com.yy.hiyo.game.GameBaseMsgDef.GAME_PK_FINISH", "com.yy.appbase.growth.GrowthMsgDef.GAME_RESULT_AI_SCORE"}, notificationIds={})
    public static final class GameResultAiExperimentCreator
    extends AbsExperimentCreator {
        @NotNull
        protected AbsExperiment createExperiment() {
            return new GameResultAiExperiment();
        }

        protected boolean precondition() {
            return AccountUtil.getUid() > 0L;
        }

        @Nullable
        protected Pair<ABConfig<?>, String[]> targetABGroup() {
            return new Pair((Object)NewABDefine.GAME_RESULT_AI_TEST, (Object)new String[]{"A"});
        }

        @Nullable
        protected List<Integer> subscribeNotification() {
            return null;
        }

        @Nullable
        protected List<Integer> subscribeMessage() {
            return CollectionsKt.listOf((Object[])new Integer[]{GameBaseMsgDef.GAME_PK_FINISH, GrowthMsgDef.GAME_RESULT_AI_SCORE});
        }

        protected boolean isAppSupport() {
            return true;
        }
    }
}

