/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamerecom.ui.v2.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.animation.LinearInterpolator;
import androidx.annotation.Nullable;
import com.yy.base.memoryrecycle.views.YYView;

public abstract class AbstractLoadingView
extends YYView {
    public ValueAnimator valueAnimator;

    public AbstractLoadingView(Context context) {
        this(context, null);
    }

    public AbstractLoadingView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AbstractLoadingView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPaint();
    }

    public void startAnim() {
        this.stopAnim();
        this.startViewAnim(0.0f, 1.0f, 500L);
    }

    public void startAnim(int time) {
        this.stopAnim();
        this.startViewAnim(0.0f, 1.0f, time);
    }

    public void stopAnim() {
        if (this.valueAnimator != null) {
            this.clearAnimation();
            this.valueAnimator.setRepeatCount(0);
            this.valueAnimator.cancel();
            this.valueAnimator.end();
            if (this.onStopAnim() == 0) {
                this.valueAnimator.setRepeatCount(0);
                this.valueAnimator.cancel();
                this.valueAnimator.end();
            }
        }
    }

    private ValueAnimator startViewAnim(float startF, float endF, long time) {
        this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{startF, endF});
        this.valueAnimator.setDuration(time);
        this.valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.valueAnimator.setRepeatCount(this.setAnimRepeatCount());
        if (1 == this.setAnimRepeatMode()) {
            this.valueAnimator.setRepeatMode(1);
        } else if (2 == this.setAnimRepeatMode()) {
            this.valueAnimator.setRepeatMode(2);
        }
        this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                AbstractLoadingView.this.onAnimationUpdate(valueAnimator);
            }
        });
        this.valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
            }

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
            }

            public void onAnimationRepeat(Animator animation) {
                super.onAnimationRepeat(animation);
                AbstractLoadingView.this.onAnimationRepeat(animation);
            }
        });
        if (!this.valueAnimator.isRunning()) {
            this.ainmIsRunning();
            this.valueAnimator.start();
        }
        return this.valueAnimator;
    }

    protected abstract void initPaint();

    protected abstract void onAnimationUpdate(ValueAnimator var1);

    protected abstract void onAnimationRepeat(Animator var1);

    protected abstract int onStopAnim();

    protected abstract int setAnimRepeatMode();

    protected abstract int setAnimRepeatCount();

    protected abstract void ainmIsRunning();
}

