/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamerecom.ui.v1;

import android.view.View;
import android.widget.ProgressBar;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.util.RepeatClickUtils;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.game.R;
import com.yy.game.gamerecom.IClickGameCallback;
import com.yy.game.gamerecom.RecomGameStatic;
import com.yy.game.gamerecom.bean.RecomGame;
import com.yy.game.gamerecom.domain.SaveGameRecordUseCase;
import com.yy.game.gamerecom.ui.AnimationUtil;
import com.yy.game.gamerecom.ui.v1.DialogHolder;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.callback.ILeaveGameCallback;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\b\u0010\u001f\u001a\u00020\u001aH\u0002R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/yy/game/gamerecom/ui/v1/DialogHolder;", "Lcom/yy/appbase/ui/adapter/BaseItemBinder$ViewHolder;", "Lcom/yy/game/gamerecom/bean/RecomGame;", "view", "Landroid/view/View;", "callback", "Lcom/yy/game/gamerecom/IClickGameCallback;", "(Landroid/view/View;Lcom/yy/game/gamerecom/IClickGameCallback;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "getCallback", "()Lcom/yy/game/gamerecom/IClickGameCallback;", "gameItem", "icon", "Lcom/yy/base/imageloader/view/RecycleImageView;", "mBinder", "Lcom/yy/base/event/kvo/helper/KvoBinder;", "pb", "Landroid/widget/ProgressBar;", "playBtn", "Lcom/yy/base/memoryrecycle/views/YYTextView;", "tvLoading", "tvTips", "destroy", "", "onUpdateProgress", "event", "Lcom/yy/base/event/kvo/KvoEventIntent;", "onUpdateState", "startPlayGame", "game_debug"})
public final class DialogHolder
extends BaseItemBinder.ViewHolder<RecomGame> {
    @NotNull
    private final String TAG = "Holder";
    private RecycleImageView icon;
    private YYTextView tvTips;
    private ProgressBar pb;
    private YYTextView tvLoading;
    private YYTextView playBtn;
    private RecomGame gameItem;
    private final KvoBinder mBinder;
    @NotNull
    private final IClickGameCallback callback;

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    private final void startPlayGame() {
        if (!RepeatClickUtils.canRepeatClick((String)"DialogHolder")) {
            return;
        }
        RecomGame recomGame = this.gameItem;
        GameInfo gameInfoByGid = ((IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class)).getGameInfoByGid(recomGame != null ? recomGame.getGid() : null);
        if (gameInfoByGid == null) {
            RecomGame recomGame2 = this.gameItem;
            MLog.error((Object)this.TAG, (String)("game info null!!gid:" + (recomGame2 != null ? recomGame2.getGid() : null)), (Object[])new Object[0]);
            return;
        }
        boolean gameValid = ((IGameService)ServiceManagerProxy.getService(IGameService.class)).isGameValid(gameInfoByGid);
        this.callback.onClickGame(gameInfoByGid, gameValid, "2");
        if (gameValid) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)this.TAG, (String)("game valid, gid:" + gameInfoByGid.gid), (Object[])new Object[0]);
            }
            ((IGameCenterService)ServiceManagerProxy.getService(IGameCenterService.class)).leaveCurrentGame(new ILeaveGameCallback(gameInfoByGid){
                final /* synthetic */ GameInfo $gameInfoByGid;

                public final void onGameLeaved(GameInfo $noName_0, GamePlayContext $noName_1) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                        final /* synthetic */ startPlayGame.1 this$0;

                        public final void run() {
                            String string2 = this.this$0.$gameInfoByGid.gid;
                            if (string2 == null) {
                                string2 = "";
                            }
                            RecomGameStatic.Companion.succOpenGame("2", string2);
                            GameContextDef.JoinFrom joinFrom = GameContextDef.JoinFrom.FROM_GAME;
                            joinFrom.setGameFrom(GameContextDef.GameFrom.GAME_INNER_JONI);
                            ((IGameCenterService)ServiceManagerProxy.getService(IGameCenterService.class)).startJoinGameFlow(this.this$0.$gameInfoByGid, joinFrom);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.$gameInfoByGid = gameInfo;
                }
            });
        } else {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)this.TAG, (String)("game not valid, gid:" + gameInfoByGid.gid), (Object[])new Object[0]);
            }
            IGameService iGameService = (IGameService)ServiceManagerProxy.getService(IGameService.class);
            if (iGameService != null) {
                iGameService.deleteDownloadAndRest(gameInfoByGid);
            }
            this.mBinder.singleBindSourceTo((KvoSource)gameInfoByGid.downloadInfo);
            ((IGameService)ServiceManagerProxy.getService(IGameService.class)).downloadGame(gameInfoByGid, GameDownloadInfo.DownloadType.no_pause, 150);
        }
        String string2 = gameInfoByGid.gid;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"gameInfoByGid.gid");
        SaveGameRecordUseCase.INSTANCE.saveRecord(string2, true);
    }

    @KvoMethodAnnotation(name="progress", sourceClass=GameDownloadInfo.class, thread=1)
    public final void onUpdateProgress(@NotNull KvoEventIntent event) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            KvoSource kvoSource = event.source();
            Intrinsics.checkExpressionValueIsNotNull((Object)kvoSource, (String)"event.source<GameDownloadInfo>()");
            GameDownloadInfo info = (GameDownloadInfo)kvoSource;
            ProgressBar progressBar = this.pb;
            if (progressBar != null) {
                progressBar.setMax((int)info.getTotalBytes());
            }
            ProgressBar progressBar2 = this.pb;
            if (progressBar2 == null) break block1;
            progressBar2.setProgress((int)info.getProgress());
        }
    }

    @KvoMethodAnnotation(name="state", sourceClass=GameDownloadInfo.class, thread=1)
    public final void onUpdateState(@NotNull KvoEventIntent event) {
        block8: {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                KvoSource kvoSource = event.source();
                Intrinsics.checkExpressionValueIsNotNull((Object)kvoSource, (String)"event.source<GameDownloadInfo>()");
                GameDownloadInfo info = (GameDownloadInfo)kvoSource;
                if (info.getState() != GameDownloadInfo.DownloadState.download_finish) break block7;
                YYTextView yYTextView = this.tvLoading;
                if (yYTextView != null) {
                    yYTextView.setVisibility(8);
                }
                ProgressBar progressBar = this.pb;
                if (progressBar != null) {
                    progressBar.setVisibility(8);
                }
                YYTextView yYTextView2 = this.playBtn;
                if (yYTextView2 != null) {
                    yYTextView2.setVisibility(0);
                }
                AnimationUtil.Companion.applyScaleAnim((View)this.playBtn);
                this.startPlayGame();
                Object object = this.gameItem;
                if (object == null || (object = ((RecomGame)object).getGid()) == null) {
                    object = "";
                }
                RecomGame recomGame = this.gameItem;
                RecomGameStatic.Companion.gameDownloadFinish("2", (String)object, String.valueOf(recomGame != null ? Integer.valueOf(recomGame.getLocation()) : null));
                break block8;
            }
            YYTextView yYTextView = this.tvLoading;
            if (yYTextView != null) {
                yYTextView.setVisibility(0);
            }
            ProgressBar progressBar = this.pb;
            if (progressBar != null) {
                progressBar.setVisibility(0);
            }
            YYTextView yYTextView3 = this.playBtn;
            if (yYTextView3 != null) {
                yYTextView3.setVisibility(8);
            }
            YYTextView yYTextView4 = this.playBtn;
            if (yYTextView4 == null) break block8;
            yYTextView4.clearAnimation();
        }
    }

    public final void destroy() {
        block0: {
            this.mBinder.clearAllKvoConnections();
            YYTextView yYTextView = this.playBtn;
            if (yYTextView == null) break block0;
            yYTextView.clearAnimation();
        }
    }

    @NotNull
    public final IClickGameCallback getCallback() {
        return this.callback;
    }

    public DialogHolder(@NotNull View view, @NotNull IClickGameCallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
        super(view);
        this.callback = callback2;
        this.TAG = "Holder";
        this.icon = (RecycleImageView)view.findViewById(R.id.iv_game);
        this.tvTips = (YYTextView)view.findViewById(R.id.tv_tips);
        this.pb = (ProgressBar)view.findViewById(R.id.pb_loading);
        this.tvLoading = (YYTextView)view.findViewById(R.id.tv_loading);
        YYTextView yYTextView = this.playBtn = (YYTextView)view.findViewById(R.id.tv_play);
        if (yYTextView != null) {
            yYTextView.setOnClickListener(new View.OnClickListener(){

                public final void onClick(View it) {
                    this.startPlayGame();
                }
            });
        }
        this.mBinder = new KvoBinder((Object)this);
    }
}

