/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gameproxy.gameutilservice;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.google.gson.JsonObject;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.GameSaveDataDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.dowload.DownloadBussinessGroup;
import com.yy.appbase.service.IDBService;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.game.gameproxy.GameProxyDef;
import com.yy.game.gameproxy.LuaGameController;
import com.yy.game.porxy.IGameMsgInterface;
import com.yy.game.porxy.proxy.ILuaGameUtilService;
import downloader.Downloader;
import downloader.IDownloadCallback;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

@Deprecated
public class LuaGameUtilController
extends LuaGameController
implements ILuaGameUtilService {
    private static final String TAG = "LuaGameUtilController";

    public LuaGameUtilController(Environment env, IGameMsgInterface iGameMessageInterface) {
        super(env, iGameMessageInterface);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS, (INotify)this);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS) {
            // empty if block
        }
    }

    @Override
    public void gameSaveDataToLocal(final String context, final String key, final String jsonData) {
        if (StringUtils.isEmpty((String)key)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"gameSaveDataToLocal fail,key is empty", (Object[])new Object[0]);
            }
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AccountUtil.getUid() <= 0L) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)LuaGameUtilController.TAG, (String)"gameSaveDataToLocal fail,user not login,context:%s, key:%s, value:%s", (Object[])new Object[]{context, key, jsonData});
                    }
                    LuaGameUtilController.this.appSaveLocalDataCallback(context, key, false);
                    return;
                }
                IDBService dbService2 = (IDBService)LuaGameUtilController.this.getServiceManager().getService(IDBService.class);
                if (dbService2 == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)LuaGameUtilController.TAG, (String)"gameSaveDataToLocal fail,db null,context:%s, key:%s, value:%s", (Object[])new Object[]{context, key, jsonData});
                    }
                    LuaGameUtilController.this.appSaveLocalDataCallback(context, key, false);
                    return;
                }
                MyBox myBox = dbService2.boxForCurUser(GameSaveDataDBBean.class);
                if (myBox == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)LuaGameUtilController.TAG, (String)"gameSaveDataToLocal fail,mybox null,context:%s, key:%s, value:%s", (Object[])new Object[]{context, key, jsonData});
                    }
                    LuaGameUtilController.this.appSaveLocalDataCallback(context, key, false);
                    return;
                }
                GameSaveDataDBBean bean = new GameSaveDataDBBean();
                bean.setContext(context);
                bean.setKey(key);
                bean.setTs(System.currentTimeMillis());
                bean.setValue(jsonData);
                myBox.addItem((BaseDBBean)bean);
                LuaGameUtilController.this.appSaveLocalDataCallback(context, key, true);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)LuaGameUtilController.TAG, (String)"gameSaveDataToLocal context:%s, key:%s, data:%s", (Object[])new Object[]{context, key, jsonData});
                }
            }
        });
    }

    @Override
    public void gameLoadDataFromLocal(final String context, final String key) {
        if (StringUtils.isEmpty((String)key)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"gameSaveDataToLocal fail,key is empty", (Object[])new Object[0]);
            }
            this.appLoadDataCallback(context, key, "", false);
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AccountUtil.getUid() <= 0L) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)LuaGameUtilController.TAG, (String)"gameLoadDataFromLocal fail,user not login,context:%s, key:%s", (Object[])new Object[]{context, key});
                    }
                    LuaGameUtilController.this.appLoadDataCallback(context, key, "", false);
                    return;
                }
                IDBService dbService2 = (IDBService)LuaGameUtilController.this.getServiceManager().getService(IDBService.class);
                if (dbService2 == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)LuaGameUtilController.TAG, (String)"gameLoadDataFromLocal fail,db null,context:%s, key:%s, value:%s", (Object[])new Object[]{context, key});
                    }
                    LuaGameUtilController.this.appLoadDataCallback(context, key, "", false);
                    return;
                }
                MyBox myBox = dbService2.boxForCurUser(GameSaveDataDBBean.class);
                if (myBox == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)LuaGameUtilController.TAG, (String)"gameLoadDataFromLocal fail,mybox null,context:%s, key:%s, value:%s", (Object[])new Object[]{context, key});
                    }
                    return;
                }
                myBox.getAll(new MyBox.IGetItemsCallBack(){

                    public void onLoaded(ArrayList datas) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)LuaGameUtilController.TAG, (String)("datas:" + datas), (Object[])new Object[0]);
                        }
                        if (datas != null && !datas.isEmpty()) {
                            ArrayList list = datas;
                            for (GameSaveDataDBBean data : list) {
                                if (data == null || !key.equals(data.getKey())) continue;
                                LuaGameUtilController.this.appLoadDataCallback(context, key, JsonParser.toJson((Object)data), true);
                                return;
                            }
                        }
                        LuaGameUtilController.this.appLoadDataCallback(context, key, "", false);
                    }
                });
            }
        });
    }

    @Override
    public void gameDownloadFile(final String context, final String fileUrl, final String toFilePath, int priority) {
        if (StringUtils.isEmpty((String)fileUrl) || StringUtils.isEmpty((String)toFilePath)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"gameDownloadFile err,context:%s, fileUrl:%s, toFilePath:%s", (Object[])new Object[]{context, fileUrl, toFilePath});
            }
            this.appDownloadFileCallback(context, fileUrl, toFilePath, false);
            return;
        }
        int namePreIndex = toFilePath.lastIndexOf("/");
        if (namePreIndex < 0) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"toFilePath not valid,path:%s", (Object[])new Object[]{toFilePath});
            }
            this.appDownloadFileCallback(context, fileUrl, toFilePath, false);
            return;
        }
        String dir = toFilePath.substring(0, namePreIndex + 1);
        String fileName = toFilePath.substring(namePreIndex + 1);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"gameDownloadFile, context:%s, url:%s, toFilePath:%s", (Object[])new Object[]{context, fileUrl, toFilePath});
        }
        Downloader.Builder builder = new Downloader.Builder(fileUrl, dir, fileName);
        builder.setSupportContinueTransfer(true);
        builder.setTaskGroup(DownloadBussinessGroup.GAME_FILE);
        builder.setPriority(priority);
        builder.setCallBack(new IDownloadCallback(){

            public void onComplete(Downloader downloader) {
                LuaGameUtilController.this.appDownloadFileCallback(context, fileUrl, toFilePath, true);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)LuaGameUtilController.TAG, (String)"gameDownloadFile complete, context:%s, url:%s, toFilePath:%s", (Object[])new Object[]{context, fileUrl, toFilePath});
                }
            }

            public void onError(Downloader downloader, int errorType, String errorInfo) {
                LuaGameUtilController.this.appDownloadFileCallback(context, fileUrl, toFilePath, false);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)LuaGameUtilController.TAG, (String)"gameDownloadFile, url:%s, errorType:%d, errorInfo:%s", (Object[])new Object[]{fileUrl, errorType, errorInfo});
                }
            }

            public void onProgressChange(Downloader downloader, long totalSize, long curSize) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)LuaGameUtilController.TAG, (String)"gameDownloadFile, onProgressChange: totalSize:%d, curSize:%s", (Object[])new Object[]{totalSize, curSize});
                }
                LuaGameUtilController.this.appDownloadFileProgressCallback(context, fileUrl, toFilePath, curSize, totalSize);
            }

            public void onStart(Downloader downloader) {
            }
        });
        builder.build().start();
    }

    @Override
    public void getImageData(final String context, final String imageUrl, int scaleWidth, int scaleHeight) {
        if (TextUtils.isEmpty((CharSequence)imageUrl)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"getImageData fail,img url is empty", (Object[])new Object[0]);
            }
            return;
        }
        ImageLoader.loadBitmap((Context)this.mContext, (String)(imageUrl + YYImageUtils.getThumbnailPostfixPx((int)scaleWidth, (int)scaleHeight, (boolean)false)), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onLoadFailed(Exception e) {
                MLog.error((Object)LuaGameUtilController.TAG, (String)"getImageData failed :%s", (Throwable)e, (Object[])new Object[0]);
                LuaGameUtilController.this.appGetImageDataCallback(context, imageUrl, null);
            }

            public void onResourceReady(final Bitmap bitmap) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (bitmap == null || bitmap.isRecycled()) {
                            LuaGameUtilController.this.appGetImageDataCallback(context, imageUrl, null);
                        } else {
                            byte[] bitmapArr = LuaGameUtilController.this.bitmapToArr(bitmap);
                            if (bitmapArr == null) {
                                LuaGameUtilController.this.appGetImageDataCallback(context, imageUrl, null);
                            } else {
                                LuaGameUtilController.this.appGetImageDataCallback(context, imageUrl, bitmapArr);
                            }
                        }
                    }
                });
            }
        });
    }

    private Bitmap comp(Bitmap image, int scaleWidth, int scaleHeight) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        if (baos.toByteArray().length / 1024 > 1024) {
            baos.reset();
            image.compress(Bitmap.CompressFormat.PNG, 50, (OutputStream)baos);
        }
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        float hh = scaleHeight;
        float ww = scaleWidth;
        int be = 1;
        if (w > h && (float)w > ww) {
            be = (int)((float)newOpts.outWidth / ww);
        } else if (w < h && (float)h > hh) {
            be = (int)((float)newOpts.outHeight / hh);
        }
        if (be <= 0) {
            be = 1;
        }
        newOpts.inSampleSize = be;
        isBm = new ByteArrayInputStream(baos.toByteArray());
        bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, (BitmapFactory.Options)newOpts);
        return bitmap;
    }

    private String getBitmapKey(String url, int w, int h) {
        return url + "||" + w + "*" + h;
    }

    private String getBitmapUrlFromKey(String key) {
        String url = "";
        if (StringUtils.isEmpty((String)key)) {
            return url;
        }
        int index = key.lastIndexOf("||");
        if (index > 0) {
            url = key.substring(0, index);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] bitmapToArr(Bitmap bitmap) {
        block17: {
            ByteArrayOutputStream baos;
            block16: {
                baos = null;
                if (bitmap == null) break block16;
                baos = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
                baos.flush();
                baos.close();
                byte[] byArray = baos.toByteArray();
                try {
                    if (baos != null) {
                        baos.flush();
                        baos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    MLog.error((Object)TAG, (String)"bitmapToArr finally err:%s", (Object[])new Object[]{e.getMessage()});
                }
                return byArray;
            }
            try {
                if (baos != null) {
                    baos.flush();
                    baos.close();
                }
                break block17;
            }
            catch (IOException e) {
                e.printStackTrace();
                MLog.error((Object)TAG, (String)"bitmapToArr finally err:%s", (Object[])new Object[]{e.getMessage()});
            }
            break block17;
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    MLog.error((Object)TAG, (String)"bitmapToArr err:%s", (Object[])new Object[]{e.getMessage()});
                }
                catch (Throwable throwable) {
                    try {
                        if (baos != null) {
                            baos.flush();
                            baos.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        MLog.error((Object)TAG, (String)"bitmapToArr finally err:%s", (Object[])new Object[]{e2.getMessage()});
                    }
                    throw throwable;
                }
                try {
                    if (baos != null) {
                        baos.flush();
                        baos.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                    MLog.error((Object)TAG, (String)"bitmapToArr finally err:%s", (Object[])new Object[]{e3.getMessage()});
                }
            }
        }
        return null;
    }

    @Override
    public void appSaveLocalDataCallback(String context, String savedKey, boolean success2) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("context", context);
        map.put("savedKey", savedKey);
        map.put("success", success2);
        this.getGameMessageInterface().appCallGame("appSaveLocalDataCallback", map, GameProxyDef.DEF_TAG);
    }

    @Override
    public void appLoadDataCallback(String context, String loadedKey, String jsonData, boolean success2) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("context", context);
        map.put("loadedKey", loadedKey);
        map.put("jsonData", jsonData);
        map.put("success", success2);
        this.getGameMessageInterface().appCallGame("appLoadDataCallback", map, GameProxyDef.DEF_TAG);
    }

    @Override
    public void appDownloadFileCallback(String context, String fileUrl, String localFilePath, boolean success2) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("context", context);
        map.put("fileUrl", fileUrl);
        map.put("localFilePath", localFilePath);
        map.put("success", success2);
        this.getGameMessageInterface().appCallGame("appDownloadFileCallback", map, GameProxyDef.DEF_TAG);
    }

    @Override
    public void appDownloadFileProgressCallback(String context, String fileUrl, String localFilePath, long currentSize, long totalSize) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("context", context);
        jsonObject.addProperty("fileUrl", fileUrl);
        jsonObject.addProperty("localFilePath", localFilePath);
        jsonObject.addProperty("currentSize", (Number)currentSize);
        jsonObject.addProperty("totalSize", (Number)totalSize);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("0", jsonObject.toString());
        this.getGameMessageInterface().appCallGame("appDownloadFileProgressCallback", map, GameProxyDef.DEF_TAG);
    }

    @Override
    public void appGetImageDataCallback(String context, String imageUrl, byte[] imageData) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("context", context);
        map.put("imageUrl", imageUrl);
        map.put("imageData", imageData);
        this.getGameMessageInterface().appCallGame("appGetImageDataCallback", map, GameProxyDef.DEF_TAG);
    }

    @Override
    public void appGetLocalEmoji(String context, String emojiId) {
    }

    @Override
    public void appGetLocalEmojiCallback(String context, String emojiId, byte[] emojiData) {
    }
}

