/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gameproxy.gameinfoservice;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.http.INetRespOriginJsonParseCallback;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.OkHttpUtils;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.game.bean.ScreenSafeBean;
import com.yy.game.gameproxy.GameProxyDef;
import com.yy.game.gameproxy.LuaGameController;
import com.yy.game.gameproxy.appcallgame.AppCallGameProxy;
import com.yy.game.module.jscallappmodule.model.GameUserInfo;
import com.yy.game.porxy.IGameMsgInterface;
import com.yy.game.porxy.proxy.ILuaGameInfoService;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.kvomodule.GameInfoModuleData;
import com.yy.hiyo.game.service.IGameInfoService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.json.JSONObject;

@Deprecated
public class LuaGameInfoController
extends LuaGameController
implements ILuaGameInfoService {
    private static final String TAG = "LuaGameInfoController";
    private static OkHttpClient sClient;
    static final String HTTP_TYPE = "HTTP";
    static final String PB_TYPE = "PB";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OkHttpClient getClient() {
        if (sClient != null) {
            return sClient;
        }
        Class<LuaGameInfoController> clazz = LuaGameInfoController.class;
        synchronized (LuaGameInfoController.class) {
            if (SettingFlags.getBoolean((String)"gamehttpusenewpool", (boolean)true)) {
                sClient = OkHttpUtils.getDefault().getOkHttpClient().newBuilder().connectionPool(new ConnectionPool(0, 5L, TimeUnit.MINUTES)).build();
                // ** MonitorExit[var0] (shouldn't be in output)
                return sClient;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return OkHttpUtils.getDefault().getOkHttpClient();
        }
    }

    public LuaGameInfoController(Environment env, IGameMsgInterface iGameMessageInterface) {
        super(env, iGameMessageInterface);
    }

    @Override
    public void getInfoFromApp(final String context, final long seqId, Vector<String> args) {
        if (args == null || args.size() < 3) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"getInfoFromApp err,args is not valid:args:%s", (Object[])new Object[]{args});
            }
            this.appGetInfoFromAppCallback(context, seqId, null);
            return;
        }
        String requestType = args.get(0);
        String method = args.get(1);
        String url = args.get(2);
        String json = "";
        if (args.size() == 4) {
            json = args.get(3);
        }
        if (HTTP_TYPE.equalsIgnoreCase(requestType)) {
            if (StringUtils.isEmpty((String)url) || !url.startsWith("http")) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"url error:%s", (Object[])new Object[]{url});
                }
                this.appGetInfoFromAppCallback(context, seqId, null);
                return;
            }
            HashMap params = null;
            if (!StringUtils.isEmpty((String)json)) {
                params = new HashMap(JsonParser.parseJsonMap((String)json, String.class, String.class));
            }
            HttpUtil.httpReq((String)url, params, (int)("POST".equalsIgnoreCase(method) ? 2 : 1), (INetRespCallback)new INetRespOriginJsonParseCallback<String>(){

                public void onError(Call call, Exception e, int id2) {
                    MLog.error((Object)LuaGameInfoController.TAG, (String)"getInfoFromApp err:", (Object[])new Object[]{e.getMessage()});
                    LuaGameInfoController.this.appGetInfoFromAppCallback(context, seqId, null);
                }

                public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)LuaGameInfoController.TAG, (String)"getInfoFromApp resp:%s", (Object[])new Object[]{response});
                    }
                    LuaGameInfoController.this.appGetInfoFromAppCallback(context, seqId, response);
                }
            });
        } else if (PB_TYPE.equalsIgnoreCase(requestType)) {
            MLog.error((Object)TAG, (String)"PB req is ignore!", (Object[])new Object[0]);
            this.appGetInfoFromAppCallback(context, seqId, null);
        } else {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"request type err,type:%s", (Object[])new Object[]{requestType});
            }
            this.appGetInfoFromAppCallback(context, seqId, null);
        }
    }

    @Override
    public void getUserInfoFromApp(final String context, final long seqId, Vector<String> args) {
        final ArrayList gameUserInfos = new ArrayList();
        if (args == null || args.isEmpty()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"getUserInfoFromApp err,arg is empty", (Object[])new Object[0]);
            }
            this.appGetUserInfoCallback(context, seqId, JsonParser.toJson(gameUserInfos));
            return;
        }
        String uidsJson = args.get(0);
        if (StringUtils.isEmpty((String)uidsJson)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"getUserInfoFromApp err,arg is empty", (Object[])new Object[0]);
            }
            this.appGetUserInfoCallback(context, seqId, JsonParser.toJson(gameUserInfos));
            return;
        }
        ArrayList uids = new ArrayList();
        try {
            uids.addAll(JsonParser.parseJsonList((String)uidsJson, Long.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (uids.isEmpty()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"parse uid err,uid = %s", (Object[])new Object[]{args});
            }
            this.appGetUserInfoCallback(context, seqId, JsonParser.toJson(gameUserInfos));
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getUserInfoFromApp,uids:%s", (Object[])new Object[]{uids});
        }
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uids, new OnProfileCallback(){

            public void onSuccess(int id2, final List<UserInfoKS> userInfoKSList) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)LuaGameInfoController.TAG, (String)"getUserInfoFromApp onSuccess,userInfoKSList =%s ", (Object[])new Object[]{userInfoKSList == null ? "" : userInfoKSList});
                        }
                        if (userInfoKSList == null || userInfoKSList.isEmpty()) {
                            LuaGameInfoController.this.appGetUserInfoCallback(context, seqId, JsonParser.toJson((Object)gameUserInfos));
                            return;
                        }
                        for (UserInfoKS info : userInfoKSList) {
                            GameUserInfo info1 = new GameUserInfo();
                            info1.avatar = info.avatar;
                            info1.birthday = info.birthday;
                            info1.nick = info.nick;
                            info1.city = info.lastLoginLocation;
                            info1.sex = info.sex;
                            info1.uid = info.uid;
                            info1.zodiac = DateUtils.getZodiac((String)info.birthday);
                            info1.locationTude = info.locationTude;
                            info1.hideLocation = info.hideLocation;
                            info1.vid = info.vid;
                            gameUserInfos.add(info1);
                        }
                        LuaGameInfoController.this.appGetUserInfoCallback(context, seqId, JsonParser.toJson((Object)gameUserInfos));
                    }
                });
            }

            public void onFail(int id2, String msg, String response) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)LuaGameInfoController.TAG, (String)"getUserInfoFromApp:id = %s,msg = %s,response=%s ", (Object[])new Object[]{id2, msg, response});
                }
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LuaGameInfoController.this.appGetUserInfoCallback(context, seqId, JsonParser.toJson((Object)gameUserInfos));
                    }
                });
            }

            public int id() {
                return 0;
            }
        });
    }

    @Override
    public void getGameInfoFromApp(String context, long seqId, Vector<String> args) {
        String retJson = "";
        String gidJson = null;
        if (args == null || args.isEmpty() || StringUtils.isEmpty((String)(gidJson = args.get(0)))) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"getGameInfoFromApp args is empty", (Object[])new Object[0]);
            }
            this.appGetGameInfoCallback(context, seqId, retJson);
            return;
        }
        IServiceManager iServiceManager = this.getServiceManager();
        IGameInfoService gameInfoService2 = null;
        if (iServiceManager == null || (gameInfoService2 = (IGameInfoService)iServiceManager.getService(IGameInfoService.class)) == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"servicemanager or gameinfoservice is null", (Object[])new Object[0]);
            }
            this.appGetGameInfoCallback(context, seqId, retJson);
            return;
        }
        String gid = null;
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)gidJson);
            gid = jsonObject.optString("gid");
        }
        catch (Exception e) {
            e.printStackTrace();
            MLog.error((Object)TAG, (String)"parse gid err:%s", (Object[])new Object[]{gidJson});
        }
        if (StringUtils.isEmpty((String)gid)) {
            this.appGetGameInfoCallback(context, seqId, retJson);
            return;
        }
        GameInfo gameInfo = gameInfoService2.getGameInfoByGid(gid);
        if (gameInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"getGameInfoFromApp null", (Object[])new Object[0]);
            }
            this.appGetGameInfoCallback(context, seqId, retJson);
            return;
        }
        retJson = JsonParser.toJson((Object)gameInfo);
        try {
            String lang = "";
            KvoSource data = KvoModuleManager.getModuleData(GameInfoModule.class);
            if (data instanceof GameInfoModuleData) {
                lang = ((GameInfoModuleData)data).getRunningGameData().getCurGameLang();
            }
            JSONObject jsonObj = JsonParser.obtainJSONObject((String)retJson);
            jsonObj.put("app_lang", (Object)lang);
            retJson = jsonObj.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            MLog.error((Object)TAG, (String)"parse ret json err:%s", (Object[])new Object[]{retJson});
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getGameInfoFromApp ret:%s", (Object[])new Object[]{retJson});
        }
        this.appGetGameInfoCallback(context, seqId, retJson);
    }

    @Override
    public void getDeviceInfoFromApp(String context, long seqId, Vector<String> args) {
        JsonObject data = new JsonObject();
        data.addProperty("appVersion", VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext).getVersionNameWithoutSnapshot());
        data.addProperty("deviceID", CommonHttpHeader.getHagoDeviceId());
        data.addProperty("deviceName", Build.DEVICE);
        data.addProperty("systemVersion", Build.VERSION.RELEASE);
        data.addProperty("lang", SystemUtils.getLangAndCountry());
        data.addProperty("idc", (Number)UriProvider.getIdc());
        data.addProperty("country", this.countryCode());
        JsonObject screenSizeData = new JsonObject();
        screenSizeData.addProperty("width", (Number)ScreenUtils.getInstance().getWidthPixels());
        screenSizeData.addProperty("height", (Number)ScreenUtils.getInstance().getHeightPixels());
        data.add("screenSize", (JsonElement)screenSizeData);
        JsonObject safeAreaInsetData = new JsonObject();
        ScreenSafeBean screenSafeBean = this.getSafeAreaInset((Context)this.mContext);
        safeAreaInsetData.addProperty("top", (Number)screenSafeBean.getTop());
        safeAreaInsetData.addProperty("left", (Number)screenSafeBean.getLeft());
        safeAreaInsetData.addProperty("bottom", (Number)screenSafeBean.getBottom());
        safeAreaInsetData.addProperty("right", (Number)screenSafeBean.getRight());
        data.add("safeAreaInset", (JsonElement)safeAreaInsetData);
        this.appGetDeviceInfoCallback(context, seqId, data.toString());
    }

    public ScreenSafeBean getSafeAreaInset(Context context) {
        ScreenSafeBean screenSafeBean = new ScreenSafeBean();
        if (ScreenUtils.getInstance().hasNotch((Activity)this.mContext)) {
            if (this.mWindowMgr.getCurrentWindow().getScreenOrientationType() == 0) {
                screenSafeBean.setLeft(SystemUtils.getStatusBarHeight((Context)context));
                screenSafeBean.setRight(SystemUtils.getStatusBarHeight((Context)context));
            } else {
                screenSafeBean.setTop(SystemUtils.getStatusBarHeight((Context)context));
            }
        }
        return screenSafeBean;
    }

    @Override
    public void appEnterForeground(String context) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"appEnterForeground context = %s", (Object[])new Object[]{context});
        }
        this.sendToGameNormal("appEnterForeground", context, AppCallGameProxy.getSingleton().uniqueSeq(), "");
    }

    @Override
    public void appEnterBackground(String context) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"appEnterBackground context = %s", (Object[])new Object[]{context});
        }
        this.sendToGameNormal("appEnterBackground", context, AppCallGameProxy.getSingleton().uniqueSeq(), "");
    }

    @Override
    public void appGetInfoFromAppCallback(String context, long seqId, String dataJson) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"appGetInfoFromAppCallback context = %s dataJson = %s", (Object[])new Object[]{context, dataJson});
        }
        this.sendToGameNormal("appGetInfoFromAppCallback", context, seqId, dataJson);
    }

    @Override
    public void appGetUserInfoCallback(String context, long seqId, String dataJson) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"appGetUserInfoCallback context = %s dataJson = %s", (Object[])new Object[]{context, dataJson});
        }
        this.sendToGameNormal("appGetUserInfoCallback", context, seqId, dataJson);
    }

    @Override
    public void appGetGameInfoCallback(String context, long seqId, String dataJson) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"appGetGameInfoCallback context = %s dataJson = %s", (Object[])new Object[]{context, dataJson});
        }
        this.sendToGameNormal("appGetGameInfoCallback", context, seqId, dataJson);
    }

    @Override
    public void appGetDeviceInfoCallback(String context, long seqId, String dataJson) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"appGetDeviceInfoCallback context = %s dataJson = %s", (Object[])new Object[]{context, dataJson});
        }
        this.sendToGameNormal("appGetDeviceInfoCallback", context, seqId, dataJson);
    }

    @Override
    public void appRegisteredEventCallback(String context, long seqId, int event, String dataJson) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"appRegisteredEventCallback event = %s dataJson = %s", (Object[])new Object[]{event, dataJson});
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("context", context);
        map.put("seqId", seqId);
        map.put("event", event);
        map.put("jsonData", dataJson);
        this.getGameMessageInterface().appCallGame("appRegisteredEventCallback", map, GameProxyDef.DEF_TAG);
    }

    public void sendToGameNormal(String function, String context, long seqId, String dataJson) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("context", context);
        map.put("seqId", seqId);
        map.put("jsonData", dataJson);
        this.getGameMessageInterface().appCallGame(function, map, GameProxyDef.DEF_TAG);
    }

    private String countryCode() {
        String code = AccountUtil.realCountry();
        if (TextUtils.isEmpty((CharSequence)code)) {
            code = SystemUtils.getHagoCountry();
        }
        if (code == null) {
            return "";
        }
        return code.toUpperCase();
    }
}

