/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gameproxy.gamecallapp;

import com.yy.appbase.core.DefaultController;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.Environment;
import com.yy.game.gameproxy.gamecallapp.IGameCallAppProxy;
import com.yy.game.porxy.proxy.IGameProxyService;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;

@Deprecated
public class GameCallAppProxy
extends DefaultController
implements IGameCallAppProxy {
    private static final String TAG = "GameCallAppProxy";
    IGameProxyService iGameProxyService;
    String mRoomId;
    String mGameId;

    public GameCallAppProxy(Environment env, IGameProxyService iGameProxyService) {
        super(env);
        this.iGameProxyService = iGameProxyService;
    }

    @Override
    public void setRoomId(String roomId) {
        this.mRoomId = roomId;
    }

    @Override
    public void setGameId(String gameId) {
        this.mGameId = gameId;
    }

    @Override
    public void reportMetricsReturnCodeWithUri(String uri, int time, int returnCode) {
        this.iGameProxyService.getBaseService().reportMetricsReturnCodeWithUri(uri, time, returnCode);
    }

    @Override
    public void logError(String message) {
        this.iGameProxyService.getBaseService().logError(message);
    }

    @Override
    public void logInfo(String message) {
        this.iGameProxyService.getBaseService().logInfo(message);
    }

    @Override
    public void pkGameSendReq(String type, String data) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"[pkGameSendReq] type=%s,data=%s", (Object[])new Object[]{type, data});
        }
        this.iGameProxyService.getDataService().pkGameSendReq(type, data);
    }

    @Override
    public void gameDownloadFile(String context, String fileUrl, String toFilePath, int priority) {
        this.iGameProxyService.getUtilSetvice().gameDownloadFile(context, fileUrl, toFilePath, priority);
    }

    @Override
    public void getImageData(String context, String imageUrl, int scaleWidth, int scaleHeight) {
        this.iGameProxyService.getUtilSetvice().getImageData(context, imageUrl, scaleWidth, scaleHeight);
    }

    @Override
    public void onReceiveGameMessage(String type, Map<String, Object> msgObj, int tag) {
        String context = "";
        long seqId = 0L;
        Object params = new Object();
        Vector<String> args = new Vector<String>();
        if (msgObj != null) {
            context = (String)msgObj.get("context");
            if (msgObj.get("seqId") != null) {
                seqId = ((Number)msgObj.get("seqId")).longValue();
            }
            params = msgObj.get("args");
        }
        if (params instanceof Vector) {
            try {
                args.addAll((Collection)params);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        switch (type) {
            case "getInfoFromApp": {
                this.getInfoFromApp(context, seqId, args);
                break;
            }
            case "getUserInfoFromApp": {
                this.getUserInfoFromApp(context, seqId, args);
                break;
            }
            case "getGameInfoFromApp": {
                this.getGameInfoFromApp(context, seqId, args);
                break;
            }
            case "getDeviceInfoFromApp": {
                this.getDeviceInfoFromApp(context, seqId, args);
                break;
            }
            case "gameSaveDataToLocal": {
                String key = (String)msgObj.get("key");
                String jsonData = (String)msgObj.get("jsonData");
                this.gameSaveDataToLocal(context, key, jsonData);
                break;
            }
            case "getImageData": {
                String imageUrl = (String)msgObj.get("fileUrl");
                int scaleWidth = ((Number)msgObj.get("scaleWidth")).intValue();
                int scaleHeight = ((Number)msgObj.get("scaleHeight")).intValue();
                this.getImageData(context, imageUrl, scaleWidth, scaleHeight);
                break;
            }
            case "gameLoadDataFromLocal": {
                String objKey = (String)msgObj.get("objKey");
                this.gameLoadDataFromLocal(context, objKey);
                break;
            }
            case "gameDownloadFile": {
                String fileUrl = (String)msgObj.get("fileUrl");
                String toFilePath = (String)msgObj.get("localFilePath");
                int priority = 50;
                if (msgObj.get("priority") instanceof Integer) {
                    priority = (Integer)msgObj.get("priority");
                    if (priority < 0) {
                        priority = 50;
                    }
                    MLog.debug((Object)TAG, (String)"GAMEDOWNLOAD_FILE priority=%s", (Object[])new Object[]{priority});
                }
                this.gameDownloadFile(context, fileUrl, toFilePath, priority);
                break;
            }
            case "gameSendData": {
                byte[] header = (byte[])msgObj.get("header");
                byte[] body = (byte[])msgObj.get("body");
                this.gameSendData(this.mRoomId != null ? this.mRoomId : "", header, body, this.mGameId);
                break;
            }
            case "reportMetricsReturnCodeWithUri": {
                String uri = (String)msgObj.get("uri");
                int time = ((Number)msgObj.get("time")).intValue();
                int returnCode = ((Number)msgObj.get("returnCode")).intValue();
                this.reportMetricsReturnCodeWithUri(uri, time, returnCode);
                break;
            }
        }
    }

    @Override
    public void gameSendData(String context, byte[] header, byte[] body, String gameId) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"[gameSendData] context=%s || header=%s", (Object[])new Object[]{context, new String(header)});
        }
        this.iGameProxyService.getDataService().gameSendData(context, header, body, gameId);
    }

    @Override
    public void getInfoFromApp(String context, long seqId, Vector<String> args) {
        this.iGameProxyService.getInfoService().getInfoFromApp(context, seqId, args);
    }

    @Override
    public void getUserInfoFromApp(final String context, final long seqId, final Vector<String> args) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                GameCallAppProxy.this.iGameProxyService.getInfoService().getUserInfoFromApp(context, seqId, args);
            }
        });
    }

    @Override
    public void getGameInfoFromApp(String context, long seqId, Vector<String> args) {
        this.iGameProxyService.getInfoService().getGameInfoFromApp(context, seqId, args);
    }

    @Override
    public void getDeviceInfoFromApp(String context, long seqId, Vector<String> args) {
        this.iGameProxyService.getInfoService().getDeviceInfoFromApp(context, seqId, args);
    }

    @Override
    public void gameSaveDataToLocal(String context, String key, String jsonData) {
        this.iGameProxyService.getUtilSetvice().gameSaveDataToLocal(context, key, jsonData);
    }

    @Override
    public void gameLoadDataFromLocal(String context, String objKey) {
        this.iGameProxyService.getUtilSetvice().gameLoadDataFromLocal(context, objKey);
    }
}

