/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gameproxy;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.appbase.service.cocosproxy.IAppNotifyGameFunction;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.game.bean.SingnalStrenBean;
import com.yy.hiyo.game.service.ICocosProxyService;
import java.util.HashSet;
import java.util.Set;

@Deprecated
public class AppNotifyGameController
extends DefaultController
implements IAppNotifyGameFunction {
    private static final String TAG = "AppNotifyGameController";
    private final Set<Integer> mNotiySet = new HashSet<Integer>();
    int netType = NetworkUtils.getNetworkType((Context)this.mContext);
    String mGameContext;
    ICocosProxyService iCocosProxyService;
    private final KvoBinder mBinder = new KvoBinder((Object)this);
    public volatile SingnalStrenBean mSingnalStrenBean = new SingnalStrenBean();
    long lastNetChangeTime = 0L;
    static final long NET_CHANGE_GAP = 2000L;
    PhoneStateListener mMyPhoneListener = new PhoneStateListener(){

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            if (AppNotifyGameController.this.netType == 1 || AppNotifyGameController.this.netType == 0) {
                return;
            }
            if (System.currentTimeMillis() - AppNotifyGameController.this.lastNetChangeTime < 2000L) {
                return;
            }
            AppNotifyGameController.this.lastNetChangeTime = System.currentTimeMillis();
            String signalinfo = signalStrength.toString();
            String[] parts = signalinfo.split(" ");
            int ltedbm = 0;
            if (parts.length >= 10) {
                ltedbm = StringUtils.safeParseInt((String)parts[9]);
            }
            int asu = signalStrength.getGsmSignalStrength();
            int dbm = -113 + 2 * asu;
            if (AppNotifyGameController.this.netType == 4) {
                AppNotifyGameController.this.mSingnalStrenBean.setNetWorkType(AppNotifyGameController.this.netType);
                AppNotifyGameController.this.mSingnalStrenBean.setDbm(ltedbm);
            } else if (AppNotifyGameController.this.netType == 3) {
                AppNotifyGameController.this.mSingnalStrenBean.setNetWorkType(AppNotifyGameController.this.netType);
                AppNotifyGameController.this.mSingnalStrenBean.setDbm(dbm);
            } else if (AppNotifyGameController.this.netType == 2) {
                AppNotifyGameController.this.mSingnalStrenBean.setNetWorkType(AppNotifyGameController.this.netType);
                AppNotifyGameController.this.mSingnalStrenBean.setDbm(dbm);
            }
            super.onSignalStrengthsChanged(signalStrength);
        }
    };
    public BroadcastReceiver rssiReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"Rssi", (String)"RSSI changed", (Object[])new Object[0]);
            }
            if (AppNotifyGameController.this.netType != 1) {
                return;
            }
            if (System.currentTimeMillis() - AppNotifyGameController.this.lastNetChangeTime < 2000L) {
                return;
            }
            AppNotifyGameController.this.lastNetChangeTime = System.currentTimeMillis();
            AppNotifyGameController.this.mSingnalStrenBean.setNetWorkType(1);
            AppNotifyGameController.this.mSingnalStrenBean.setDbm(NetworkUtils.getWifiStrength((Context)AppNotifyGameController.this.mContext));
        }
    };

    public AppNotifyGameController(Environment env, ICocosProxyService iCocosProxyService) {
        super(env);
        this.iCocosProxyService = iCocosProxyService;
    }

    public void init() {
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        try {
            AppNotifyGameController.registerSignalStrengths((Context)this.mContext, this.mMyPhoneListener);
            this.mContext.registerReceiver(this.rssiReceiver, new IntentFilter("android.net.wifi.RSSI_CHANGED"));
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void uninit() {
        try {
            AppNotifyGameController.unRegisterSignalStrengths((Context)this.mContext, this.mMyPhoneListener);
            this.mContext.unregisterReceiver(this.rssiReceiver);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        this.mBinder.clearAllKvoConnections();
    }

    public void registerNotify(String context, long seqId, int event) {
        this.mGameContext = context;
        if (event == CocosProxyType.onNetWorkStrengthChange.getEvent()) {
            this.bindingStrength(this.mSingnalStrenBean);
        }
    }

    public void unRegisterNotify(String context, long seqId, int event) {
        if (event == CocosProxyType.onNetWorkStrengthChange.getEvent()) {
            this.unBindingStrength(this.mSingnalStrenBean);
        }
    }

    public void bindingStrength(SingnalStrenBean singnalStrenBean) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"bindingRoomData", (Object[])new Object[0]);
        }
        this.mBinder.singleBindSourceTo((KvoSource)singnalStrenBean);
    }

    public void unBindingStrength(SingnalStrenBean singnalStrenBean) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"bindingRoomData", (Object[])new Object[0]);
        }
        this.mBinder.clearKvoConnection(SingnalStrenBean.class.getName());
    }

    @KvoMethodAnnotation(sourceClass=SingnalStrenBean.class, name="dbm", thread=1)
    public void onSingnalStrenChanged(KvoEventIntent event) {
        final SingnalStrenBean singnalStrenBean = (SingnalStrenBean)event.source();
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                AppNotifyGameController.this.iCocosProxyService.appNotifyGame(AppNotifyGameController.this.mGameContext, CocosProxyType.onNetWorkStrengthChange.getEvent(), (Object)singnalStrenBean);
            }
        });
    }

    public static void registerSignalStrengths(Context context, PhoneStateListener myPhoneListener) {
        TelephonyManager telephonyManager = SystemServiceUtils.getTelephonyManager((Context)context);
        telephonyManager.listen(myPhoneListener, 256);
    }

    public static void unRegisterSignalStrengths(Context context, PhoneStateListener myPhoneListener) {
        TelephonyManager telephonyManager = SystemServiceUtils.getTelephonyManager((Context)context);
        telephonyManager.listen(myPhoneListener, 0);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_NETWORK_STATE_CHANGE) {
            this.netType = NetworkUtils.getNetworkType((Context)this.mContext);
        }
    }
}

