/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.webgame;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.webgame.IBackInterface;

public class WebGameTopbar {
    private View topbar;
    private View leftView;
    private View rightView;
    private View btnMore;
    private View mShortcutView;
    private View mAngleView;
    private YYTextView mTipView;
    public static final int POSITION_LEFT = 0;
    public static final int POSITION_RIGHT = 1;
    private Runnable mTipRunnable;

    public WebGameTopbar(Context context, ViewGroup viewGroup, final IBackInterface backInterface) {
        MLog.debug((Object)"WebGameTopbar", (String)"init", (Object[])new Object[0]);
        this.topbar = LayoutInflater.from((Context)context).inflate(R.layout.layout_webgame_topbar, viewGroup, true);
        this.leftView = this.topbar.findViewById(R.id.iv_left_back);
        this.rightView = this.topbar.findViewById(R.id.iv_right_close);
        this.mShortcutView = this.topbar.findViewById(R.id.iv_shortcut);
        this.btnMore = this.topbar.findViewById(R.id.iv_more);
        this.mAngleView = this.topbar.findViewById(R.id.iv_tip_angle);
        this.mTipView = (YYTextView)this.topbar.findViewById(R.id.tv_tip_content);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (backInterface != null) {
                    if (v == WebGameTopbar.this.btnMore) {
                        backInterface.onMoreClick();
                    } else if (v == WebGameTopbar.this.leftView || v == WebGameTopbar.this.rightView) {
                        backInterface.onBack();
                    } else if (v == WebGameTopbar.this.mTipView) {
                        WebGameTopbar.this.hideShortcutTip();
                    } else if (v == WebGameTopbar.this.mShortcutView) {
                        backInterface.onShortcut();
                    }
                }
            }
        };
        this.leftView.setOnClickListener(onClickListener);
        this.rightView.setOnClickListener(onClickListener);
        this.mShortcutView.setOnClickListener(onClickListener);
        this.btnMore.setOnClickListener(onClickListener);
        this.mTipView.setOnClickListener(onClickListener);
        this.leftView.setVisibility(8);
        this.btnMore.setVisibility(8);
    }

    public void updateBackVisible(boolean show2, int position) {
        if (show2) {
            if (this.leftView != null) {
                this.leftView.setVisibility(position == 0 ? 0 : 8);
            }
            if (this.rightView != null) {
                this.rightView.setVisibility(position == 1 ? 0 : 8);
            }
        } else {
            if (this.leftView != null) {
                this.leftView.setVisibility(8);
            }
            if (this.rightView != null) {
                this.rightView.setVisibility(8);
            }
        }
    }

    public void setMoreView(boolean show2) {
        if (this.btnMore != null) {
            if (show2) {
                this.btnMore.setVisibility(0);
            } else {
                this.btnMore.setVisibility(8);
            }
        }
    }

    public void setShortcutView(boolean show2) {
        if (this.mShortcutView != null) {
            if (show2) {
                this.mShortcutView.setVisibility(0);
            } else {
                this.mShortcutView.setVisibility(8);
            }
        }
    }

    public void hideShortcutTip() {
        this.updateShortcutTip("", 0L);
    }

    public void updateShortcutTip(String tip, long delay) {
        if (StringUtils.isEmpty((String)tip)) {
            this.mTipView.setVisibility(8);
            this.mAngleView.setVisibility(8);
            if (this.mTipRunnable != null) {
                YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mTipRunnable);
            }
        } else {
            String current = "";
            if (this.mTipView.getText() != null) {
                current = this.mTipView.getText().toString();
            }
            if (!StringUtils.equal((String)current, (String)tip)) {
                this.mTipView.setText((CharSequence)tip);
                this.mTipView.setVisibility(0);
                this.mAngleView.setVisibility(0);
                if (delay > 0L) {
                    if (this.mTipRunnable == null) {
                        this.mTipRunnable = new Runnable(){

                            @Override
                            public void run() {
                                WebGameTopbar.this.updateShortcutTip("", 0L);
                            }
                        };
                    }
                    YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mTipRunnable);
                    YYTaskExecutor.postToMainThread((Runnable)this.mTipRunnable, (long)delay);
                }
            }
        }
    }
}

