/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextSwitcher;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.game.R;

public class ModeSwitcher
extends TextSwitcher {
    private TextView[] textViews = new TextView[2];
    private boolean canAnim = true;

    public ModeSwitcher(Context context) {
        super(context);
        this.createViews();
        this.initAnim();
    }

    public ModeSwitcher(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createViews();
        this.initAnim();
    }

    private void initAnim() {
        this.setInAnimation(this.getContext(), R.anim.text_flip_in);
        this.setOutAnimation(this.getContext(), R.anim.text_flip_out);
    }

    private void createViews() {
        for (int i = 0; i < this.textViews.length; ++i) {
            this.textViews[i] = this.createTextView();
            this.addView((View)this.textViews[i], i, new ViewGroup.LayoutParams(-2, -2));
        }
    }

    private TextView createTextView() {
        YYTextView textView = new YYTextView(this.getContext());
        textView.setTextColor(-1);
        textView.setTextSize(15.0f);
        textView.getPaint().setFakeBoldText(true);
        return textView;
    }

    public void setText(CharSequence text) {
        if (this.canAnim) {
            super.setText(text);
        } else {
            this.setCurrentText(text);
        }
    }

    public void setCanAnim(boolean canAnim) {
        this.canAnim = canAnim;
    }

    public void setTextColor(@ColorInt int color2) {
        for (int i = 0; i < this.textViews.length; ++i) {
            this.textViews[i].setTextColor(color2);
        }
    }

    public void setTextSize(float size) {
        for (int i = 0; i < this.textViews.length; ++i) {
            this.textViews[i].setTextSize(size);
        }
    }
}

