/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.teammatch.ui.adapter.invite.InviteAdapter;
import com.yy.hiyo.game.base.teamgame.IInviteCallback;
import com.yy.hiyo.game.base.teamgame.InviteItem;
import java.util.List;

public class InviteListView
extends YYFrameLayout {
    private RecyclerView rvInvite;
    private InviteAdapter mAdapter;
    private boolean totalGone = false;
    private boolean isLandscape = false;
    private int currentVisibilty = 0;

    public InviteListView(@NonNull Context context) {
        this(context, null);
    }

    public InviteListView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public InviteListView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.InviteListView);
        this.isLandscape = ta.getBoolean(R.styleable.InviteListView_layoutLandscape, false);
        ta.recycle();
        int layoutId = this.isLandscape ? R.layout.view_invite_bottom_land : R.layout.view_invite_bottom;
        InviteListView.inflate((Context)context, (int)layoutId, (ViewGroup)this);
        this.rvInvite = (RecyclerView)this.findViewById(R.id.rv_invite);
    }

    public void setCallback(IInviteCallback callback2) {
        this.setDatas(null);
        this.mAdapter.setCallback(callback2);
    }

    public void setDatas(List<InviteItem> datas) {
        if (this.mAdapter == null) {
            this.mAdapter = new InviteAdapter(this.isLandscape);
            this.rvInvite.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), this.isLandscape ? 1 : 0, false));
            this.rvInvite.setAdapter((RecyclerView.Adapter)this.mAdapter);
        }
        this.mAdapter.setDatas(datas);
    }

    public void setVisibility(int visibility) {
        this.currentVisibilty = visibility;
        if (this.totalGone) {
            super.setVisibility(8);
        } else {
            super.setVisibility(visibility);
        }
    }

    public void setTotalGone(boolean totalGone) {
        this.totalGone = totalGone;
        this.setVisibility(this.currentVisibilty);
    }
}

