/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.flexbox.FlexboxLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;
import java.util.List;

public class BarragePanelView
extends YYRelativeLayout
implements View.OnClickListener {
    private UiCallback uiCallback;
    private int[] barrageBgColors = ResourceUtils.getIntArray((int)R.array.barrage_bg_colors);
    private FlexboxLayout flexboxLayout;
    private ImageView ivRightArrow;
    private int arrowTop = ResolutionUtils.dip2Px((float)20.0f);
    private int arrowHeight = ResolutionUtils.dip2Px((float)12.0f);

    public BarragePanelView(Context context) {
        this(context, null);
    }

    public BarragePanelView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BarragePanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.ivRightArrow = new YYImageView(this.getContext());
        this.ivRightArrow.setImageResource(R.drawable.ic_white_right_arrow);
        RelativeLayout.LayoutParams arrowLp = new RelativeLayout.LayoutParams(ResolutionUtils.dip2Px((float)10.0f), this.arrowHeight);
        if (LanguageUtils.isLtr()) {
            arrowLp.addRule(11);
        } else {
            arrowLp.addRule(9);
            this.ivRightArrow.setRotationY(-180.0f);
        }
        arrowLp.topMargin = this.arrowTop;
        this.addView((View)this.ivRightArrow, (ViewGroup.LayoutParams)arrowLp);
        this.addFlexboxLayout();
        this.setClickable(true);
    }

    public int getArrowCenterTop() {
        return this.arrowTop + this.arrowHeight / 2;
    }

    public int getArrowHeight() {
        return this.arrowHeight;
    }

    public void setArrowTop(int arrowTop) {
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.ivRightArrow.getLayoutParams();
        lp.topMargin = arrowTop;
        this.ivRightArrow.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.arrowTop = arrowTop;
    }

    private void addFlexboxLayout() {
        this.flexboxLayout = new FlexboxLayout(this.getContext());
        this.flexboxLayout.setFlexWrap(1);
        GradientDrawable bg = new GradientDrawable();
        bg.setShape(0);
        bg.setColor(-1);
        bg.setCornerRadius((float)ResolutionUtils.dip2Px((float)5.0f));
        this.setViewBackground((View)this.flexboxLayout, (Drawable)bg);
        int padding = ResolutionUtils.dip2Px((float)5.5f);
        this.flexboxLayout.setPadding(padding, padding, padding, padding);
        RelativeLayout.LayoutParams flexLp = new RelativeLayout.LayoutParams(-1, -2);
        flexLp.leftMargin = ResolutionUtils.dip2Px((float)8.0f);
        flexLp.rightMargin = ResolutionUtils.dip2Px((float)8.0f);
        this.addView((View)this.flexboxLayout, (ViewGroup.LayoutParams)flexLp);
    }

    private void addInputBtn() {
        YYTextView inputBtn = new YYTextView(this.getContext());
        inputBtn.setText(R.string.team_game_chat_type_something);
        inputBtn.setGravity(16);
        inputBtn.setTextColor(-5723992);
        inputBtn.setTextSize(12.0f);
        int paddingLeftRight = ResolutionUtils.dip2Px((float)16.0f);
        inputBtn.setPadding(paddingLeftRight, 0, paddingLeftRight, 0);
        GradientDrawable bg = new GradientDrawable();
        bg.setShape(0);
        bg.setColor(-1710619);
        bg.setCornerRadius((float)ResolutionUtils.dip2Px((float)3.0f));
        bg.setStroke(ResolutionUtils.dip2Px((float)0.5f), -2302756);
        this.setViewBackground((View)inputBtn, (Drawable)bg);
        inputBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BarragePanelView.this.uiCallback != null) {
                    BarragePanelView.this.uiCallback.onInputBtnClick();
                }
            }
        });
        FlexboxLayout.LayoutParams lp = new FlexboxLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)30.0f));
        int margin = ResolutionUtils.dip2Px((float)2.5f);
        lp.setMargins(margin, margin, margin, margin);
        this.flexboxLayout.addView((View)inputBtn, (ViewGroup.LayoutParams)lp);
    }

    public void setQuickMsgs(List<String> msgs) {
        this.flexboxLayout.removeAllViews();
        if (msgs != null) {
            for (int i = 0; i < msgs.size(); ++i) {
                this.addQuickMsg(i, msgs.get(i));
            }
        }
        this.addInputBtn();
    }

    private void addQuickMsg(int position, String msg) {
        if (position < 0) {
            return;
        }
        YYTextView tv = new YYTextView(this.getContext());
        tv.setText((CharSequence)msg);
        tv.setTextColor(-1);
        tv.setTextSize(12.0f);
        tv.getPaint().setFakeBoldText(true);
        tv.setGravity(17);
        tv.setClickable(true);
        int paddingLeftRight = ResolutionUtils.dip2Px((float)8.0f);
        tv.setPadding(paddingLeftRight, 0, paddingLeftRight, 0);
        int bgColor = this.barrageBgColors[position % this.barrageBgColors.length];
        Drawable bg = this.createQuickMsgBg(bgColor);
        this.setViewBackground((View)tv, bg);
        tv.setTag((Object)bgColor);
        FlexboxLayout.LayoutParams lp = new FlexboxLayout.LayoutParams(-2, ResolutionUtils.dip2Px((float)28.0f));
        lp.setFlexGrow(1.0f);
        int margin = ResolutionUtils.dip2Px((float)2.5f);
        lp.setMargins(margin, margin, margin, margin);
        this.flexboxLayout.addView((View)tv, (ViewGroup.LayoutParams)lp);
        tv.setOnClickListener((View.OnClickListener)this);
    }

    private Drawable createQuickMsgBg(int normalColor) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        GradientDrawable pressedBg = new GradientDrawable();
        pressedBg.setShape(0);
        pressedBg.setCornerRadius((float)ResolutionUtils.dip2Px((float)3.0f));
        int pressedColor = normalColor & 0xFFFFFF | 0xB2000000;
        pressedBg.setColor(pressedColor);
        stateListDrawable.addState(new int[]{16842919}, (Drawable)pressedBg);
        GradientDrawable normalBg = new GradientDrawable();
        normalBg.setShape(0);
        normalBg.setCornerRadius((float)ResolutionUtils.dip2Px((float)3.0f));
        normalBg.setColor(normalColor);
        stateListDrawable.addState(new int[0], (Drawable)normalBg);
        return stateListDrawable;
    }

    public void setUiCallback(UiCallback uiCallback) {
        this.uiCallback = uiCallback;
    }

    private void setViewBackground(View view, Drawable bg) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(bg);
        } else {
            view.setBackgroundDrawable(bg);
        }
    }

    public void onClick(View v) {
        if (v instanceof TextView) {
            TextView tv = (TextView)v;
            String msg = tv.getText().toString();
            Integer bgColor = (Integer)tv.getTag();
            if (bgColor == null) {
                bgColor = -16126;
            }
            if (this.uiCallback != null) {
                this.uiCallback.onMsgClick(msg, bgColor);
            }
        }
    }

    public static interface UiCallback {
        public void onMsgClick(String var1, int var2);

        public void onInputBtnClick();
    }
}

