/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.widget;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.widget.FrameLayout;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.game.gamemodule.teamgame.teammatch.ui.widget.BarragePanelView;
import java.util.ArrayList;
import java.util.List;

public class BarragePanel
implements BarragePanelView.UiCallback {
    private static final String TAG = "BarragePanel";
    private Context context;
    private BarragePanelView barragePanelView;
    private FrameLayout root;
    private List<String> quickMsgList = new ArrayList<String>();
    private BarragePanelView.UiCallback uiCallback;
    private long animationDuration = 150L;
    private boolean needRefresh = false;
    private boolean isShowing = false;
    private int viewHeight = 0;
    private int minBottomMargin = ResolutionUtils.dip2Px((float)10.0f);
    private LayoutStrategy layoutStrategy = new DefaultLayoutStrategy();

    public BarragePanel(Context context) {
        this.context = context;
        this.root = new YYFrameLayout(context);
        this.root.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BarragePanel.this.hide(true);
            }
        });
        this.root.setVisibility(8);
    }

    public void setQuickMsgList(List<String> msg) {
        this.quickMsgList.clear();
        this.quickMsgList.addAll(msg);
        this.needRefresh = true;
        this.viewHeight = 0;
    }

    public void setLayoutStrategy(LayoutStrategy layoutStrategy) {
        this.layoutStrategy = layoutStrategy;
    }

    private void init() {
        this.barragePanelView = new BarragePanelView(this.context);
        this.barragePanelView.setQuickMsgs(this.quickMsgList);
        this.barragePanelView.setUiCallback(this);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
        this.root.addView((View)this.barragePanelView, (ViewGroup.LayoutParams)lp);
        this.needRefresh = false;
    }

    public void setUiCallback(BarragePanelView.UiCallback uiCallback) {
        this.uiCallback = uiCallback;
    }

    public View getView() {
        return this.root;
    }

    public void show(View view) {
        int rootHeight;
        if (this.layoutStrategy == null) {
            return;
        }
        if (this.barragePanelView == null || this.needRefresh) {
            this.init();
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"show", (Object[])new Object[0]);
        }
        this.root.setVisibility(0);
        int left = this.layoutStrategy.getPanelLeft(view);
        int width = this.layoutStrategy.getPanelWidth(view);
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.barragePanelView.getLayoutParams();
        lp.width = width;
        lp.gravity = 51;
        lp.leftMargin = left;
        this.barragePanelView.setLayoutParams((ViewGroup.LayoutParams)lp);
        int[] viewLocation = new int[2];
        view.getLocationOnScreen(viewLocation);
        int yTop = viewLocation[1] - this.barragePanelView.getArrowCenterTop() + view.getHeight() / 2;
        if (this.viewHeight <= 0) {
            int msHight = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            int msWidth = View.MeasureSpec.makeMeasureSpec((int)width, (int)Integer.MIN_VALUE);
            this.barragePanelView.measure(msWidth, msHight);
            this.viewHeight = this.barragePanelView.getMeasuredHeight();
        }
        if (yTop + this.viewHeight + this.minBottomMargin > (rootHeight = ResolutionUtils.getScreenHeight((Context)this.context))) {
            yTop = rootHeight - this.viewHeight - this.minBottomMargin;
            int arrowTop = viewLocation[1] - yTop + (view.getHeight() - this.barragePanelView.getArrowHeight()) / 2;
            this.barragePanelView.setArrowTop(arrowTop);
        }
        lp.topMargin = yTop;
        this.barragePanelView.setVisibility(0);
        this.isShowing = true;
        ScaleAnimation anim2 = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, LanguageUtils.isLtr() ? 1.0f : 0.0f, 0, (float)this.barragePanelView.getArrowCenterTop());
        anim2.setDuration(this.animationDuration);
        anim2.setFillAfter(true);
        anim2.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.barragePanelView.startAnimation((Animation)anim2);
    }

    public void hide(boolean withAnim) {
        if (this.barragePanelView == null || !this.isShowing) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"hide", (Object[])new Object[0]);
        }
        if (withAnim) {
            ScaleAnimation anim2 = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 1, LanguageUtils.isLtr() ? 1.0f : 0.0f, 0, (float)this.barragePanelView.getArrowCenterTop());
            anim2.setDuration(this.animationDuration);
            anim2.setFillAfter(true);
            anim2.setInterpolator((Interpolator)new AccelerateInterpolator());
            this.barragePanelView.startAnimation((Animation)anim2);
            this.barragePanelView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BarragePanel.this.dismiss();
                }
            }, this.animationDuration);
        } else {
            this.dismiss();
        }
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    @Override
    public void onMsgClick(String msg, int bgColor) {
        if (this.uiCallback != null) {
            this.uiCallback.onMsgClick(msg, bgColor);
        }
    }

    @Override
    public void onInputBtnClick() {
        this.dismiss();
        if (this.uiCallback != null) {
            this.uiCallback.onInputBtnClick();
        }
    }

    private void dismiss() {
        if (this.barragePanelView == null) {
            return;
        }
        this.barragePanelView.setVisibility(4);
        this.root.setVisibility(8);
        this.isShowing = false;
    }

    public static interface LayoutStrategy {
        public int getPanelWidth(View var1);

        public int getPanelLeft(View var1);
    }

    private class DefaultLayoutStrategy
    implements LayoutStrategy {
        private DefaultLayoutStrategy() {
        }

        @Override
        public int getPanelWidth(View view) {
            int screenWidth = ResolutionUtils.getScreenWidth((Context)BarragePanel.this.context);
            int width = screenWidth - view.getWidth() * 2;
            return width;
        }

        @Override
        public int getPanelLeft(View view) {
            return view.getWidth();
        }
    }
}

