/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.widget;

import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.game.R;
import java.util.Random;

public class BarrageInputView
extends YYLinearLayout
implements View.OnClickListener {
    private static final String TAG = "BarrageInputView";
    private ImageView ivSend;
    private EditText etBarrage;
    private UiCallback uiCallback;
    private int[] bgColorList = ResourceUtils.getIntArray((int)R.array.barrage_bg_colors);
    private Random bgColorRandom = new Random();

    public BarrageInputView(Context context) {
        this(context, null);
    }

    public BarrageInputView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BarrageInputView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
        this.setBackgroundColor(-1);
    }

    private void createView(Context context) {
        this.setOrientation(0);
        LayoutInflater.from((Context)context).inflate(R.layout.view_barrage_input, (ViewGroup)this, true);
        this.ivSend = (ImageView)this.findViewById(R.id.iv_send);
        this.etBarrage = (EditText)this.findViewById(R.id.et_barrage);
        this.ivSend.setEnabled(false);
        this.etBarrage.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s == null || TextUtils.isEmpty((CharSequence)s.toString())) {
                    BarrageInputView.this.ivSend.setEnabled(false);
                } else {
                    BarrageInputView.this.ivSend.setEnabled(true);
                }
            }
        });
        InputFilter inputFilter = StringUtils.enterFilter();
        this.etBarrage.setFilters(new InputFilter[]{inputFilter, new InputFilter.LengthFilter(50)});
        this.ivSend.setOnClickListener((View.OnClickListener)this);
    }

    public EditText getEditText() {
        return this.etBarrage;
    }

    public void setUiCallback(UiCallback uiCallback) {
        this.uiCallback = uiCallback;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_send) {
            int bgColor = -16126;
            if (this.bgColorList != null && this.bgColorList.length > 0) {
                int colorIndex = this.bgColorRandom.nextInt(this.bgColorList.length);
                bgColor = this.bgColorList[colorIndex];
            }
            if (this.uiCallback != null) {
                this.uiCallback.onMsgSend(this.etBarrage.getText().toString(), bgColor);
                this.etBarrage.getText().clear();
            }
        }
    }

    public static interface UiCallback {
        public void onMsgSend(String var1, int var2);
    }
}

