/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.popview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.teammatch.ui.adapter.ModeChangeListAdapter;
import com.yy.game.wight.AbsPopView;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;
import java.util.List;

public class ModeChangeListPopView
extends AbsPopView
implements ModeChangeListAdapter.OnModeClickListener {
    private RecyclerView modeList;
    private ModeChangeListAdapter modeChangeListAdapter;
    private OnModeSelectListener modeSelectListener;

    public ModeChangeListPopView(Context context) {
        super(context);
    }

    @Override
    protected View createContentView(FrameLayout container) {
        View contentView = LayoutInflater.from((Context)container.getContext()).inflate(R.layout.view_mode_change_list, (ViewGroup)container, false);
        this.modeList = (RecyclerView)contentView.findViewById(R.id.list_mode);
        this.modeList.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(container.getContext(), 2));
        this.modeChangeListAdapter = new ModeChangeListAdapter();
        this.modeChangeListAdapter.setModeClickListener(this);
        this.modeList.setAdapter((RecyclerView.Adapter)this.modeChangeListAdapter);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)contentView.getLayoutParams();
        layoutParams.gravity = 80;
        container.addView(contentView, (ViewGroup.LayoutParams)layoutParams);
        return contentView;
    }

    public void setData(List<GameModeInfo> modeInfoList, int teamMemCount) {
        if (this.modeChangeListAdapter == null) {
            return;
        }
        this.modeChangeListAdapter.setCurrentTeamMemberCount(teamMemCount);
        this.modeChangeListAdapter.setData(modeInfoList);
    }

    public void setModeSelectListener(OnModeSelectListener modeSelectListener) {
        this.modeSelectListener = modeSelectListener;
    }

    @Override
    public void show(AbstractWindow window) {
        super.show(window);
        if (this.mContent != null) {
            TranslateAnimation enterAnim = new TranslateAnimation(0, 0.0f, 0, 0.0f, 1, 1.0f, 1, 0.0f);
            enterAnim.setDuration(250L);
            enterAnim.setInterpolator((Interpolator)new DecelerateInterpolator());
            this.mContent.startAnimation((Animation)enterAnim);
        }
    }

    @Override
    public void dismiss() {
        if (this.mContent != null) {
            TranslateAnimation exitAnim = new TranslateAnimation(0, 0.0f, 0, 0.0f, 1, 0.0f, 1, 1.0f);
            exitAnim.setDuration(200L);
            exitAnim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    ModeChangeListPopView.super.dismiss();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.mContent.startAnimation((Animation)exitAnim);
        }
    }

    @Override
    public void onModeClick(GameModeInfo modeInfo) {
        if (this.modeSelectListener != null) {
            this.modeSelectListener.onModeSelect(modeInfo);
        }
        this.dismiss();
    }

    public static interface OnModeSelectListener {
        public void onModeSelect(GameModeInfo var1);
    }
}

