/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.popview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.LanguageUtils;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.teammatch.model.TeamInfo;
import com.yy.game.gamemodule.teamgame.teammatch.module.TeamInviteServicesController;
import com.yy.game.gamemodule.teamgame.teammatch.ui.adapter.invite.HagoInviteAdapter;
import com.yy.game.gamemodule.teamgame.teammatch.ui.adapter.invite.InviteFriendPopItem;
import com.yy.game.wight.AbsPopView;
import com.yy.hiyo.game.base.TeamUserInfo;
import com.yy.hiyo.game.base.teamgame.InviteFriendData;
import com.yy.hiyo.game.base.teamgame.InviteItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class HagoInviteRightPopView
extends AbsPopView {
    private HagoInviteAdapter.IInviteCallback mCallback;
    private YYLinearLayout llEmptyTips;
    private RecyclerView rvList;
    private HagoInviteAdapter mAdapter;
    private List<InviteItem> rawDatas = new ArrayList<InviteItem>();
    private TeamInfo mTeamInfo;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public HagoInviteRightPopView(Context context, HagoInviteAdapter.IInviteCallback callback2) {
        super(context);
        this.mCallback = callback2;
    }

    @Override
    protected View createContentView(FrameLayout container) {
        View contentView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.hago_invite_pop_view, (ViewGroup)container, false);
        this.llEmptyTips = (YYLinearLayout)contentView.findViewById(R.id.ll_empty);
        this.rvList = (RecyclerView)contentView.findViewById(R.id.rv_friends);
        this.rvList.setVisibility(8);
        this.rvList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)contentView.getLayoutParams();
        layoutParams.gravity = LanguageUtils.isLtr() ? 5 : 3;
        container.addView(contentView, (ViewGroup.LayoutParams)layoutParams);
        return contentView;
    }

    @Override
    public void show(AbstractWindow window) {
        super.show(window);
        if (this.mContent != null) {
            TranslateAnimation enterAnim = new TranslateAnimation(1, LanguageUtils.isLtr() ? 1.0f : -1.0f, 1, 0.0f, 0, 0.0f, 0, 0.0f);
            enterAnim.setDuration(250L);
            enterAnim.setInterpolator((Interpolator)new DecelerateInterpolator());
            this.mContent.startAnimation((Animation)enterAnim);
        }
    }

    @Override
    public void dismiss() {
        if (this.mContent != null) {
            TranslateAnimation exitAnim = new TranslateAnimation(1, 0.0f, 1, LanguageUtils.isLtr() ? 1.0f : -1.0f, 0, 0.0f, 0, 0.0f);
            exitAnim.setDuration(200L);
            exitAnim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    HagoInviteRightPopView.super.dismiss();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.mContent.startAnimation((Animation)exitAnim);
        }
    }

    public void setDatas(TeamInviteServicesController.InviteFriendContainer container, TeamInfo mTeamInfo) {
        this.mTeamInfo = mTeamInfo;
        if (this.mAdapter == null) {
            this.mAdapter = new HagoInviteAdapter(R.layout.item_land);
            this.rvList.setAdapter((RecyclerView.Adapter)this.mAdapter);
            this.mAdapter.setCallback(this.mCallback);
        }
        if (container != null) {
            Kvo.removeKvoBinding((KvoSource)container, (Object)this, (String)"onInviteFriendsChange");
            Kvo.addKvoBinding((KvoSource)container, (Object)this, (String)"onInviteFriendsChange");
        }
        if (mTeamInfo != null) {
            this.mBinder.singleBindSourceTo((KvoSource)mTeamInfo);
        }
    }

    @KvoMethodAnnotation(name="teamUserInfoList", sourceClass=TeamInfo.class, thread=1)
    public void onSeatDatasChange(KvoEventIntent event) {
        CopyOnWriteArrayList infos = new CopyOnWriteArrayList((List)event.newValue());
        if (infos != null && !infos.isEmpty() && !this.rawDatas.isEmpty()) {
            HashSet<Long> uids = new HashSet<Long>();
            for (TeamUserInfo info : infos) {
                uids.add(info.getUid());
            }
            ArrayList<InviteItem> datas = new ArrayList<InviteItem>(this.rawDatas);
            Iterator itemIterator = datas.iterator();
            while (itemIterator.hasNext()) {
                InviteItem data = (InviteItem)itemIterator.next();
                if (!(data instanceof InviteFriendPopItem) || !uids.contains(((InviteFriendData)((InviteFriendPopItem)data).data).mFriends.getUid())) continue;
                itemIterator.remove();
            }
            if (datas.isEmpty()) {
                this.llEmptyTips.setVisibility(0);
                this.rvList.setVisibility(8);
            } else {
                this.llEmptyTips.setVisibility(8);
                this.rvList.setVisibility(0);
                this.mAdapter.setDatas(datas);
            }
        }
    }

    @KvoMethodAnnotation(name="friends", sourceClass=TeamInviteServicesController.InviteFriendContainer.class, thread=1)
    public void onInviteFriendsChange(KvoEventIntent event) {
        CopyOnWriteArrayList<InviteFriendData> list = new CopyOnWriteArrayList<InviteFriendData>(((TeamInviteServicesController.InviteFriendContainer)event.source()).friends);
        this.rawDatas.clear();
        if (list.isEmpty()) {
            this.llEmptyTips.setVisibility(0);
            this.rvList.setVisibility(8);
        } else {
            HashSet<Long> uids = new HashSet<Long>();
            if (this.mTeamInfo != null && this.mTeamInfo.getTeamUserInfoList() != null) {
                for (TeamUserInfo info : this.mTeamInfo.getTeamUserInfoList()) {
                    uids.add(info.getUid());
                }
            }
            ArrayList<InviteItem> items = new ArrayList<InviteItem>();
            for (InviteFriendData item : list) {
                InviteFriendPopItem data = new InviteFriendPopItem(item);
                this.rawDatas.add(data);
                if (uids.contains(item.mFriends.getUid())) continue;
                items.add(data);
            }
            if (items.isEmpty()) {
                this.llEmptyTips.setVisibility(0);
                this.rvList.setVisibility(8);
            } else {
                this.llEmptyTips.setVisibility(8);
                this.rvList.setVisibility(0);
                this.mAdapter.setDatas(items);
            }
        }
    }
}

