/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.component.normal;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.TranslateAnimation;
import android.widget.TextView;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.teammatch.ui.base.IUserView;

public class NormalUserView
extends YYRelativeLayout
implements IUserView {
    private RecycleImageView ivAvatar;
    private TextView tvWinCount;
    private TextView tvPlayCount;
    private View ivDecoTop;
    private View ivDecoLeft;
    private View ivDecoRight;
    private View ivBackLight;
    private AnimationSet animationSet;

    public NormalUserView(Context context) {
        super(context);
        this.createView(context);
    }

    public NormalUserView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public NormalUserView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.view_teamgame_record, (ViewGroup)this, true);
        this.ivAvatar = (RecycleImageView)this.findViewById(R.id.iv_avatar);
        this.tvWinCount = (TextView)this.findViewById(R.id.tv_win_count);
        this.tvPlayCount = (TextView)this.findViewById(R.id.tv_play_count);
        this.ivDecoTop = this.findViewById(R.id.iv_avatar_deco_top);
        this.ivDecoLeft = this.findViewById(R.id.iv_avatar_deco_left);
        this.ivDecoRight = this.findViewById(R.id.iv_avatar_deco_right);
        this.ivBackLight = this.findViewById(R.id.iv_back_light);
        this.tvWinCount.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.tvWinCount.getPaint().setFakeBoldText(true);
        this.tvPlayCount.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.tvPlayCount.getPaint().setFakeBoldText(true);
    }

    @Override
    public View getView() {
        return this;
    }

    public void startDecorationAnim() {
        View[] decoViews;
        if (this.animationSet != null) {
            return;
        }
        this.animationSet = new AnimationSet(false);
        RotateAnimation backLightAnim = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        backLightAnim.setDuration(8000L);
        backLightAnim.setFillAfter(true);
        backLightAnim.setInterpolator((Interpolator)new LinearInterpolator());
        backLightAnim.setRepeatMode(1);
        backLightAnim.setRepeatCount(-1);
        this.ivBackLight.setAnimation((Animation)backLightAnim);
        this.animationSet.addAnimation((Animation)backLightAnim);
        for (View view : decoViews = new View[]{this.ivDecoTop, this.ivDecoLeft, this.ivDecoRight}) {
            TranslateAnimation decoAnim = new TranslateAnimation(0.0f, 0.0f, -10.0f, 10.0f);
            decoAnim.setDuration(1000L);
            decoAnim.setFillAfter(true);
            decoAnim.setInterpolator((Interpolator)new LinearInterpolator());
            decoAnim.setRepeatMode(2);
            decoAnim.setRepeatCount(-1);
            view.setAnimation((Animation)decoAnim);
            this.animationSet.addAnimation((Animation)decoAnim);
        }
        this.animationSet.start();
    }

    private void stopDecorationAnim() {
        if (this.animationSet != null) {
            this.animationSet.cancel();
        }
        this.animationSet = null;
    }

    @Override
    public void setUserAvatar(String url, int sex) {
        String thumbUrl = "" + url + YYImageUtils.getThumbnailPostfix((int)75);
        ImageLoader.loadImage((RecycleImageView)this.ivAvatar, (String)thumbUrl, (int)AvatarUtils.getDefaultAvatar((int)sex));
        this.post(new Runnable(){

            @Override
            public void run() {
                NormalUserView.this.startDecorationAnim();
            }
        });
    }

    @Override
    public void setWinCount(int count) {
        this.tvWinCount.setText((CharSequence)("" + count));
    }

    @Override
    public void setPlayCount(int count) {
        this.tvPlayCount.setText((CharSequence)("" + count));
    }

    @Override
    public void setVisibility(int visibility) {
        int lastVisibility = this.getVisibility();
        if (visibility == lastVisibility) {
            return;
        }
        if (visibility == 0) {
            this.startDecorationAnim();
        } else {
            this.stopDecorationAnim();
        }
        super.setVisibility(visibility);
    }
}

