/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.component.normal;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.game.DR;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.teammatch.ui.base.IBottomView;
import com.yy.game.gamemodule.teamgame.teammatch.ui.widget.InviteListView;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.game.base.teamgame.IInviteCallback;
import com.yy.hiyo.game.base.teamgame.InviteItem;
import java.util.List;

public class NormalBottomView
extends YYRelativeLayout
implements IBottomView {
    private TextView tvBtn;
    private View ivMatchingCancel;
    private View ivChatBtn;
    private View llInviteTips;
    private View ivInviteTipsArrow;
    private IBottomView.UiCallback uiCallback;
    private boolean isMatching;
    private Animation tipsAnimation;
    private InviteTipsTimer inviteTipsTimer;
    private InviteListView vInviteList;
    private SVGAImageView matchGuideView;
    private Button btnTestPlay;
    private Button btnTestAddPlayer;

    public NormalBottomView(Context context) {
        super(context);
        this.createView(context);
    }

    public NormalBottomView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public NormalBottomView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.view_bottom_operation, (ViewGroup)this, true);
        this.tvBtn = (TextView)this.findViewById(R.id.tv_center_btn);
        this.ivMatchingCancel = this.findViewById(R.id.iv_matching_cancel);
        this.ivChatBtn = this.findViewById(R.id.iv_chat_btn);
        this.llInviteTips = this.findViewById(R.id.view_invite_tips);
        this.ivInviteTipsArrow = this.findViewById(R.id.iv_invite_tips_arrow);
        this.vInviteList = (InviteListView)this.findViewById(R.id.view_invite);
        this.matchGuideView = (SVGAImageView)this.findViewById(R.id.svga_matching_guide);
        this.btnTestPlay = (Button)this.findViewById(R.id.test_play_btn);
        this.btnTestAddPlayer = (Button)this.findViewById(R.id.test_add_btn);
        this.tvBtn.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (NormalBottomView.this.uiCallback == null) {
                    return;
                }
                int viewId = v.getId();
                if (viewId == R.id.tv_center_btn) {
                    NormalBottomView.this.uiCallback.onBtnClick();
                } else if (viewId == R.id.iv_matching_cancel) {
                    NormalBottomView.this.uiCallback.onMatchCancelClick();
                } else if (viewId == R.id.iv_chat_btn) {
                    NormalBottomView.this.uiCallback.onChatBtnClick();
                } else if (viewId == R.id.test_play_btn) {
                    NormalBottomView.this.uiCallback.onTestPlay();
                } else if (viewId == R.id.test_add_btn) {
                    NormalBottomView.this.uiCallback.onTestAddPlayer();
                }
            }
        };
        this.tvBtn.setOnClickListener(onClickListener);
        this.ivMatchingCancel.setOnClickListener(onClickListener);
        this.ivChatBtn.setOnClickListener(onClickListener);
        this.btnTestPlay.setOnClickListener(onClickListener);
        this.btnTestAddPlayer.setOnClickListener(onClickListener);
        this.showMatchBtn();
        if (RuntimeContext.sIsDebuggable) {
            this.btnTestPlay.setVisibility(0);
            this.btnTestAddPlayer.setVisibility(0);
        } else {
            this.btnTestPlay.setVisibility(8);
            this.btnTestAddPlayer.setVisibility(8);
        }
    }

    @Override
    public void setMatching(boolean isMatching) {
        this.isMatching = isMatching;
        if (isMatching) {
            this.ivMatchingCancel.setVisibility(8);
            this.vInviteList.setVisibility(8);
        } else {
            this.ivMatchingCancel.setVisibility(8);
            this.vInviteList.setVisibility(0);
        }
    }

    @Override
    public void showMatchBtn() {
        this.setViewBackground((View)this.tvBtn, this.createCenterBtnBg(-16126));
        this.tvBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.team_game_btn_match));
    }

    @Override
    public void showPlayBtn() {
        this.setViewBackground((View)this.tvBtn, this.createCenterBtnBg(-46483));
        this.tvBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.team_game_btn_play));
    }

    private Drawable createCenterBtnBg(int bgColor) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        GradientDrawable pressedBg = new GradientDrawable();
        int pressedColor = bgColor & 0xFFFFFF | 0xB2000000;
        pressedBg.setColor(pressedColor);
        pressedBg.setCornerRadius((float)ResolutionUtils.dip2Px((float)24.0f));
        stateListDrawable.addState(new int[]{16842919}, (Drawable)pressedBg);
        GradientDrawable normalBg = new GradientDrawable();
        normalBg.setColor(bgColor);
        normalBg.setCornerRadius((float)ResolutionUtils.dip2Px((float)24.0f));
        stateListDrawable.addState(new int[0], (Drawable)normalBg);
        return stateListDrawable;
    }

    private void setViewBackground(View view, Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable2);
        } else {
            view.setBackgroundDrawable(drawable2);
        }
    }

    @Override
    public void setCenterBtnShow(boolean isShow) {
        if (isShow) {
            this.tvBtn.setVisibility(0);
        } else {
            this.tvBtn.setVisibility(4);
        }
    }

    @Override
    public void setBarrageBtnShow(boolean isShow) {
        if (this.ivChatBtn == null) {
            return;
        }
        if (isShow) {
            this.ivChatBtn.setVisibility(0);
        } else {
            this.ivChatBtn.setVisibility(8);
        }
    }

    @Override
    public void setInviteViewShow(boolean isShow) {
        if (isShow) {
            this.vInviteList.setVisibility(0);
        } else {
            this.vInviteList.setVisibility(4);
        }
    }

    @Override
    public void showInviteTips() {
        if (this.llInviteTips == null) {
            return;
        }
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.llInviteTips.getLayoutParams();
        if (this.isMatching) {
            lp.addRule(10);
            lp.topMargin = ResolutionUtils.dip2Px((float)50.0f);
            lp.addRule(2, 0);
            this.ivInviteTipsArrow.setVisibility(4);
        } else {
            lp.addRule(10, 0);
            lp.topMargin = 0;
            lp.addRule(2, R.id.view_invite);
            this.ivInviteTipsArrow.setVisibility(0);
        }
        this.llInviteTips.setVisibility(0);
        if (this.tipsAnimation != null && !this.tipsAnimation.hasEnded()) {
            this.tipsAnimation.cancel();
        }
        this.tipsAnimation = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, 0.5f, 1, 1.0f);
        this.tipsAnimation.setDuration(200L);
        this.tipsAnimation.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.llInviteTips.setAnimation(this.tipsAnimation);
        this.tipsAnimation.start();
        if (this.inviteTipsTimer == null) {
            this.inviteTipsTimer = new InviteTipsTimer();
        }
        this.postDelayed(this.inviteTipsTimer, 3000L);
    }

    @Override
    public void hideInviteTips() {
        if (this.tipsAnimation != null && !this.tipsAnimation.hasEnded()) {
            this.tipsAnimation.cancel();
        }
        if (this.llInviteTips == null) {
            return;
        }
        this.tipsAnimation = null;
        if (this.inviteTipsTimer != null) {
            this.removeCallbacks(this.inviteTipsTimer);
        }
        this.llInviteTips.setVisibility(8);
    }

    @Override
    public void showMatchCancelBtn() {
        if (this.ivMatchingCancel != null) {
            this.ivMatchingCancel.setVisibility(0);
        }
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public View getChatBtn() {
        return this.ivChatBtn;
    }

    @Override
    public void setUiCallback(IBottomView.UiCallback uiCallback) {
        this.uiCallback = uiCallback;
    }

    @Override
    public void setInviteDatas(List<InviteItem> datas) {
        if (this.vInviteList != null) {
            this.vInviteList.setDatas(datas);
        }
    }

    @Override
    public void setInviteCallback(IInviteCallback inviteCallback) {
        if (this.vInviteList != null) {
            this.vInviteList.setCallback(inviteCallback);
        }
    }

    @Override
    public void setMatchGuideVisible(boolean show2) {
        if (this.matchGuideView == null) {
            return;
        }
        if (show2) {
            this.matchGuideView.setVisibility(0);
            DyResLoader.INSTANCE.loadSvga(this.matchGuideView, DR.match_guide, new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity entity) {
                    if (NormalBottomView.this.matchGuideView != null) {
                        NormalBottomView.this.matchGuideView.startAnimation();
                    }
                }

                public void onFailed(Exception e) {
                }
            });
        } else {
            this.matchGuideView.setVisibility(8);
            this.matchGuideView.stopAnimation();
        }
    }

    @Override
    public boolean isCenterBtnShow() {
        return this.tvBtn != null && this.tvBtn.getVisibility() == 0;
    }

    @Override
    public void setInviteTotalGone(boolean totalGone) {
        if (this.vInviteList != null) {
            this.vInviteList.setTotalGone(totalGone);
        }
    }

    class InviteTipsTimer
    implements Runnable {
        InviteTipsTimer() {
        }

        @Override
        public void run() {
            if (NormalBottomView.this.llInviteTips != null && NormalBottomView.this.llInviteTips.getVisibility() == 0) {
                NormalBottomView.this.hideInviteTips();
            }
        }
    }
}

