/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.component.lanscape;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.helper.RuleGuideAnimHelper;
import com.yy.game.gamemodule.teamgame.teammatch.ui.TeamCoinTipsHelper;
import com.yy.game.gamemodule.teamgame.teammatch.ui.base.ITopView;
import com.yy.game.gamemodule.teamgame.teammatch.ui.widget.ModeSwitcher;

public class LandscapeTopView
extends YYRelativeLayout
implements ITopView,
View.OnClickListener {
    private TextView tvTitle;
    private View ivBack;
    private View ivRules;
    private View ruleTip;
    private ITopView.UiCallback uiCallback;
    private View tipBackView;
    private LinearLayout llModeSelect;
    private ImageView ivModeSelectArrow;
    private ModeSwitcher modeSwitcher;
    private RuleGuideAnimHelper ruleGuideAnimHelper;
    private YYTextView tvGoldTips;
    private YYTextView tvGoldChange;
    private YYLinearLayout llCoins;
    private TeamCoinTipsHelper coinTipsHelper = new TeamCoinTipsHelper();

    public LandscapeTopView(Context context) {
        super(context);
        this.createView(context);
    }

    public LandscapeTopView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public LandscapeTopView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.view_room_land_top, (ViewGroup)this, true);
        this.tvTitle = (TextView)this.findViewById(R.id.tv_title);
        this.ivBack = this.findViewById(R.id.iv_back);
        this.ivRules = this.findViewById(R.id.iv_rules);
        this.ruleTip = this.findViewById(R.id.team_tip);
        this.tipBackView = this.findViewById(R.id.guide_tip_back);
        this.llModeSelect = (LinearLayout)this.findViewById(R.id.rl_mode_select);
        this.ivModeSelectArrow = (ImageView)this.findViewById(R.id.iv_mode_select_arrow);
        this.modeSwitcher = (ModeSwitcher)this.findViewById(R.id.ts_mode);
        this.tvGoldTips = (YYTextView)this.findViewById(R.id.tv_gold_tips);
        this.tvGoldTips = (YYTextView)this.findViewById(R.id.tv_gold_tips);
        this.tvGoldChange = (YYTextView)this.findViewById(R.id.tv_gold_change);
        this.llCoins = (YYLinearLayout)this.findViewById(R.id.ll_coins);
        this.tvTitle.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.ivBack.setOnClickListener((View.OnClickListener)this);
        this.ivRules.setOnClickListener((View.OnClickListener)this);
        this.ruleTip.setOnClickListener((View.OnClickListener)this);
        this.llModeSelect.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void setTitle(String title) {
        this.tvTitle.setText((CharSequence)title);
    }

    @Override
    public void setMode(String mode) {
        this.modeSwitcher.setText(mode);
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public void setRulesIconShow(boolean isShow) {
        if (isShow) {
            this.ivRules.setVisibility(0);
        } else {
            this.ivRules.setVisibility(8);
        }
    }

    @Override
    public void stratRuleTipAnim() {
        if (this.ruleGuideAnimHelper == null) {
            this.ruleGuideAnimHelper = new RuleGuideAnimHelper(this.ivRules, this.tipBackView, this.ruleTip);
        }
        this.ruleGuideAnimHelper.startGuideAnim();
    }

    @Override
    public void hideRuleTip() {
        if (this.ruleGuideAnimHelper != null) {
            this.ruleGuideAnimHelper.stopGuideAnim();
        }
    }

    @Override
    public void setBackIconShow(boolean isShow) {
        if (isShow) {
            this.ivBack.setVisibility(0);
        } else {
            this.ivBack.setVisibility(8);
        }
    }

    @Override
    public void setModeClickable(boolean clickable) {
        if (clickable) {
            this.llModeSelect.setBackgroundResource(R.drawable.selector_game_mode_select);
            this.ivModeSelectArrow.setVisibility(0);
        } else {
            this.llModeSelect.setBackgroundResource(0);
            this.ivModeSelectArrow.setVisibility(4);
        }
    }

    @Override
    public void setModeClickEnable(boolean enable) {
        if (enable) {
            this.modeSwitcher.setTextColor(-1);
            this.ivModeSelectArrow.setImageResource(R.drawable.ic_game_mode_select_arrow);
        } else {
            this.modeSwitcher.setTextColor(Integer.MAX_VALUE);
            this.ivModeSelectArrow.setImageResource(R.drawable.ic_game_mode_select_arrow_disable);
        }
    }

    @Override
    public void setUiCallback(ITopView.UiCallback uiCallback) {
        this.uiCallback = uiCallback;
    }

    @Override
    public void updateGoldConfig(String tips, long totalAmount, long changeAmount, boolean animate) {
        if (this.llCoins != null) {
            this.coinTipsHelper.updateCoinGameConfig(tips, this.tvGoldTips, this.tvGoldChange, this.llCoins, totalAmount, changeAmount, animate);
        }
    }

    @Override
    public void updateGoldViewVisibility(boolean visibility) {
        if (this.llCoins != null) {
            this.llCoins.setVisibility(visibility ? 0 : 8);
        }
    }

    public void onClick(View v) {
        if (this.uiCallback == null) {
            return;
        }
        int viewId = v.getId();
        if (viewId == R.id.iv_back) {
            this.uiCallback.onBackClick();
        } else if (viewId == R.id.iv_rules) {
            this.uiCallback.onRulesClick();
        } else if (viewId == R.id.team_tip) {
            this.uiCallback.onTipClick();
        } else if (viewId == R.id.rl_mode_select) {
            this.uiCallback.onModeClick();
        }
    }
}

