/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.component.lanscape;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.flexbox.FlexboxLayout;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYScrollView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.teammatch.ui.base.ISeatView;
import java.util.ArrayList;
import java.util.List;

public class LandscapeSeatView
extends YYFrameLayout
implements ISeatView,
View.OnClickListener {
    private static final String TAG = "NormalSeatView";
    private FlexboxLayout flexboxLayout;
    private YYScrollView scrollView;
    private List<SeatViewHolder> seatViewHolderList = new ArrayList<SeatViewHolder>();
    private ISeatView.UiCallback uiCallback;
    private int seatItemWidth;

    public LandscapeSeatView(Context context) {
        this(context, null);
    }

    public LandscapeSeatView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LandscapeSeatView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.scrollView = new YYScrollView(this.getContext());
        this.scrollView.setVerticalFadingEdgeEnabled(true);
        this.scrollView.setFadingEdgeLength(ResolutionUtils.dip2Px((float)20.0f));
        this.scrollView.setVerticalScrollBarEnabled(false);
        this.scrollView.setOverScrollMode(2);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -2);
        lp.gravity = 17;
        this.addView((View)this.scrollView, (ViewGroup.LayoutParams)lp);
        this.flexboxLayout = new FlexboxLayout(this.getContext());
        this.flexboxLayout.setFlexWrap(1);
        this.flexboxLayout.setJustifyContent(2);
        this.scrollView.addView((View)this.flexboxLayout, -1, -2);
    }

    @Override
    public void setUiCallback(ISeatView.UiCallback uiCallback) {
        this.uiCallback = uiCallback;
    }

    @Override
    public int getSeatItemWidth() {
        return this.seatItemWidth;
    }

    @Override
    public void initSeatCount(int count, int maxWidth) {
        this.flexboxLayout.removeAllViews();
        this.seatViewHolderList.clear();
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        int avatarLRMargin = ResourceUtils.getDimen((int)R.dimen.landscape_seat_avatar_lr_margin);
        int nameLRMargin = ResourceUtils.getDimen((int)R.dimen.landscape_seat_name_lr_margin);
        int maxAvailWidth = ResolutionUtils.dip2Px((float)53.0f) + avatarLRMargin * 2;
        int finalWidth = Math.min(maxAvailWidth, maxWidth);
        int avatarSize = finalWidth - avatarLRMargin * 2;
        int nameWidth = finalWidth - nameLRMargin * 2;
        for (int i = 0; i < count; ++i) {
            View seatView = layoutInflater.inflate(R.layout.view_seat_landscape, (ViewGroup)this, false);
            SeatViewHolder seatViewHolder = new SeatViewHolder(seatView, i);
            this.flexboxLayout.addView(seatView);
            ViewGroup.LayoutParams avatarLp = seatViewHolder.ivAvatar.getLayoutParams();
            avatarLp.width = avatarSize;
            avatarLp.height = avatarSize;
            ViewGroup.LayoutParams nameLp = seatViewHolder.tvName.getLayoutParams();
            nameLp.width = nameWidth;
            ViewGroup.LayoutParams rootLp = seatViewHolder.rootView.getLayoutParams();
            rootLp.width = finalWidth;
            rootLp.height = avatarSize + ResolutionUtils.dip2Px((float)34.0f);
            this.seatViewHolderList.add(seatViewHolder);
            seatViewHolder.setOnClickListener(i, this);
            seatViewHolder.setHomeOwner(i == 0);
            seatViewHolder.setStatusNone();
        }
        this.seatItemWidth = finalWidth;
    }

    @Override
    public void setNameShow(boolean isShow) {
        for (SeatViewHolder holder : this.seatViewHolderList) {
            holder.setNameShow(isShow);
        }
    }

    @Override
    public void setSeatMatching(int position) {
        if (position < 0 || position >= this.seatViewHolderList.size()) {
            return;
        }
        SeatViewHolder seatViewHolder = this.seatViewHolderList.get(position);
        seatViewHolder.setStatusMatching();
    }

    @Override
    public void setSeatReady(int position, UserInfoKS userInfo) {
        if (position < 0 || position >= this.seatViewHolderList.size()) {
            return;
        }
        SeatViewHolder seatViewHolder = this.seatViewHolderList.get(position);
        seatViewHolder.setSatusReady(userInfo);
    }

    @Override
    public void setSeatNone(int position) {
        if (position < 0 || position >= this.seatViewHolderList.size()) {
            return;
        }
        SeatViewHolder seatViewHolder = this.seatViewHolderList.get(position);
        seatViewHolder.setStatusNone();
    }

    public void onClick(View v) {
        Integer position = (Integer)v.getTag();
        if (position == null) {
            return;
        }
        if (this.uiCallback != null) {
            this.uiCallback.onSeatClick(position);
        }
    }

    @Override
    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
    }

    @Override
    public View getView() {
        return this;
    }

    class SeatViewHolder {
        private static final int STATUS_NONE = 0;
        private static final int STATUS_MATCHING = 1;
        private static final int STATUS_READY = 2;
        private int position;
        private View rootView;
        private RecycleImageView ivCover;
        private CircleImageView ivAvatar;
        private View ivHomeOwnerFlag;
        private TextView tvName;
        private String avatarUrl;
        private String name;
        private Animation anim;
        private int status = 0;
        private boolean isHomeOwner = false;

        SeatViewHolder(View view, int position) {
            this.position = position;
            this.rootView = view;
            this.ivAvatar = (CircleImageView)view.findViewById(R.id.iv_avatar);
            this.ivCover = (RecycleImageView)view.findViewById(R.id.iv_cover);
            this.ivHomeOwnerFlag = view.findViewById(R.id.iv_flag);
            this.tvName = (TextView)view.findViewById(R.id.tv_name);
        }

        public void setOnClickListener(int position, View.OnClickListener onClickListener) {
            this.rootView.setTag((Object)position);
            this.rootView.setOnClickListener(onClickListener);
        }

        public void setNameShow(boolean isShow) {
            if (isShow) {
                this.tvName.setVisibility(0);
            } else {
                this.tvName.setVisibility(4);
            }
        }

        public void setHomeOwner(boolean isHomeOwner) {
            this.isHomeOwner = isHomeOwner;
        }

        public void setStatusNone() {
            if (this.status == 0) {
                return;
            }
            this.stopMatchingAnim();
            this.ivCover.setVisibility(8);
            this.ivHomeOwnerFlag.setVisibility(8);
            this.ivAvatar.setBorderWidth(0);
            this.ivAvatar.setImageResource(R.drawable.img_empty_seat);
            this.tvName.setText((CharSequence)"");
            this.status = 0;
        }

        public void setStatusMatching() {
            if (this.status == 1) {
                return;
            }
            this.ivHomeOwnerFlag.setVisibility(8);
            this.ivAvatar.setBorderWidth(0);
            this.ivAvatar.setImageResource(R.drawable.img_empty_seat);
            this.tvName.setText((CharSequence)"");
            this.status = 1;
        }

        public void setSatusReady(UserInfoKS userInfo) {
            this.stopMatchingAnim();
            this.ivCover.setVisibility(8);
            this.avatarUrl = userInfo != null ? userInfo.avatar : "";
            this.name = userInfo != null ? userInfo.nick : "";
            this.ivAvatar.setBorderWidth(ResolutionUtils.dip2Px((float)3.0f));
            String thumbUrl = "" + this.avatarUrl + YYImageUtils.getThumbnailPostfix((int)75);
            ImageLoader.loadImage((RecycleImageView)this.ivAvatar, (String)thumbUrl, (int)AvatarUtils.getDefaultAvatar((int)(userInfo != null ? userInfo.sex : 0)));
            if (this.isHomeOwner) {
                this.ivAvatar.setBorderColor(-16126);
                this.ivHomeOwnerFlag.setVisibility(0);
            } else {
                this.ivAvatar.setBorderColor(-1);
                this.ivHomeOwnerFlag.setVisibility(8);
            }
            this.tvName.setText((CharSequence)this.name);
            this.status = 2;
        }

        private void startMatchingAnim() {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)LandscapeSeatView.TAG, (String)"matching animation start, position = %d", (Object[])new Object[]{this.position});
            }
            if (this.anim != null) {
                this.anim.cancel();
                this.anim.reset();
            } else {
                this.anim = new RotateAnimation(0.0f, -360.0f, 1, 0.5f, 1, 0.5f);
                this.anim.setDuration(2000L);
                this.anim.setFillAfter(false);
                this.anim.setInterpolator((Interpolator)new LinearInterpolator());
                this.anim.setRepeatMode(1);
                this.anim.setRepeatCount(-1);
            }
            this.ivCover.startAnimation(this.anim);
            this.ivCover.setVisibility(0);
        }

        private void stopMatchingAnim() {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)LandscapeSeatView.TAG, (String)"matching animation stop, position = %d", (Object[])new Object[]{this.position});
            }
            if (this.anim != null) {
                this.anim.cancel();
            }
            this.ivCover.setVisibility(8);
        }
    }
}

