/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.component;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;
import com.yy.hiyo.game.base.widget.IMatchSuccessView;
import com.yy.hiyo.game.base.widget.MatchSuccessAvatarView;
import java.util.List;

public class MatchSuccessView
extends YYRelativeLayout
implements IMatchSuccessView {
    private TextView mTvTitle;
    private MatchSuccessAvatarView mAvatarView;
    private TextView mTvDesc;
    private int mTitleAvatarSpace;

    public MatchSuccessView(Context context) {
        super(context);
        this.createView();
    }

    public MatchSuccessView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.MatchSuccessView);
        this.mTitleAvatarSpace = ta.getDimensionPixelSize(R.styleable.MatchSuccessView_title_avatar_space, ResolutionUtils.dip2Px((float)30.0f));
        ta.recycle();
        this.createView();
    }

    private void createView() {
        MatchSuccessView.inflate((Context)this.getContext(), (int)R.layout.layout_match_success_view, (ViewGroup)this);
        this.mTvTitle = (TextView)this.findViewById(R.id.tv_title);
        FontUtils.setFontType((TextView)this.mTvTitle, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mAvatarView = (MatchSuccessAvatarView)this.findViewById(R.id.view_avatars);
        RelativeLayout.LayoutParams avatarViewLp = (RelativeLayout.LayoutParams)this.mAvatarView.getLayoutParams();
        avatarViewLp.topMargin = this.mTitleAvatarSpace;
        this.mTvDesc = (TextView)this.findViewById(R.id.tv_desc);
    }

    public void setData(List<UserInfoKS> userList) {
        if (FP.empty(userList)) {
            return;
        }
        this.mAvatarView.setData(userList);
        this.mTvDesc.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_matched_other_users, (Object[])new Object[]{userList.size()}));
    }

    public void setStringData(List<String> mUserHead) {
    }
}

